;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9b/Ast/labels.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Jan  1 11:37:29 1995                          */
;*    Last change :  Tue Apr  8 15:18:19 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `labels->node' translator                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_labels
   (include "Ast/node.sch"
	    "Tools/trace.sch")
   (import  tools_error
	    tools_progn
	    tools_args
	    tools_location
	    tools_dsssl
	    type_cache
	    ast_sexp
	    ast_ident
	    ast_local)
   (export (labels->node::let-fun <sexp> <stack> ::obj ::symbol)))

;*---------------------------------------------------------------------*/
;*    labels->node ...                                                 */
;*---------------------------------------------------------------------*/
(define (labels->node exp stack loc site)
   (let ((loc (find-location/loc exp loc)))
      (match-case exp
         ((?- (and (? pair?) ?bindings) . ?body)
          (let* ((locals    (allocate-sfuns bindings loc))
                 (new-stack (append locals stack))
		 (body      (sexp->node (normalize-progn body)
					new-stack
					loc
					site))
		 (loc       (find-location/loc exp loc)))
	     ;; we compute the ast for all local bodies
	     (for-each (lambda (fun b) (labels-binding fun b new-stack loc))
		       locals
		       bindings)
	     ;; and we allocate the let-fun node
	     (instantiate::let-fun (loc loc)
				   (type (node-type body))
				   (locals locals)
				   (body body))))
         (else
	  (error-sexp->node "Illegal `labels' expression" exp loc)))))

;*---------------------------------------------------------------------*/
;*    allocate-sfuns ...                                               */
;*---------------------------------------------------------------------*/
(define (allocate-sfuns bindings loc)
   (let loop ((bindings bindings)
	      (res      '()))
      (if (null? bindings)
	  (reverse! res)
	  (match-case (car bindings)
	     (((and (? symbol?) ?fun) ?args . ?-)
	      (let* ((id.type (parse-id fun))
		     (id      (car id.type))
		     (type    (cdr id.type))
		     (arity   (arity args))
		     (formals (map parse-id (dsssl-args*->args-list args))))
		 ;; we check that the last formals is correct
		 (if (or (>=fx arity 0)
			 (let* ((larg (car (last-pair formals)))
				(type (cdr larg)))
			    (cond
			       ((eq? type *obj*)
				#t)
			       ((eq? type *_*)
				(set-cdr! larg *obj*)
				#t)
			       (else
				#f))))
		     (let* ((args (map (lambda (f)
					  (make-local-svar (car f) (cdr f)))
				       formals))
			    (sfun (instantiate::sfun (class 'plain)
						     (arity arity)
						     (args args)))
			    (fun  (make-local-sfun id type sfun)))
			(loop (cdr bindings) (cons fun res)))
		     (begin
			(error-sexp->node "Illegal formal type"
				       (car bindings)
				       loc)
			'()))))
	     (else
	      (error-sexp->node "Illegal `binding' form"
				(car bindings)
				loc)
	      '())))))
				   
;*---------------------------------------------------------------------*/
;*    labels-binding ...                                               */
;*---------------------------------------------------------------------*/
(define (labels-binding local binding stack loc)
   (match-case binding
      ((?- ?args . ?body)
       (enter-function (local-id local))
       (let ((body (sexp->node (make-dsssl-function-prelude
				(local-id local)
				args
				(normalize-progn body)
				user-error)
			       (append (sfun-args (local-value local)) stack)
			       (find-location/loc binding loc)
			       'value)))
	  (sfun-body-set! (local-value local) body)
	  (leave-function)))
      (else
       (error-sexp->node "Illegal `labels' form" binding loc))))

