;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9c/Cfa/loose.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jun 25 12:02:51 1996                          */
;*    Last change :  Wed Sep 10 10:34:49 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Loosing approximations means values are going outside.           */
;*    Toping approximations means add top the sets.                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_loose
   (include "Tools/trace.sch")
   (import  type_type
	    tools_shape
	    ast_var
	    ast_node
	    cfa_iterate
	    cfa_set
	    cfa_info
	    cfa_approx
	    cfa_procedure)
   (export  (set-looser! looser)
	    (loose!::approx ::approx ::obj)
	    (generic loose-alloc! ::node)
	    (generic stack-loose-alloc! ::node ::obj)
	    (global-loose! ::global ::approx)
	    (stack-intern-sfun-loose! ::approx ::obj)))
 
;*---------------------------------------------------------------------*/
;*    *looser* ...                                                     */
;*---------------------------------------------------------------------*/
(define *looser* 'cfa)

;*---------------------------------------------------------------------*/
;*    set-looser! ...                                                  */
;*---------------------------------------------------------------------*/
(define (set-looser! looser)
   [assert (looser) (memq looser '(cfa stack))]
   (set! *looser* looser))

;*---------------------------------------------------------------------*/
;*    loose! ...                                                       */
;*---------------------------------------------------------------------*/
(define (loose!::approx approx::approx owner)
   (trace (cfa 4) "loose!(" *looser* "): " (shape approx) #\Newline)
   (if (eq? *looser* 'cfa)
       (cfa-loose! approx)
       (stack-loose! approx owner)))

;*---------------------------------------------------------------------*/
;*    cfa-loose! ...                                                   */
;*---------------------------------------------------------------------*/
(define (cfa-loose!::approx approx::approx)
   (with-access::approx approx (lost-stamp)
      (if (<fx lost-stamp *cfa-stamp*)
	  (begin
	     (set! lost-stamp *cfa-stamp*)
	     (for-each-approx-alloc loose-alloc! approx))))
   approx)

;*---------------------------------------------------------------------*/
;*    loose-alloc! ...                                                 */
;*---------------------------------------------------------------------*/
(define-generic (loose-alloc! node::node))

;*---------------------------------------------------------------------*/
;*    stack-loose! ...                                                 */
;*---------------------------------------------------------------------*/
(define (stack-loose!::approx approx::approx owner)
   (for-each-approx-alloc (lambda (alloc) (stack-loose-alloc! alloc owner))
			  approx)
   approx)

;*---------------------------------------------------------------------*/
;*    stack-loose-alloc! ...                                           */
;*---------------------------------------------------------------------*/
(define-generic (stack-loose-alloc! node::node owner))

;*---------------------------------------------------------------------*/
;*    global-loose! ...                                                */
;*    -------------------------------------------------------------    */
;*    Global variable are not allowed to hold optimized procedure      */
;*    because due to the module compilation we can ensure that         */
;*    the global variable is initialized and then, we always need      */
;*    to type check it (which cannot be performed with optimized       */
;*    procedures).                                                     */
;*---------------------------------------------------------------------*/
(define (global-loose! global approx)
   (trace (cfa 2)
	  "global-loose!: " (shape global) " " (shape approx) #\Newline)
   (cond
      ((memq (global-import global) '(import export))
       (loose! approx 'all))
      ((eq? *looser* 'stack)
       (disable-X-T! approx)
       (loose! approx 'all))
      (else
       (disable-X-T! approx))))

;*---------------------------------------------------------------------*/
;*    stack-intern-sfun-loose! ...                                     */
;*---------------------------------------------------------------------*/
(define (stack-intern-sfun-loose! approx owner)
   (trace (cfa 4)
	  "stack-intern-sfun-loose!: " (shape owner) " " (shape approx)
	  #\Newline)
   (if (eq? *looser* 'stack)
       (loose! approx owner)))
