;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Cfa/setup.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jun 25 14:08:53 1996                          */
;*    Last change :  Mon Mar 10 15:49:26 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We setup the ast for the Cfa.                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_setup
   (include "Tools/trace.sch")
   (import  type_type
	    type_cache
	    type_typeof
	    module_module
	    tools_shape
	    tools_error
	    ast_var
	    ast_node
	    cfa_info
	    cfa_approx)
   (export  (set-initial-approx! globals)
	    (generic node-setup! ::node)
	    (node-setup*! node*)))

;*---------------------------------------------------------------------*/
;*    set-initial-approx! ...                                          */
;*---------------------------------------------------------------------*/
(define (set-initial-approx! globals)
   (for-each (lambda (global)
		(let ((fun (global-value global)))
		   (fun-setup! fun global)
		   (for-each (lambda (local)
				(widen!::reshaped-local local)
				(variable-value-setup! (local-value local)
						       local))
			     (sfun-args fun)))
		(node-setup! (sfun-body (global-value global))))
	     globals))

;*---------------------------------------------------------------------*/
;*    node-setup! ...                                                  */
;*---------------------------------------------------------------------*/
(define-generic (node-setup! node::node))

;*---------------------------------------------------------------------*/
;*    node-setup! ::atom ...                                           */
;*---------------------------------------------------------------------*/
(define-method (node-setup! node::atom)
   (with-access::atom node (value)
      (widen!::atom/Cinfo node
	 (approx (make-type-approx (typeof-atom value))))))

;*---------------------------------------------------------------------*/
;*    node-setup! ::kwote ...                                          */
;*---------------------------------------------------------------------*/
(define-method (node-setup! node::kwote)
   (with-access::kwote node (value)
      (widen!::kwote/Cinfo node
	 (approx (make-type-approx (typeof-kwote value))))))
   
;*---------------------------------------------------------------------*/
;*    node-setup! ::kwote/node ...                                     */
;*---------------------------------------------------------------------*/
(define-method (node-setup! kwote::kwote/node)
   (with-access::kwote/node kwote (node value)
      (node-setup! node)))
   
;*---------------------------------------------------------------------*/
;*    node-setup! ::var ...                                            */
;*---------------------------------------------------------------------*/
(define-method (node-setup! node::var) 
   (with-access::var node (variable)
      (variable-value-setup! (variable-value variable) variable)
      ;; this widen! is only for the nice pretting of cfa_show
      (cond
	 ((and (local? variable) (not (reshaped-local? variable)))
	  (widen!::reshaped-local variable))
	 ((and (global? variable) (not (reshaped-global? variable)))
	  (widen!::reshaped-global variable)))))

;*---------------------------------------------------------------------*/
;*    alloc-type? ...                                                  */
;*    -------------------------------------------------------------    */
;*    This predicate returns #t for all type denoting data             */
;*    structures approximated by the cfa.                              */
;*---------------------------------------------------------------------*/
(define (alloc-type? type)
   (cond
      ((eq? type *vector*)
       #t)
      ((eq? type *procedure*)
       #t)
      ((eq? type *struct*)
       #t)
      (else
       #f)))

;*---------------------------------------------------------------------*/
;*    variable-value-setup! ...                                        */
;*---------------------------------------------------------------------*/
(define-generic (variable-value-setup! value::value variable::variable))

;*---------------------------------------------------------------------*/
;*    variable-value-setup! ::sfun ...                                 */
;*---------------------------------------------------------------------*/
(define-method (variable-value-setup! value::sfun var)
   ;; we reach this method when setting up a `make-procedure' call
   ;; on the second argument of this call.
   #unspecified)

;*---------------------------------------------------------------------*/
;*    variable-value-setup! ::svar ...                                 */
;*---------------------------------------------------------------------*/
(define-method (variable-value-setup! value::svar var)
   (if (global? var)
       (let ((value (widen!::svar/Cinfo value
		       (approx (make-type-approx (variable-type var))))))
	  (if (and (not (eq? (global-import var) 'static))
		   (alloc-type? (variable-type var)))
	      (approx-set-top! (svar/Cinfo-approx value))))
       (widen!::svar/Cinfo value
	  (approx (make-type-approx (variable-type var))))))

;*---------------------------------------------------------------------*/
;*    variable-value-setup! ::pre-clo-env ...                          */
;*---------------------------------------------------------------------*/
(define-method (variable-value-setup! value::pre-clo-env var)
   (trace (cfa 2) "Je set un pre-clo-env..." (shape var) #\Newline)
   (call-next-method)
   (svar/Cinfo-clo-env?-set! (local-value var) #t))

;*---------------------------------------------------------------------*/
;*    variable-value-setup! ::sexit ...                                */
;*---------------------------------------------------------------------*/
(define-method (variable-value-setup! value::sexit var)
   (widen!::sexit/Cinfo value
      (approx (make-type-approx (variable-type var)))))

;*---------------------------------------------------------------------*/
;*    variable-value-setup! ::scnst ...                                */
;*---------------------------------------------------------------------*/
(define-method (variable-value-setup! value::scnst/Cinfo var)
   'already-done)
   
;*---------------------------------------------------------------------*/
;*    variable-value-setup! ::scnst ...                                */
;*---------------------------------------------------------------------*/
(define-method (variable-value-setup! value::scnst var)
   (trace (cfa 2) "Je setup une scnst: " (shape var) " "
	  (shape (scnst-node value)) #\Newline)
   (if (global? var)
       (if (and (eq? (global-module var) *module*)
		(memq (scnst-class value) '(sfun sgfun))
		(pre-make-procedure-app? (scnst-node value)))
	   ;; this variable holds a closure
	   (let ((node (scnst-node value)))
	      (trace (cfa 2) "    et en plus, c'est une closure" #\Newline)
	      (node-setup! node)
	      (widen!::scnst/Cinfo value
		 (approx (make-procedure-app-approx node))))
	   (let ((value (widen!::scnst/Cinfo value
			   (approx (make-type-approx (variable-type var))))))
	      (approx-set-top! (scnst/Cinfo-approx value))))
       (widen!::scnst/Cinfo value
	  (approx (make-type-approx (variable-type var))))))

;*---------------------------------------------------------------------*/
;*    variable-value-setup! ::cvar ...                                 */
;*---------------------------------------------------------------------*/
(define-method (variable-value-setup! value::cvar var)
   (widen!::cvar/Cinfo value
      (approx (make-type-approx (variable-type var))))
   (if (alloc-type? (variable-type var))
       (approx-set-top! (cvar/Cinfo-approx value))))

;*---------------------------------------------------------------------*/
;*    node-setup! ::closure ...                                        */
;*---------------------------------------------------------------------*/
(define-method (node-setup! node::closure)
   (internal-error "node-setup!" "Unexpected closure" (shape node)))

;*---------------------------------------------------------------------*/
;*    node-setup! ::sequence ...                                       */
;*---------------------------------------------------------------------*/
(define-method (node-setup! node::sequence)
   (with-access::sequence node (nodes)
      (node-setup*! nodes)))

;*---------------------------------------------------------------------*/
;*    node-setup! ::app ...                                            */
;*---------------------------------------------------------------------*/
(define-method (node-setup! node::app)
   (with-access::app node (fun args)
      (node-setup*! args)
      (let ((variable (var-variable fun)))
	 (fun-setup! (variable-value variable) variable))))

;*---------------------------------------------------------------------*/
;*    fun-setup! ...                                                   */
;*---------------------------------------------------------------------*/
(define-generic (fun-setup! fun::fun var)
   (if (and (global? var) (not (reshaped-global? var)))
       (widen!::reshaped-global var))
   #unspecified) 

;*---------------------------------------------------------------------*/
;*    fun-setup! ::sfun ...                                            */
;*---------------------------------------------------------------------*/
(define-method (fun-setup! fun::sfun var)
   (if (and (global? var) (not (reshaped-global? var)))
       (widen!::reshaped-global var))
   (if (and (global? var) (eq? (global-import var) 'import))
       (let ((approx (make-type-approx (global-type var))))
	  (if (sfun-top? fun) (approx-set-top! approx))
	  (widen!::extern-sfun/Cinfo fun
	     (approx approx)))
       (widen!::intern-sfun/Cinfo fun
	  (approx (make-type-approx (variable-type var))))))

;*---------------------------------------------------------------------*/
;*    fun-setup! ::cfun ...                                            */
;*---------------------------------------------------------------------*/
(define-method (fun-setup! fun::cfun var)
   (if (not (reshaped-global? var))
       (widen!::reshaped-global var))
   (let ((approx (make-type-approx (global-type var))))
      (if (cfun-top? fun) (approx-set-top! approx))
      (widen!::cfun/Cinfo fun
	 (approx approx))))
 
;*---------------------------------------------------------------------*/
;*    node-setup! ::app-ly ...                                         */
;*---------------------------------------------------------------------*/
(define-method (node-setup! node::app-ly)
   (with-access::app-ly node (fun arg)
      (node-setup! fun)
      (node-setup! arg)
      (widen!::app-ly/Cinfo node
	 (approx (make-type-approx *obj*)))
      (approx-set-top! (app-ly/Cinfo-approx node))))

;*---------------------------------------------------------------------*/
;*    node-setup! ::funcall ...                                        */
;*---------------------------------------------------------------------*/
(define-method (node-setup! node::funcall)
   (with-access::funcall node (fun args)
      (node-setup! fun)
      (node-setup*! args)
      (widen!::funcall/Cinfo node
	 (approx (make-type-approx *obj*))
	 (va-approx (make-type-approx *obj*)))
      (approx-set-top! (funcall/Cinfo-va-approx node))))

;*---------------------------------------------------------------------*/
;*    node-setup! ::pragma ...                                         */
;*---------------------------------------------------------------------*/
(define-method (node-setup! node::pragma)
   (with-access::pragma node (args type)
      (node-setup*! args)
      (widen!::pragma/Cinfo node
	 (approx (make-type-approx type)))
      (approx-set-top! (pragma/Cinfo-approx node))))

;*---------------------------------------------------------------------*/
;*    node-setup! ::cast ...                                           */
;*---------------------------------------------------------------------*/
(define-method (node-setup! node::cast)
   (with-access::cast node (arg)
      (node-setup! arg)))

;*---------------------------------------------------------------------*/
;*    node-setup! ::setq ...                                           */
;*---------------------------------------------------------------------*/
(define-method (node-setup! node::setq)
   (with-access::setq node (var value)
      (node-setup! value)
      (node-setup! var)
      (widen!::setq/Cinfo node
	 (approx (make-type-approx *unspec*)))))

;*---------------------------------------------------------------------*/
;*    node-setup! ::conditional ...                                    */
;*---------------------------------------------------------------------*/
(define-method (node-setup! node::conditional)
   (with-access::conditional node (test true false)
       (node-setup! test)
       (node-setup! true)
       (node-setup! false)
       (widen!::conditional/Cinfo node
	  (approx (make-empty-approx)))))

;*---------------------------------------------------------------------*/
;*    node-setup! ::fail ...                                           */
;*---------------------------------------------------------------------*/
(define-method (node-setup! node::fail)
   (with-access::fail node (type proc msg obj)
      (node-setup! proc)
      (node-setup! msg)
      (node-setup! obj)
      (widen!::fail/Cinfo node
	 (approx (make-type-approx *obj*)))))

;*---------------------------------------------------------------------*/
;*    node-setup! ::select ...                                         */
;*---------------------------------------------------------------------*/
(define-method (node-setup! node::select)
   (with-access::select node (clauses test)
      (node-setup! test)
      (for-each (lambda (clause)
		   (node-setup! (cdr clause)))
		clauses)
      (widen!::select/Cinfo node
	 (approx (make-empty-approx)))))

;*---------------------------------------------------------------------*/
;*    node-setup! ::let-fun ...                                        */
;*---------------------------------------------------------------------*/
(define-method (node-setup! node::let-fun)
   (with-access::let-fun node (body locals)
      (for-each (lambda (l)
		   (widen!::reshaped-local l)
		   (let ((fun (local-value l)))
		      (for-each (lambda (local)
				   (widen!::reshaped-local local)
				   (variable-value-setup! (local-value local)
							  local))
				(sfun-args fun))
		      (node-setup! (sfun-body fun))))
		locals)
      (node-setup! body)))

;*---------------------------------------------------------------------*/
;*    node-setup! ::let-var ...                                        */
;*---------------------------------------------------------------------*/
(define-method (node-setup! node::let-var)
   (with-access::let-var node (body bindings)
      (trace (cfa 3) "let-var settup: " #\Newline)
      (for-each (lambda (binding)
		   (let ((var (car binding))
			 (val (cdr binding)))
		      (variable-value-setup! (local-value var) var)
		      ;; if the variable is read-only we set it a binding
		      ;; value to improve the approximations which require
		      ;; offset (such as make-procedure, procedure-ref)
		      (widen!::reshaped-local var
			 (binding-value (if (eq? (local-access var) 'read)
					    val
					    #f)))
		      (node-setup! val)
		      (trace (cfa 3) "  " (shape var) " ... " #\Newline)))
		bindings)
      (node-setup! body)))

;*---------------------------------------------------------------------*/
;*    node-setup! ::set-ex-it ...                                      */
;*---------------------------------------------------------------------*/
(define-method (node-setup! node::set-ex-it)
   (with-access::set-ex-it node (var body)
      (node-setup! body)
      (node-setup! var)
      (widen!::reshaped-local (var-variable var))
      (widen!::set-ex-it/Cinfo node
	 (approx (make-type-approx *obj*)))
      (approx-set-top! (set-ex-it/Cinfo-approx node))))

;*---------------------------------------------------------------------*/
;*    node-setup! ::jump-ex-it ...                                     */
;*---------------------------------------------------------------------*/
(define-method (node-setup! node::jump-ex-it)
   (with-access::jump-ex-it node (exit value)
      (node-setup! exit) 
      (node-setup! value)
      (widen!::jump-ex-it/Cinfo node
	 (approx (make-type-approx *obj*)))
      (approx-set-top! (jump-ex-it/Cinfo-approx node))))

;*---------------------------------------------------------------------*/
;*    node-setup*! ...                                                 */
;*---------------------------------------------------------------------*/
(define (node-setup*! node*)
   (for-each node-setup! node*))


