;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Expand/let.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jun 19 08:29:58 1992                          */
;*    Last change :  Mon Aug  5 10:48:28 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Let expansions.                                                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module expand_let
   (import  tools_progn
	    tools_args
	    tools_misc
	    expand_lambda
	    expand_eps)
   (export  (expand-let*   ::obj ::procedure)
	    (expand-let    ::obj ::procedure)
	    (expand-letrec ::obj ::procedure)
	    (expand-labels ::obj ::procedure)))
 
;*---------------------------------------------------------------------*/
;*    expand-let* ...                                                  */
;*---------------------------------------------------------------------*/
(define (expand-let* x e)
   (let ((old-internal internal-definition?))
      (set! internal-definition? #t)
      (let* ((e   (internal-begin-expander e))
	     (res (match-case x
		     ((?- () . (and ?body (not ())))
		      (e `(let () ,(normalize-progn body)) e))
		     ((?- ?bindings . (and ?body (not ())))
		      (e `(let (,(car bindings))
			     (let* ,(cdr bindings)
				,(normalize-progn body))) e))
		     (else
		      (error #f "Illegal `let*' form" x)))))
	 (set! internal-definition? old-internal)
	 (replace! x res))))

;*---------------------------------------------------------------------*/
;*    expand-let ...                                                   */
;*---------------------------------------------------------------------*/
(define (expand-let x e)
   (let ((old-internal internal-definition?))
      (set! internal-definition? #t)
      (let* ((e   (internal-begin-expander e))
	     (res (match-case x
		     ((?- () . (and ?body (not ())))
		      ;; we must let the construction (to uses with
		      ;; traces).
		      `(let () ,(e (normalize-progn body) e)))
		     ((?- (and (? symbol?) ?loop)
			  ?bindings . (and ?body (not ())))
		      (if (not (or (null? bindings)
				   (pair? bindings)))
			  (error #f "Illegal `let' form" x)
			  (e `(labels ((,loop ,(map
						(lambda (b)
						   (if (pair? b)
						       (car b)
						       (error
							#f
							"Illegal `let' form"
							x)))
						bindings)
					      ,@body))
				 (,loop ,@(map (lambda (b)
						  (normalize-progn (cdr b)))
					       bindings)))
			     e)))
		     ((?- (and (? pair?) ?bindings) . (and ?body (not ())))
		      `(let ,(let loop ((bindings bindings)
					(acc      '()))
				(if (null? bindings)
				    (reverse! acc)
				    (let ((pr (car bindings)))
				       (cond
					  ((not (pair? pr))
					   (loop (cdr bindings)
						 (cons (list
							pr
							'(unspecified))
						       acc)))
					  ((not (and (pair? (cdr pr))
						     (null? (cddr pr))))
					   (error #f "Illegal `let' form" x))
					  (else
					   (let ((bd (list 
						      (car pr)
						      (e (normalize-progn
							  (cdr pr))
							 e))))
					      (loop (cdr bindings)
						    (cons bd acc))))))))
			  ,(with-lexical
			    (map (lambda (v) (if (pair? v) (car v) v))
				 bindings)
			    '_
			    (lambda ()
			       (e (normalize-progn body) e)))))
		     (else
		      (error #f "Illegal `let' form" x)))))
	 (set! internal-definition? old-internal)
	 (replace! x res))))

;*---------------------------------------------------------------------*/
;*    expand-letrec ...                                                */
;*---------------------------------------------------------------------*/
(define (expand-letrec x e)
   (let ((old-internal internal-definition?))
      (set! internal-definition? #t)
      (let* ((e   (internal-begin-expander e))
	     (res (match-case x
		     ((?- () . (and ?body (not ())))
		      (set-car! x 'let)
		      (e x e))
		     ((?- (and (? pair?) ?bindings) . (and ?body (not ())))
		      (with-lexical
		       (map (lambda (v) (if (pair? v) (car v) v)) bindings)
		       '_
		       (lambda ()
			  `(letrec ,(let loop ((bindings bindings)
					       (acc      '()))
				       (if (null? bindings)
					   (reverse! acc)
					   (let ((pr (car bindings)))
					      (if (not (pair? pr))
						  (error
						   #f
						   "Illegal `letrec' form"
						   x)
						  (loop
						   (cdr bindings)
						   (cons (list
							  (car pr)
							  (e (normalize-progn
							      (cdr pr))
							     e))
							 acc))))))
			      ,(e (normalize-progn body) e)))))
		     (else
		      (error #f "Illegal `letrec' form" x)))))
	 (set! internal-definition? old-internal)
	 (replace! x res))))
	 
;*---------------------------------------------------------------------*/
;*      expand-labels ...                                              */
;*---------------------------------------------------------------------*/
(define (expand-labels x e)
   (let ((old-internal internal-definition?))
      (set! internal-definition? #t)
      (let* ((e   (internal-begin-expander e))
	     (res (match-case x
		     ((?- () . (and ?body (not ())))
		      (set-car! x 'let)
		      (e x e))
		     ((?- (and (? pair?) ?bindings) . (and ?body (not ())))
		      (with-lexical
		       (map car bindings)
		       '_
		       (lambda ()
			  (let ((new
				 (let loop ((bindings bindings))
				    (cond
				       ((null? bindings)
					'())
				       ((not (pair? bindings))
					(error #f
					       "Illegal `labels' form"
					       x))
				       (else
					(match-case (car bindings)
					   ((?name ?args . ?lbody)
					    (with-lexical
					     (args*->args-list args)
					     '_
					     (lambda ()
						(cons
						 `(,name
						   ,args
						   ,(e (normalize-progn lbody)
						       e))
						 (loop (cdr bindings))))))
					   (else
					    (error #f
						   "Illegal `labels' form"
						   x))))))))
			     `(labels ,new ,(e (normalize-progn body) e))))))
		     (else
		      (error #f "Illegal `labels' form" x)))))
	 (set! internal-definition? old-internal)
	 (replace! x res))))
