;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9b/Expand/object.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri May  3 10:13:58 1996                          */
;*    Last change :  Tue May  6 11:42:34 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The Object expanders (just once for now)                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module expand_object
   (include "Object/class.sch")
   (import  tools_args
	    tools_progn
	    tools_misc
	    type_type
	    type_env
	    expand_eps
	    engine_param
	    ast_var
	    ast_ident
	    object_class)
   (export  (expand-with-access ::obj ::procedure)
	    (expand-instantiate ::obj ::procedure)
	    (expand-duplicate   ::obj ::procedure)
	    (expand-widen!      ::obj ::procedure)
	    (expand-shrink!     ::obj ::procedure)))

;*---------------------------------------------------------------------*/
;*    expand-with-access ...                                           */
;*---------------------------------------------------------------------*/
(define (expand-with-access x e)
   (match-case x
      ((?with-access ?instance (and (? pair?) ?slots) . ?body)
       (let ((class (type-of-id with-access)))
	  (if (not (class? class))
	      (error #f "Illegal `with-access' form" x)
	      (let loop ((s slots))
		 (cond
		    ((null? s)
		     (let* ((aux      (gensym 'instance))
			    (mark     aux)
			    (instance (e instance e)))
			(replace! x
				  (with-lexical
				   slots
				   mark
				   (lambda () 
				      (let ((e (with-access-expander
						e
						mark
						aux
						(type-id class)
						slots)))
					 `(let ((,aux ,instance))
					     ,(e (normalize-progn body)
						 e))))))))
		    ((not (pair? s))
		     (error #f "Illegal `with-access' form" x))
		    ((symbol? (car s))
		     (loop (cdr s)))
		    (else
		     (error #f "Illegal `with-access' form" x)))))))
      (else
       (error #f "Illegal `with-access' form" x))))

;*---------------------------------------------------------------------*/
;*    with-access-expander ...                                         */
;*---------------------------------------------------------------------*/
(define (with-access-expander old-expander mark instance class slots)
   (lambda (x e)
      (match-case x
	 ((and ?var (? symbol?))
	  (if (and (memq var slots)
		   (let ((cell (assq var (lexical-stack))))
		      (and (pair? cell) (eq? (cdr cell) mark))))
	      `(,(symbol-append class '- var) ,instance)
	      (old-expander var old-expander)))
	 ((set! (and (? symbol?) ?var) ?val)
	  (let ((val (e val e)))
	     (if (and (memq var slots)
		      (let ((cell (assq var (lexical-stack))))
			 (and (pair? cell) (eq? (cdr cell) mark))))
		 `(,(symbol-append class '- var '-set!) ,instance ,val)
		 (begin
		    (set-car! (cddr x) val)
		    (old-expander x old-expander)))))
	 (else
	  (old-expander x e)))))

;*---------------------------------------------------------------------*/
;*    expand-instantiate ...                                           */
;*---------------------------------------------------------------------*/
(define (expand-instantiate x e)
   (match-case x
      ((?instantiate . ?provided)
       (let ((class (type-of-id instantiate)))
	  (if (not (class? class))
	      (error #f "Illegal `instantiate' form" x)
	      (replace! x (e (instantiate->make x class provided) e)))))
      (else
       (error #f "Illegal `instantiate' form" x))))
			 
;*---------------------------------------------------------------------*/
;*    instantiate->make ...                                            */
;*---------------------------------------------------------------------*/
(define (instantiate->make form class provided)
   (let* ((slots            (if (not (class-widening class))
				(class-slots class)
				(append (class-slots (class-its-super class))
					(class-slots class))))
	  (len              (length slots))
	  (vargs            (make-vector (length slots)))
	  (find-slot-offset (lambda (s-name)
			       (let loop ((slots slots)
					  (i     0))
				  (cond
				     ((null? slots)
				      (error
				       #f
				       (string-append
					"Illegal `instantiate' form (unknown slot "
					(symbol->string s-name)
					")")
				       form))
				     ((eq? (slot-id (car slots)) s-name)
				      i)
				     (else
				      (loop (cdr slots) (+fx i 1))))))))
      ;; we collect the default values
      (let loop ((i     0)
		 (slots slots))
	 (if (null? slots)
	     'done
	     (let ((s (car slots)))
		(if (slot-default? s)
		    (vector-set! vargs i (cons #t (slot-default-value s)))
		    (vector-set! vargs i (cons #f #unspecified)))
		(loop (+fx i 1)
		      (cdr slots)))))
      ;; we collect the provided values
      (let loop ((provided provided))
	 (if (null? provided)
	     'done
	     (let ((p (car provided)))
		(match-case p
		   ((?s-name ?value)
		    (let ((pval (vector-ref vargs (find-slot-offset s-name))))
		       (set-car! pval #t)
		       (set-cdr! pval value)))
		   ((?s-name ?len ?value)
		    (let* ((snum (find-slot-offset s-name))
			   (slot (list-ref slots snum)))
		       (if (not (slot-dyna-indexed? slot))
			   (error #f "Illegal `instantiate' form" form)
			   (let* ((pval (vector-ref vargs snum))
				  (plen (vector-ref vargs (-fx snum 1))))
			      (set-car! pval #t)
			      (set-cdr! pval value)
			      (set-car! plen #t)
			      (set-cdr! plen len)))))
		   (else
		    (error #f "Illegal `instantiate' form" form)))
		(loop (cdr provided)))))
      ;; we check that we have a value for all formals
      (let loop ((i 0))
	 (cond
	    ((=fx i len)
	     'ok)
	    ((not (car (vector-ref vargs i)))
	     ;; no, this is not correct, at least one argument is missing
	     (error #f
		    "Illegal `instantiate' form (missing arguments)"
		    form))
	    (else
	     (loop (+fx i 1)))))
      ;; we just have now to build the make call
      (let loop ((i     0)
		 (largs '()))
	 (if (=fx i len)
	     (let ((make-name (symbol-append 'make- (type-id class))))
		`(,make-name ,@(reverse! largs)))
	     (loop (+fx i 1)
		   (cons (cdr (vector-ref vargs i)) largs))))))
   
;*---------------------------------------------------------------------*/
;*    expand-duplicate ...                                             */
;*---------------------------------------------------------------------*/
(define (expand-duplicate  x e)
   (match-case x
      ((?duplicate ?dup . ?prov)
       (let* ((id.type (parse-id duplicate))
	      (id      (car id.type))
	      (class   (cdr id.type)))
	  (if (not (class? class))
	      (error #f
		     (string-append "duplicate:Illegal class type:"
				    (symbol->string id))
		     x)
	      (replace! x (e (duplicate->make x class dup prov) e)))))
      (else
       (error #f "Illegal `duplicate' form" x))))

;*---------------------------------------------------------------------*/
;*    duplicate->make ...                                              */
;*    -------------------------------------------------------------    */
;*    In contrast with instantiate this macro does not check at        */
;*    compile time that all values are provided. All the missing       */
;*    values (the ones not provided explicitly) are picked from        */
;*    the duplicated object (which hence, is supposed to have the      */
;*    proper fields).                                                  */
;*---------------------------------------------------------------------*/
(define (duplicate->make form class duplicated provided)
   (let* ((slots            (if (not (class-widening class))
				(class-slots class)
				(append (class-slots (class-its-super class))
					(class-slots class))))
	  (len              (length slots))
	  (vargs            (make-vector (length slots)))
	  (dup-var          (gensym 'duplicated))
	  (dup-var-typed    (symbol-append dup-var 4dots (type-id class)))
	  (find-slot-offset (lambda (s-name)
			       (let loop ((slots slots)
					  (i     0))
				  (cond
				     ((null? slots)
				      (error
				       #f
				       (string-append
					"Illegal `duplicate' form (unknown slot "
					(symbol->string s-name)
					")")
				       form))
				     ((eq? (slot-id (car slots)) s-name)
				      i)
				     (else
				      (loop (cdr slots) (+fx i 1))))))))
      ;; we collect the provided values
      (let loop ((provided provided))
	 (if (null? provided)
	     'done
	     (let ((p (car provided)))
		(match-case p
		   ((?s-name ?value)
		    (vector-set! vargs
				 (find-slot-offset s-name)
				 (cons #t value)))
		   ((?s-name ?len ?value)
		    (let* ((snum (find-slot-offset s-name))
			   (slot (list-ref slots snum)))
		       (if (not (or (slot-stat-indexed? slot)
				    (slot-dyna-indexed? slot)))
			   (error #f "Illegal `duplicate' form" form)
			   (begin
			      (vector-set! vargs snum (cons #t value))
			      (vector-set! vargs (-fx snum 1)
					   (cons #f len))))))
		   (else
		    (error #f "Illegal `duplicate' form" form)))
		(loop (cdr provided)))))
      ;; we collect the duplicated values
      (let loop ((i     0)
		 (slots slots))
	 (if (null? slots)
	     'done
	     (let ((value (vector-ref vargs i)))
		(if (pair? value)
		    ;; a value is already provided for this object
		    'nothing
		    (let ((slot (car slots)))
		       ;; no value is provided for this object we pick
		       ;; one from this duplicated object.
		       (if (or (slot-dyna-indexed? slot)
			       (slot-stat-indexed? slot))
			   ;; for indexed slot, we pick the first value
			   ;; (which is suposed to be existing).
			   (let ((a-name (symbol-append (type-id class)
							'-
							(slot-id slot)
							'-ref)))
			      (vector-set! vargs
					   i
					   (cons #t `(,a-name ,dup-var 0))))
			   (let ((a-name (symbol-append (type-id class)
							'-
							(slot-id slot))))
			      (vector-set! vargs
					   i
					   (cons #t `(,a-name ,dup-var)))))))
		(loop (+fx i 1)
		      (cdr slots)))))
      ;; we just have now to build the make call
      (let loop ((i     0)
		 (largs '()))
	 (if (=fx i len)
	     (let ((make-name (symbol-append 'make- (type-id class))))
		`(let ((,dup-var-typed ,duplicated))
		    (,make-name ,@(reverse! largs))))
	     (loop (+fx i 1)
		   (cons (cdr (vector-ref vargs i)) largs))))))
   
;*---------------------------------------------------------------------*/
;*    expand-widen! ...                                                */
;*---------------------------------------------------------------------*/
(define (expand-widen! x e)
   (match-case x
      ((?widen! ?obj . ?provided)
       (let ((class (type-of-id widen!)))
	  (if (and (class? class) (class-widening class))
	      (replace! x (e (make-widening x class obj provided) e))
	      (error #f
		     (string-append "widen!:Illegal class type:"
				    (symbol->string (type-id class)))
		     x))))
      (else
       (error #f "Illegal `widen!' form" x))))

;*---------------------------------------------------------------------*/
;*    make-widening ...                                                */
;*---------------------------------------------------------------------*/
(define (make-widening form class obj provided)
   (let* ((slots            (class-slots class))
	  (holder           (class-holder class))
	  (len              (length slots))
	  (vargs            (make-vector (length slots)))
	  (dup-var          (gensym 'obj))
	  (dup-var-typed    (symbol-append dup-var 4dots (type-id class)))
	  (pragma-typed     (symbol-append 'pragma 4dots (type-id class)))
	  (pragma-format    (string-append "((" (type-name class) ")($1))"))
	  (find-slot-offset (lambda (s-name)
			       (let loop ((slots slots)
					  (i     0))
				  (cond
				     ((null? slots)
				      (error
				       #f
				       (string-append
					"Illegal `widen!' form (unknown slot "
					(symbol->string s-name)
					")")
				       form))
				     ((eq? (slot-id (car slots)) s-name)
				      i)
				     (else
				      (loop (cdr slots) (+fx i 1))))))))
      ;; we collect the default values
      (let loop ((i     0)
		 (slots slots))
	 (if (null? slots)
	     'done
	     (let ((s (car slots)))
		(if (slot-default? s)
		    (vector-set! vargs i (cons #t (slot-default-value s)))
		    (vector-set! vargs i (cons #f #unspecified)))
		(loop (+fx i 1)
		      (cdr slots)))))
      ;; we collect the provided values
      (let loop ((provided provided))
	 (if (null? provided)
	     'done
	     (let ((p (car provided)))
		(match-case p
		   ((?s-name ?value)
		    (vector-set! vargs
				 (find-slot-offset s-name)
				 (cons #t value)))
		   ((?s-name ?len ?value)
		    (let* ((snum (find-slot-offset s-name))
			   (slot (list-ref slots snum)))
		       (if (not (or (slot-stat-indexed? slot)
				    (slot-dyna-indexed? slot)))
			   (error #f "Illegal `widen!' form" form)
			   (begin
			      (vector-set! vargs snum (cons #t value))
			      (vector-set! vargs (-fx snum 1)
					   (cons #f len))))))
		   (else
		    (error #f "Illegal `widen!' form" form)))
		(loop (cdr provided)))))
      ;; we check that we have a value for all formals
      (let loop ((i 0))
	 (cond
	    ((=fx i len)
	     'ok)
	    ((not (car (vector-ref vargs i)))
	     ;; no, this is not correct, at least one argument is missing
	     (error #f
		    "Illegal `widen!' form (missing arguments)"
		    form))
	    (else
	     (loop (+fx i 1)))))
      ;; we just have now to build the make call
      (let loop ((i     0)
		 (largs '()))
	 (if (=fx i len)
	     (let ((widening (symbol-append (class-widening class)
					    '-
					    (type-id class))))
		(if *unsafe-type*
		    `(let ((,dup-var-typed (,pragma-typed ,pragma-format
							  ,obj)))
			(object-widening-set!
			 ,dup-var
			 (,widening ,@(reverse! largs)))
			;; the new class must be set after initialization
			;; otherwise type errors are possibles
			((@ object-class-num-set! __object)
			 ,dup-var
			 ((@ class-num __object)
			  (@ ,(global-id holder) ,(global-module holder))))
			,dup-var)
		    `(let ((,dup-var-typed (,pragma-typed ,pragma-format
							  ,obj)))
			(if (object-widening ,dup-var)
			    (shrink! ,dup-var))
			(if (eq? ((@ class-super __object)
				  (@ ,(global-id holder)
				     ,(global-module holder)))
				 ((@ object-class __object) ,dup-var))
			    (begin
			       (object-widening-set!
				,dup-var
				(,widening ,@(reverse! largs)))
			       ;; same remark as below
			       ((@ object-class-num-set! __object)
				,dup-var
				((@ class-num __object)
				 (@ ,(global-id holder)
				    ,(global-module holder))))
			       ,dup-var)
			    (error
			     "widen!"
			     "This object can't be widened to the wanted class"
			     ,dup-var)))))
	     (loop (+fx i 1)
		   (cons (cdr (vector-ref vargs i)) largs))))))
   
;*---------------------------------------------------------------------*/
;*    expand-shrink! ...                                               */
;*---------------------------------------------------------------------*/
(define (expand-shrink! x e)
   (match-case x
      ((shrink! ?o)
       (replace! x (make-a-shrink! e o)))
      (else
       (error #f "Illegal `shrink!' form" x))))
		 
;*---------------------------------------------------------------------*/
;*    make-a-shrink! ...                                               */
;*---------------------------------------------------------------------*/
(define (make-a-shrink! e o)
   (let ((newo (gensym 'o)))
      (if *unsafe-type*
	  `(let ((,newo ,(e o e)))
	      ((@ object-class-num-set! __object)
	       ,newo
	       ((@ class-num __object)
		((@ class-super __object)
		 ((@ object-class __object) ,newo))))
	      (object-widening-set! ,newo #f)
	      ,newo)
	  `(let ((,newo ,(e o e)))
	      (if (object? ,newo)
		  (if (object-widening ,newo)
		      (begin
			 ((@ object-class-num-set! __object)
			  ,newo
			  ((@ class-num __object)
			   ((@ class-super __object)
			    ((@ object-class __object) ,newo))))
			 (object-widening-set! ,newo #f)
			 ,newo)
		      (error "shrink!" "Not a wide object" ,newo))
		  (error "shrink!" "Not a wide object" ,newo))))))

