;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9b/Foreign/cenum.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jun  6 12:23:13 1996                          */
;*    Last change :  Thu Apr  3 16:22:24 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The C enum accessors creations                                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module foreign_cenum
   (import tools_misc
	   type_tools
	   type_type
	   foreign_ctype
	   foreign_access
	   module_module))
   
;*---------------------------------------------------------------------*/
;*    make-ctype-accesses! ::cenum ...                                 */
;*---------------------------------------------------------------------*/
(define-method (make-ctype-accesses! what::cenum who::type)
   (let* ((btype       (cenum-btype what))
	  (id          (type-id who))
	  (wid         (type-id what))
	  (bid         (type-id btype))
	  (id->bid     (symbol-append id '-> bid))
	  (bid->id     (symbol-append bid '-> id))
	  (bid?        (symbol-append id '?))
	  (bid?-bool   (symbol-append bid? '::bool))
	  (name        (type-name who))
	  (name-sans-$ (string-sans-$ name))
	  (literals    (cenum-literals what)))

      ;; the two conversion allocation fonctions (they are not
      ;; simple coercion because the first one allocate and the
      ;; second one destructurate).
      (define (mk-id->bid)
	 `(macro ,bid ,id->bid (symbol ,id) "cobj_to_foreign"))

      (define (mk-bid->id)
	 (let ((mname (string-append "(" name-sans-$ ")FOREIGN_TO_COBJ")))
	    `(macro ,id ,bid->id (,bid) ,mname)))

      ;; the predicate
      (define (mk-bid?)
	 `(define-inline (,bid?-bool o::obj)
	     (if (foreign? o)
		 (eq? (foreign-id o) ',bid)
		 #f)))

      ;; equality (using ==)
      (define (mk-=id)
	 `(define-inline (,(symbol-append '= id '?::bool)
			  ,(symbol-append 'o1 4dots id)
			  ,(symbol-append 'o2 4dots id))
	     (pragma::bool "($1 == $2)" o1 o2)))
      
      ;; literals accessors
      (define (literal-accessors)
	 (let loop ((literals literals)
		    (res      '()))
	    (if (null? literals)
		res
		(let* ((literal      (car literals))
		       (literal-id   (car literal))
		       (literal-name (cadr literal))
		       (access-id    (symbol-append id '- literal-id))
		       (access       `(define-inline (,(symbol-append
							access-id
							4dots
							wid))
					 (,(symbol-append 'pragma 4dots wid)
					  ,literal-name))))
		   (loop (cdr literals)
			 (cons access res))))))

      ;; we declare the coercion operations ...
      (produce-module-clause! `(foreign ,(mk-id->bid) ,(mk-bid->id)))
      ;; and the predicate
      (produce-module-clause! `(static (inline ,bid?-bool ::obj)))
      (produce-module-clause! `(pragma (,bid? (predicate-of ,wid))))

      ;; and we return the built code
      (cons* (mk-=id) (mk-bid?) (literal-accessors))))


