;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Module/eval.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jun  4 16:28:03 1996                          */
;*    Last change :  Thu Feb 26 16:07:54 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The eval clauses compilation.                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module module_eval
   (include "Ast/unit.sch"
	    "Ast/node.sch")
   (import  module_module
	    module_include
	    engine_param
	    tools_shape
	    tools_error
	    tools_location
	    ast_env
	    ast_glo-decl
	    ast_sexp)
   (export  (make-eval-compiler)))

;*---------------------------------------------------------------------*/
;*    make-eval-compiler ...                                           */
;*---------------------------------------------------------------------*/
(define (make-eval-compiler)
   (instantiate::ccomp (id 'eval)
		       (producer eval-producer)
		       (finalizer eval-finalizer)))

;*---------------------------------------------------------------------*/
;*    eval-producer ...                                                */
;*---------------------------------------------------------------------*/
(define (eval-producer clause)
   (match-case clause
      ((?- . ?protos)
       (for-each (lambda (proto) (eval-parser proto clause)) protos)
       '())
      (else
       (user-error "Parse error"
		   (string-append "Illegal `eval' clause")
		   clause
		   '()))))
   
;*---------------------------------------------------------------------*/
;*    eval-parser ...                                                  */
;*---------------------------------------------------------------------*/
(define (eval-parser proto clause)
   (match-case proto
      ((export-all)
       (set! *all-eval?* #t))
      ((export (and (? symbol?) ?var))
       (set! *one-eval?* #t)
       (remember-eval-exported! var *module* proto))
      ((export (@ (and (? symbol?) ?var) (and (? symbol?) ?module)))
       (set! *one-eval?* #t)
       (remember-eval-exported! var module proto))
      ((import (and (? symbol?) ?var))
       (declare-global-svar! var 'eval 'eval clause))
      (else
       (user-error "Parse error" "Illegal `eval clause'" clause '()))))

;*---------------------------------------------------------------------*/
;*    *eval-exported* ...                                              */
;*---------------------------------------------------------------------*/
(define *eval-exported* '())

;*---------------------------------------------------------------------*/
;*    remember-eval-exported! ...                                      */
;*---------------------------------------------------------------------*/
(define (remember-eval-exported! var::symbol module::symbol loc)
   (set! *eval-exported* (cons (list var module loc) *eval-exported*)))

;*---------------------------------------------------------------------*/
;*    *all-eval?* ...                                                  */
;*---------------------------------------------------------------------*/
(define *all-eval?* #f)

;*---------------------------------------------------------------------*/
;*    *one-eval?* ...                                                  */
;*---------------------------------------------------------------------*/
(define *one-eval?* #f)

;*---------------------------------------------------------------------*/
;*    eval-finalizer ...                                               */
;*---------------------------------------------------------------------*/
(define (eval-finalizer)
   (if (or *one-eval?* *all-eval?*)
       (list
	(unit
	 'eval
	 (-fx (get-toplevel-unit-weight) 2)
	 (delay
	    (let loop ((globals (get-evaluated-globals))
		       (init*  '(#unspecified)))
	       (if (null? globals)
		   `(begin ,@(reverse! init*))
		   (let ((g (car globals)))
		      (loop (cdr globals)
			    (cons (cond
				     ((svar? (global-value g))
				      (variable-access-set! g 'write)
				      (define-primop-ref->node g
					 (location->node g)))
				     ((scnst? (global-value g))
				      (define-primop-ref->node g
					 (location->node g)))
				     (else
				      (define-primop->node g)))
				  init*))))))
	 #f))
       'void))
	       
;*---------------------------------------------------------------------*/
;*    get-evaluated-globals ...                                        */
;*---------------------------------------------------------------------*/
(define (get-evaluated-globals)   
   (if *all-eval?*
       (let ((globals '()))
	  (for-each-global!
	   (lambda (g)
	      (if (and (memq (global-import g) '(import static export))
		       (global-evaluable? g)
		       (or *lib-mode* (not (global-library? g))))
		  (set! globals (cons g globals)))))
	  globals)
       (let loop ((eval-exported *eval-exported*)
		  (res           '()))
	  (if (null? eval-exported)
	      res
	      (let ((var.module.pos (car eval-exported)))
		 (let ((g (find-global (car var.module.pos)
				       (cadr var.module.pos))))
		    (cond
		       ((not (global? g))
			(user-error/location (find-location
					      (caddr var.module.pos))
					     "eval-init"
					     "Unbound variable"
					     (car var.module.pos)
					     '())
			(loop (cdr eval-exported) res))
		       ((and (not *lib-mode*) (global-library? g))
			(loop (cdr eval-exported) res))
		       ((not (global-evaluable? g))
			(user-error/location (find-location
					      (caddr var.module.pos))
					     "eval-init"
					     "This variable cannot be known by eval"
					     (car var.module.pos)
					     '())
			(loop (cdr eval-exported) res))
		       (else
			(loop (cdr eval-exported) (cons g res))))))))))

