;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9c/Module/library.scm      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jul  9 16:05:09 1996                          */
;*    Last change :  Wed Dec 17 17:37:07 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Library finalizer                                                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module module_library
   (include "Ast/unit.sch")
   (import  type_type
	    ast_var
	    ast_env
	    module_module
	    module_impuse)
   (export  (library-finalizer)))

;*---------------------------------------------------------------------*/
;*    library-finalizer ...                                            */
;*---------------------------------------------------------------------*/
(define (library-finalizer)
   ;; we set the key
   (set! *key* (gensym))
   ;; we mark the already imported modules
   (for-each (lambda (module) (putprop! module *key* #t))
	     (get-imported-modules))
   ;; we also mark the dummy `foreign' module
   (putprop! 'foreign *key* #t)
   ;; and, of course, the current module
   (putprop! *module* *key* #t)
   ;; first, we collect all the needed library modules
   (for-each-global! (lambda (global)
			(if (and (>fx (global-occurrence global) 0)
				 (global-library? global))
			    (need-library-module! (global-module global)))))
   ;; then we declare a special unit
   (let ((modules *needed-modules*))
      (if (null? modules)
	  '()
	  (let loop ((modules      modules)
		     (init-call* '(#unspecified)))
	     (if (null? modules)
		 (unit 'library-modules 2 init-call* #t)
		 (let* ((id          (car modules))
			(init-fun-id (module-initialization-id id)))
		    (loop (cdr modules)
			  (cons `((@ ,init-fun-id ,id) 0
						       ;; 0 means here not to
						       ;; perform version
						       ;; checking about
						       ;; library
						       ,(symbol->string
							 *module*))
				init-call*))))))))

;*---------------------------------------------------------------------*/
;*    *needed-modules* ...                                             */
;*---------------------------------------------------------------------*/
(define *needed-modules* '())

;*---------------------------------------------------------------------*/
;*    *key* ...                                                        */
;*---------------------------------------------------------------------*/
(define *key* #unspecified)

;*---------------------------------------------------------------------*/
;*    need-library-module! ...                                         */
;*---------------------------------------------------------------------*/
(define (need-library-module! module::symbol)
   (if (not (getprop module *key*))
       (begin
	  (putprop! module *key* #t)
	  (set! *needed-modules* (cons module *needed-modules*)))))
