;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    .../prgm/project/bigloo/comptime1.9b/Module/prototype.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jun  4 14:27:58 1996                          */
;*    Last change :  Tue Apr  8 14:16:22 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The prototype management                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module module_prototype
   (import tools_error
	   tools_dsssl
	   type_type
	   ast_ident)
   (export (parse-prototype prototype)))

;*---------------------------------------------------------------------*/
;*    parse-prototype ...                                              */
;*---------------------------------------------------------------------*/
(define (parse-prototype prototype)
   (match-case prototype
      (((and ?class (or class final-class wide-class)) . ?-)
       (parse-class class (cdr prototype)))
      ((generic . ?-)
       (parse-function-prototype (cdr prototype) 'sgfun))
      ((inline . ?-)
       (parse-function-prototype (cdr prototype) 'sifun))
      ((?- . ?-)
       (parse-function-prototype prototype 'sfun))
      (else
       (parse-variable-prototype prototype))))

;*---------------------------------------------------------------------*/
;*    parse-function-prototype ...                                     */
;*---------------------------------------------------------------------*/
(define (parse-function-prototype proto class)
   (match-case proto
      (((and ?id (? symbol?)) . ?the-args)
       (let loop ((args the-args))
	  (cond
	     ((null? args)
	      (list class id (dsssl-formals-skeleton the-args)))
	     ((symbol? args)
	      (list class id the-args))
	     ((and (pair? args)
		   (or (symbol? (car args))
		       (dsssl-named-constant? (car args))))
	      (loop (cdr args)))
	     (else
	      #f))))
      (else
       #f)))

;*---------------------------------------------------------------------*/
;*    parse-variable-prototype ...                                     */
;*---------------------------------------------------------------------*/
(define (parse-variable-prototype proto)
   (if (symbol? proto)
       (list 'svar proto) 
       #f))

;*---------------------------------------------------------------------*/
;*    parse-class ...                                                  */
;*---------------------------------------------------------------------*/
(define (parse-class class class-def)
   (match-case class-def
      (((and ?name (? symbol?)) . ?slots)
       (let loop ((slots slots)
		  (res   '()))
	  (cond
	     ((null? slots)
	      (cons* class name (reverse! res)))
	     ((not (pair? slots))
	      #f)
	     (else
	      (let ((slot (parse-class-slot (car slots))))
		 (if (not slot)
		     (user-error "Parse error"
				 "Illegal class definition"
				 class-def)
		     (loop (cdr slots)
			   (cons slot res))))))))
      (else
       #f)))

;*---------------------------------------------------------------------*/
;*    parse-class-slot ...                                             */
;*---------------------------------------------------------------------*/
(define (parse-class-slot slot)
   (match-case slot
      ((? symbol?)
       `(id ,(parse-id slot)))
      ((* (and ?id (? symbol?)) . ?att)
       (if (correct-attribut? att)
           `(* (id ,(parse-id id)) ,@att)
           #f))
      ((+ (and ?integer ?len) (and ?id (? symbol?)) . ?att)
       (if (correct-attribut? att)
           `(+ ,(integer->string len) (id ,(parse-id id)) ,@att)
           #f))
      ((+ (and ?string ?len) (and ?id (? symbol?)) . ?att)
       (if (correct-attribut? att)
           `(+ ,len (id ,(parse-id id)) ,@att)
           #f))
      (((and ?id (? symbol?)) . ?att)
       (if (correct-attribut? att)
           `((id ,(parse-id id)) ,@att)
           #f))
      (else
       #f)))
         
;*---------------------------------------------------------------------*/
;*    correct-attribut? ...                                            */
;*---------------------------------------------------------------------*/
(define (correct-attribut? attribut)
   (let loop ((attribut attribut))
      (cond
         ((null? attribut)
          #t)
         ((memq (car attribut) '(read-only))
          (loop (cdr attribut)))
         (else
          (match-case (car attribut)
             ((default ?-)
              (loop (cdr attribut)))
	     ((assert ?- . ?-)
	      (loop (cdr attribut)))
             (else
              #f))))))
