;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Object/access.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jun  5 11:16:50 1996                          */
;*    Last change :  Wed Feb 11 10:26:38 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We make the class accessors                                      */
;*    -------------------------------------------------------------    */
;*    In this module we cannot use consume-module-clause! because      */
;*    the importation are already done.                                */
;*    -------------------------------------------------------------    */
;*    This constructors does not require any importation information   */
;*    since all accessors are always static.                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module object_access
   (include "Object/class.sch")
   (import  tools_error
	    tools_misc
	    type_type
	    type_env
	    type_tools
	    type_cache
	    ast_var
	    ast_ident
	    object_class
	    object_struct
	    object_slots
	    object_tools
	    module_module
	    module_impuse
	    engine_param)
   (export  (make-class-accesses!      class-def ::type ::obj ::bool)
	    (make-wide-class-accesses! class-def ::type ::obj ::bool)))
	    
;*---------------------------------------------------------------------*/
;*    make-class-accesses! ...                                         */
;*    -------------------------------------------------------------    */
;*    This function checks that the super class is conform to the      */
;*    class. That is, the class is not a wide class and the super      */
;*    class is not final.                                              */
;*---------------------------------------------------------------------*/
(define (make-class-accesses! class-def class src-def object<->struct?)
   (let* ((super      (class-its-super class))
	  (cslots     (make-class-slots (cdr class-def)
					(if (eq? super class) #f super)
					src-def))
	  (class-id   (class-id class))
	  (class-name (class-name class))
	  (holder     (class-holder class)))
      ;; Now that the class is defined we check the super (is it or
      ;; not a class).
      (cond
	 ((and (type? super) (not (class? super)))
	  (user-error (type-id super)
		      (string-append "super of `"
				     (symbol->string class-id)
				     "' is not a class")
		      src-def
		      type))
	 ((wide-class? class)
	  ;; internal error because wide classes must be processed
	  ;; by make-wide-class-accesses
	  (internal-error "make-class-accesses!"
			  "Should not be able to see a wide class here"
			  src-def))
	 ((wide-class? super)
	  ;; no one can inherite of a wide class
	  (user-error (type-id super)
                      (string-append "super of `"
                                     (symbol->string class-id)
                                     "' is a wide class")
                      src-def
		      type))
	 ((final-class? super)
	  ;; only wide class can inherit of final classes
	  (user-error (type-id super)
                      "Only wide classes can inherit of final classes" 
                      src-def
		      type))
	 (else
	  ;; we install the coercion between the new-class and obj
	  ;; and the class and all its super classes.
	  (produce-module-clause! (make-coercion-clause class-id super))
	  [assert (holder) (global? holder)]
	  (class-slots-set! class cslots)
	  ;; we define the coercers for this class
	  (produce-module-clause! `(foreign ,@(make-class-coercers class)))
	  ;; and we build the new definitions
	  (let ((accs (append (make-class-pred class-id class)
			      (make-class-makes 'make
						'make
						class-id
						class
						cslots)
			      (make-class-slots-access class-id
						       class
						       cslots
						       #f))))
	     (cons (make-class-allocate class-id class holder)
		   (if (type? (class-its-super class))
		       (if object<->struct?
			   (cons*
			    (make-object->struct class-id
						 class
						 *module*
						 cslots)
			    (make-struct->object class-id
						 class
						 *module*
						 cslots)
			    accs)
			   accs)
		       accs)))))))
	  
;*---------------------------------------------------------------------*/
;*    make-wide-class-accesses! ...                                    */
;*    -------------------------------------------------------------    */
;*    This function checks that the super class is conform to the      */
;*    class. That is, the class is a wide class and the super          */
;*    class is final.                                                  */
;*---------------------------------------------------------------------*/
(define (make-wide-class-accesses! class-def class src-def object<->struct?)
   (if (and (class? class) (class? (class-its-super class)))
       (let* ((super      (class-its-super class))
	      (sslots     (class-slots super))
	      (cslots     (make-class-slots (cdr class-def) #f src-def))
	      (class-id   (class-id class))
	      (class-name (class-name class))
	      (holder     (class-holder class))
	      (module     (global-module holder))
	      (widening   (class-widening class)))
	  ;; Now that the class is defined we check the super (is it or
	  ;; not a class).
	  (cond
	     ((and (type? super) (not (class? super)))
	      (user-error (type-id super)
			  (string-append "super of `"
					 (symbol->string class-id)
					 "' is not a class")
			  src-def
			  type))
	     ((not (wide-class? class))
	      ;; internal error because plain classes must be processed
	      ;; by make-class-accesses
	      (internal-error "make-wide-class-accesses!"
			      "Should not be able to see a plain class here"
			      src-def))
	     ((wide-class? super)
	      ;; no one can inherite of a wide class
	      (user-error (type-id super)
			  (string-append "super of `"
					 (symbol->string class-id)
					 "' is a wide class")
			  src-def
			  type))
	     ((not (final-class? super))
	      ;; wide class can only inherit of final classes
	      (user-error (type-id super)
			  (string-append "super of wide class `"
					 (symbol->string class-id)
					 "' is not a final class")
			  src-def
			  type))
	     ((final-class? class)
	      ;; a class can't be final and wide
	      (user-error class-id
			  "A class can't be `wide' and `final'"
			  src-def
			  type))
	     (else
	      ;; we install the coercion between the new-class and obj
	      ;; and the class and all its super classes.
	      (produce-module-clause! (make-coercion-clause class-id super))
	      [assert (holder) (global? holder)]
	      (class-slots-set! class cslots)
	      ;; we define the coercers for this class
	      (produce-module-clause! `(foreign ,@(make-class-coercers class)))
	      ;; and we build the new definitions
	      (let ((accs (append
			   (make-class-pred class-id class)
			   (make-class-makes 'widening widening class-id class cslots)
			   (make-wide-class-makes class-id class cslots sslots)
			   (make-class-slots-access class-id super sslots #f)
			   (make-class-slots-access class-id class cslots class))))
		 (cons (make-class-allocate class-id super holder)
		       (if object<->struct?
			   (cons*
			    (make-wide-object->struct class-id class *module* cslots)
			    (make-struct->wide-object class-id class *module* cslots)
			    accs)
			   accs))))))
       '()))
	  
;*---------------------------------------------------------------------*/
;*    make-coercion-clause ...                                         */
;*    -------------------------------------------------------------    */
;*    This function has to take care that the super class may be       */
;*    incorrect (because this error is now detected very late in       */
;*    compilation). Thus on the iteration on super, we have to check   */
;*    that super is a class. If not, it is not a problem, we can       */
;*    simply stop the iteration. We can do this simple thing because   */
;*    eventually the super error will be detected and the compilation  */
;*    will be stopped.                                                 */
;*---------------------------------------------------------------------*/
(define (make-coercion-clause c-id super)
   (let* ((class->obj (class->obj-id c-id))
	  (obj->class (obj->class-id c-id))
	  (class-id?  (class?-id c-id)))
      (let loop ((super   super)
		 (coercer (list
			   `(coerce obj ,c-id (,class-id?) (,obj->class))
			   `(coerce ,c-id obj () (,class->obj)))))
	 (if (not (class? super))
	     (begin
	     (if (type? super) (print "make-coercion-clause: " c-id " " super))
	     `(type ,@coercer)
	     )
	     (let* ((super-id     (class-id super))
		    (class->super (class->super-id c-id super-id))
		    (super->class (super->class-id super-id c-id)))
		(loop (class-its-super super)
		      (cons
		       `(coerce ,super-id ,c-id	(,class-id?) (,super->class))
		       (cons
			`(coerce ,c-id ,super-id () (,class->super))
			coercer))))))))

;*---------------------------------------------------------------------*/
;*    make-class-coercers ...                                          */
;*    -------------------------------------------------------------    */
;*    We create all the coercers between type, obj and its super       */
;*    classes.                                                         */
;*    -------------------------------------------------------------    */
;*    This function has to take care that the super class may be       */
;*    incorrect (because this error is now detected very late in       */
;*    compilation). Thus on the iteration on super, we have to check   */
;*    that super is a class. If not, it is not a problem, we can       */
;*    simply stop the iteration. We can do this simple thing because   */
;*    eventually the super error will be detected and the compilation  */
;*    will be stopped.                                                 */
;*---------------------------------------------------------------------*/
(define (make-class-coercers class)
   (define (make-one-coercion from-id from-name to-id to-name)
      (let ((t->f (symbol-append to-id '-> from-id))
	    (f->t (symbol-append from-id '-> to-id)))
	 (produce-module-clause!
	  `(pragma (,t->f side-effect-free no-cfa-top)
		   (,f->t side-effect-free no-cfa-top)))
	 (list `(macro ,from-id ,t->f (,to-id)
		       ,(string-append "(" from-name ")"))
	       `(macro ,to-id ,f->t (,from-id)
		       ,(string-append "(" to-name ")")))))
   (let ((tid   (type-id   class))
	 (tname (type-name class)))
      (let loop ((super   (class-its-super class))
		 (coercer (make-one-coercion tid tname 'obj "obj_t")))
	 (if (not (class? super))
	     (begin
		(if (type? super)
		    (print "make-class-coercers: " class))
	     coercer
	     )
	     (let ((sid   (type-id super))
		   (sname (type-name super)))
		(loop (class-its-super super)
		      (append (make-one-coercion tid tname sid sname)
			      coercer)))))))

;*---------------------------------------------------------------------*/
;*    make-class-pred ...                                              */
;*---------------------------------------------------------------------*/
(define (make-class-pred id::symbol class::class)
   (let* ((id?     (symbol-append id '?))
	  (pred-id (symbol-append id '?::bool))
	  (holder  (class-holder class))
	  (super   (class-its-super class)))
      (if (not (class? super))
 	  ;; roots class tree must have ad-hoc predicate checker as
	  ;; the (@ object? __object) predicate.
	  '()
	  (let ((super-pred-id (symbol-append 'super- pred-id))
		(super-typed   (symbol-append 'super 4dots (type-id super))))
	     ;; the pragma declaration
	     (produce-module-clause!
	      `(static (inline ,pred-id ::obj)))
	     (produce-module-clause!
	      `(pragma (,id? (predicate-of ,(class-id class)) no-cfa-top)))
	     ;; we produce the predicat definitions...
	     (list
	      `(define-inline (,pred-id obj)
		  (is-a? obj
			 (@ ,(global-id holder) ,(global-module holder)))))))))

;*---------------------------------------------------------------------*/
;*    make-class-makes ...                                             */
;*---------------------------------------------------------------------*/
(define (make-class-makes widening mk-id id type slots)
   [assert (widening) (memq widening '(widening make))]
   (let ((mk-heap-id  (symbol-append mk-id '- id))
	 (mk-stack-id (symbol-append mk-id '-stack- id)))
      (if (or (<fx *optim* 2) (not *optim-stack?*))
	  (list (make-class-make widening malloc mk-heap-id id type slots))
	  (begin
	     (produce-module-clause!
	      `(pragma (,mk-heap-id (stack-alloc ,mk-stack-id))))
	     (list
	      (make-class-make widening alloca mk-stack-id id type slots)
	      (make-class-make widening malloc mk-heap-id id type slots))))))

;*---------------------------------------------------------------------*/
;*    make-class-make ...                                              */
;*---------------------------------------------------------------------*/
(define (make-class-make widening alloc mk-id id type slots)
   (let* ((tid     (type-id type))
	  (holder  (class-holder type))
	  (mk-tid  (symbol-append mk-id 4dots tid))
	  (f-ids   (map slot-id slots))
	  (f-tids  (map (lambda (slot)
			   (symbol-append (slot-id slot)
					  4dots
					  (type-id (slot-type slot))))
			slots))
	  (loop    (gensym 'loop))
	  (new     (gensym 'new))
	  (rid     (gensym 'i))
	  (rtid    (symbol-append rid '::long)))
      ;; the module clause of the maker
      (produce-module-clause!
       `(static (,@(if (>=fx *optim* 2) '(inline) '()) ,mk-tid ,@f-tids)))
      ;; the definition of the maker
      `(,(if (>=fx *optim* 2) 'define-inline 'define) (,mk-tid ,@f-tids)
	  (let ((,(symbol-append new 4dots tid) ,(alloc type 1)))
	     ,@(if (not (eq? widening 'widening))
		   `((object-class-num-set!
		      ,new
		      (class-num (@ ,(global-id holder)
				    ,(global-module holder))))
		     (object-widening-set! ,new #f))
		   '())
	     (let ,(map (lambda (ft f) `(,ft ,f)) f-tids f-ids)
		,@(map (lambda (slot formal)
			  (cond
			     ((slot-dyna-indexed? slot)
			      ;; for an indexed field we have to make a
			      ;; malloc call and to fill all the field slots
			      `(begin
				  ,(make-pragma-indexed-init-set!
				    type
				    slot
				    new
				    (malloc (slot-type slot)
					    (symbol-append formal '-len)))
				  ;; this loop fills the field slots
				  (labels ((,loop (,rtid)
				     (if (=fx ,rid
					      ,(symbol-append formal '-len))
					 'done
					 (begin
					    ,(make-pragma-indexed-set!/widening
					      type
					      slot
					      new
					      formal
					      rid
					      #f)
					    (,loop (+fx ,rid 1))))))
				     (,loop 0))))
			     ((slot-stat-indexed? slot)
			      ;; this loop fills the field slots
			      `(labels ((,loop (,rtid)
				     (if (=fx ,rid
					      (free-pragma::long
					       ,(slot-stat-bound slot)))
					 'done
					 (begin
					    ,(make-pragma-indexed-set!/widening
					      type
					      slot
					      new
					      formal
					      rid
					      #f)
					    (,loop (+fx ,rid 1))))))
				     (,loop 0)))
			     (else
			      (make-pragma-direct-set! type
						       slot
						       new
						       formal))))
		       slots
		       f-ids)
		,new)))))

;*---------------------------------------------------------------------*/
;*    make-wide-class-makes ...                                        */
;*---------------------------------------------------------------------*/
(define (make-wide-class-makes id type slots sslots)
   (let ((mk-heap-id  (symbol-append 'make- id))
	 (mk-stack-id (symbol-append 'make-stack- id)))
      (if (or (<fx *optim* 2) (not *optim-stack?*))
	  (list (make-wide-class-make '- id type slots sslots))
	  (begin
	     (produce-module-clause!
	      `(pragma (,mk-heap-id (stack-alloc ,mk-stack-id))))
	     (list
	      (make-wide-class-make '- id type slots sslots)
	      (make-wide-class-make '-stack- id type slots sslots))))))

;*---------------------------------------------------------------------*/
;*    make-wide-class-make ...                                         */
;*---------------------------------------------------------------------*/
(define (make-wide-class-make mk-region id type slots sslots)
   (let* ((super       (class-its-super type))
	  (holder      (class-holder type))
	  (tid         (type-id type))
	  (stid        (type-id super))
	  (mk-tid      (symbol-append 'make mk-region id 4dots tid))
	  (f-ids       (map slot-id slots))
	  (sf-ids      (map slot-id sslots))
	  (f-tids      (map (lambda (slot)
			       (symbol-append
				(slot-id slot)
				4dots
				(type-id (slot-type slot))))
			    slots))
	  (sf-tids     (map (lambda (slot)
			       (symbol-append
				(slot-id slot)
				4dots
				(type-id (slot-type slot))))
			    sslots))
	  (widening    (symbol-append (class-widening type)
				      mk-region
				      (type-id type)))
	  (aux         (gensym 'aux))
	  (new         (gensym 'new))
	  (mk-class-id (symbol-append 'make mk-region stid)))
      ;; the module clause of the maker
      (produce-module-clause!
       `(static
	 (,@(if (>=fx *optim* 2) '(inline) '()) ,mk-tid ,@sf-tids ,@f-tids)))
      ;; the definition of the maker
      `(,(if (>=fx *optim* 2) 'define-inline 'define)
	(,mk-tid ,@sf-tids ,@f-tids)
	;; we make the allocation in several times:
	;; 1- we allocate a super object ...
	(let ((,(symbol-append aux 4dots stid) (,mk-class-id ,@sf-ids)))
	   ;; 2- we create a variable of type type aliased
	   ;; to the super object ...
	   (let ((,(symbol-append new 4dots tid)
		  (,(symbol-append 'free-pragma 4dots tid)
		   ,(string-append "((" (type-name type) ")($1))")
		   ,aux)))
	      ;; 3- we set the class number of the new object ...
	      (object-class-num-set! ,new
				     (class-num (@ ,(global-id holder)
						   ,(global-module holder))))
	      ;; 4- we set the widening property ...
	      (object-widening-set! ,new (,widening ,@f-ids))
	      ;; 5- we return the object
	      ,new)))))

;*---------------------------------------------------------------------*/
;*    make-class-allocate ...                                          */
;*---------------------------------------------------------------------*/
(define (make-class-allocate id type holder)
   (let* ((tid       (type-id type))
	  (alloc-id  (symbol-append 'allocate- id))
	  (alloc-tid (symbol-append alloc-id 4dots tid))
	  (new       (gensym 'new)))
      (produce-module-clause! `(static (,alloc-tid)))
      `(define (,alloc-tid)
	  (let ((,(symbol-append new 4dots tid) ,(malloc type 1)))
	     (object-class-num-set! ,new
				    ((@ class-num __object)
				     (@ ,(global-id holder)
					,(global-module holder))))
	     (object-widening-set! ,new #f)
	     ,new))))

;*---------------------------------------------------------------------*/
;*    make-class-slots-access ...                                      */
;*---------------------------------------------------------------------*/
(define (make-class-slots-access class-id type slots widening)
   (let loop ((slots slots)
	      (res   '()))
      (if (null? slots)
	  (reverse! res)
	  (let ((slot (car slots)))
	     (if (slot-read-only? slot)
		 (loop (cdr slots)
		       (append (slot-ref class-id type slot widening)
			       res))
		 (loop (cdr slots)
		       (append (slot-ref class-id type slot widening)
			       (slot-set! class-id type slot widening)
			       res)))))))

;*---------------------------------------------------------------------*/
;*    slot-ref ...                                                     */
;*---------------------------------------------------------------------*/
(define (slot-ref class-id type slot widening)
   (cond
      ((slot-dyna-indexed? slot)
       (slot-dyna-indexed-ref class-id type slot widening))
      ((slot-stat-indexed? slot)
       (slot-stat-indexed-ref class-id type slot widening))
      (else
       (slot-direct-ref class-id type slot widening))))

;*---------------------------------------------------------------------*/
;*    slot-dyna-indexed-ref ...                                        */
;*---------------------------------------------------------------------*/
(define (slot-dyna-indexed-ref class-id type slot widening)
   (slot-indexed-ref class-id
		     type
		     slot
		     widening
		     `(,(symbol-append class-id '- (slot-id slot) '-len) obj)))

;*---------------------------------------------------------------------*/
;*    slot-stat-indexed-ref ...                                        */
;*---------------------------------------------------------------------*/
(define (slot-stat-indexed-ref class-id type slot widening)
   (slot-indexed-ref class-id
		     type
		     slot
		     widening
		     `(free-pragma::long ,(slot-stat-bound slot))))

;*---------------------------------------------------------------------*/
;*    slot-indexed-ref ...                                             */
;*---------------------------------------------------------------------*/
(define (slot-indexed-ref class-id type slot widening max-bound)
   (define (indexed-ref-unsafe slot-ref-id slot-ref-tid)
      `(define-inline (,slot-ref-tid ,(symbol-append 'obj 4dots (type-id type))
				     index::long)
	  ,(make-pragma-indexed-ref/widening type
					     slot
					     'obj
					     'index
					     widening)))
   (define (indexed-ref-safe slot-ref-id slot-ref-tid)
      `(define (,slot-ref-tid ,(symbol-append 'obj 4dots (type-id type))
			      index::long)
	  (if (>=fx index 0)
	      (if (<fx index ,max-bound)
		  ,(make-pragma-indexed-ref/widening type
						     slot
						     'obj
						     'index
						     widening)
		  (error ',slot-ref-id "Index out of bound" index))
	      (error ',slot-ref-id "Index out of bound" index))))
   (let* ((slot-ref-id  (symbol-append class-id '- (slot-id slot) '-ref))
	  (slot-ref-tid (symbol-append slot-ref-id
				       4dots
				       (type-id (slot-type slot))))
	  (tid          (symbol-append 4dots (type-id type)))
	  (holder       (class-holder type)))
      (cond
	 ((not *unsafe-range*)
	  (produce-module-clause! `(static (,slot-ref-tid ,tid ::long)))
	  (produce-module-clause! `(pragma (,slot-ref-id side-effect-free
							 no-cfa-top)))
	  (list (indexed-ref-safe slot-ref-id slot-ref-tid)))
	 (else
	  (produce-module-clause! `(static (inline ,slot-ref-tid ,tid ::long)))
	  (produce-module-clause! `(pragma (,slot-ref-id side-effect-free
							 no-cfa-top)))
	  (list (indexed-ref-unsafe slot-ref-id slot-ref-tid))))))

;*---------------------------------------------------------------------*/
;*    slot-direct-ref ...                                              */
;*---------------------------------------------------------------------*/
(define (slot-direct-ref class-id type slot widening)
   (let* ((slot-ref-id  (symbol-append class-id '- (slot-id slot)))
	  (slot-ref-tid (symbol-append slot-ref-id
				       4dots
				       (type-id (slot-type slot))))
	  (tid          (symbol-append 4dots (type-id type)))
	  (holder       (class-holder type)))
      (cond
	 ((<fx *optim* 2)
	  (produce-module-clause! `(static (,slot-ref-tid ,tid)))
	  (produce-module-clause! `(pragma (,slot-ref-id side-effect-free
							 no-cfa-top)))
	  (list
	   `(define (,slot-ref-tid ,(symbol-append 'obj tid))
	       ,(make-pragma-direct-ref/widening type slot 'obj widening))))
	 (else
	  (produce-module-clause! `(static (inline ,slot-ref-tid ,tid)))
	  (produce-module-clause! `(pragma (,slot-ref-id side-effect-free
							 no-cfa-top)))
	  (list
	   `(define-inline (,slot-ref-tid ,(symbol-append 'obj tid))
	       ,(make-pragma-direct-ref/widening type slot 'obj widening)))))))

;*---------------------------------------------------------------------*/
;*    slot-set! ...                                                    */
;*---------------------------------------------------------------------*/
(define (slot-set! class-id type slot widening)
   (cond
      ((slot-dyna-indexed? slot)
       (slot-dyna-indexed-set! class-id type slot widening))
      ((slot-stat-indexed? slot)
       (slot-stat-indexed-set! class-id type slot widening))
      (else
       (slot-direct-set! class-id type slot widening))))

;*---------------------------------------------------------------------*/
;*    slot-dyna-indexed-set! ...                                       */
;*---------------------------------------------------------------------*/
(define (slot-dyna-indexed-set! class-id type slot widening)
   (slot-indexed-set! class-id
		     type
		     slot
		     widening
		     `(,(symbol-append class-id '- (slot-id slot) '-len) obj)))

;*---------------------------------------------------------------------*/
;*    slot-stat-indexed-set! ...                                       */
;*---------------------------------------------------------------------*/
(define (slot-stat-indexed-set! class-id type slot widening)
   (slot-indexed-set! class-id
		     type
		     slot
		     widening
		     `(free-pragma::long ,(slot-stat-bound slot))))

;*---------------------------------------------------------------------*/
;*    slot-indexed-set! ...                                            */
;*---------------------------------------------------------------------*/
(define (slot-indexed-set! class-id type slot widening max-bound)
   (define (indexed-set!-unsafe slot-set!-id slot-set!-tid val-id val-tid)
      `(define-inline (,slot-set!-tid ,(symbol-append 'obj
						      4dots
						      (type-id type))
				     index::long
				     ,val-tid)
	  ,(make-pragma-indexed-set!/widening type
					     slot
					     'obj
					     val-id
					     'index
					     widening)))
   (define (indexed-set!-safe slot-set!-id slot-set!-tid val-id val-tid)
      `(define (,slot-set!-tid ,(symbol-append 'obj 4dots (type-id type))
			       index::long
			       ,val-tid)
	  (if (>=fx index 0)
	      (if (<fx index ,max-bound)
		  ,(make-pragma-indexed-set!/widening type
						     slot
						     'obj
						     val-id
						     'index
						     widening)
		  (error ',slot-set!-id "Index out of bound" index))
	      (error ',slot-set!-id "Index out of bound" index))))
   (let* ((slot-set!-id  (symbol-append class-id '- (slot-id slot) '-set!))
	  (slot-set!-tid (symbol-append slot-set!-id '::unspecified))
	  (tid           (symbol-append 4dots (type-id type)))
	  (holder        (class-holder type))
	  (v-id          (gensym 'val))
	  (v-tid         (symbol-append v-id
					4dots
					(type-id (slot-type slot)))))
      (cond
	 ((not *unsafe-range*)
	  (produce-module-clause! `(static (,slot-set!-tid ,tid
							   ::long
							     ,v-tid)))
	  (list (indexed-set!-safe slot-set!-id slot-set!-tid v-id v-tid)))
	 (else
	  (produce-module-clause! `(static (inline ,slot-set!-tid
						   ,tid
						   ::long
						     ,v-tid)))
	  (list
	   (indexed-set!-unsafe slot-set!-id slot-set!-tid v-id v-tid))))))

;*---------------------------------------------------------------------*/
;*    slot-direct-set! ...                                             */
;*---------------------------------------------------------------------*/
(define (slot-direct-set! class-id type slot widening)
   (let* ((slot-set!-id  (symbol-append class-id '- (slot-id slot) '-set!))
	  (slot-set!-tid (symbol-append slot-set!-id '::unspecified))
	  (tid           (symbol-append 4dots (type-id type)))
	  (holder        (class-holder type))
	  (v-id          (gensym 'val))
	  (v-tid         (symbol-append v-id
					4dots
					(type-id (slot-type slot)))))
      (cond
	 ((<fx *optim* 2)
	  (produce-module-clause! `(static (,slot-set!-tid ,tid ,v-tid)))
	  (list
	   `(define (,slot-set!-tid ,(symbol-append 'obj tid) ,v-tid)
	       ,(make-pragma-direct-set!/widening type
						  slot
						  'obj
						  v-id
						  widening))))
	 (else
	  (produce-module-clause! `(static (inline ,slot-set!-tid
						   ,tid
						   ,v-tid)))
	  (list
	   `(define-inline (,slot-set!-tid ,(symbol-append 'obj tid) ,v-tid)
	       ,(make-pragma-direct-set!/widening type
						  slot
						  'obj
						  v-id
						  widening)))))))





