;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Object/method.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed May  1 13:58:40 1996                          */
;*    Last change :  Fri Feb  6 13:51:56 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The method management                                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module object_method
   (import tools_args
	   tools_error
	   tools_misc
	   type_type
	   ast_var
	   ast_ident
	   ast_env
	   object_class
	   object_inline)
   (export (make-method-body ::symbol ::obj ::obj ::obj ::obj)))

;*---------------------------------------------------------------------*/
;*    make-method-body ...                                             */
;*---------------------------------------------------------------------*/
(define (make-method-body id args locals body src)
   (let* ((id      (id-of-id id))
	  (method  (gensym 'next-method))
	  (arity   (arity args))
	  (args-id (map local-id locals))
	  (type    (local-type (car locals)))
	  ;; The name of the method is constructed using the id of the
	  ;; associated generic function _and_ the type id of the
	  ;; method.
	  (m-id    (symbol-append id '- (type-id type))))
      (if (not (class? type))
	  (method-error id "method has a non-class dispatching type arg" src)
	  (let* ((holder  (class-holder type))
		 (module  (global-module holder))
		 (generic (find-global id)))
	     (cond
		((not (global? generic))
		 (method-error id "Can't find generic for method" src))
		((or (not (method-inlining-enabled?))
		     (eq? (global-import generic) 'import))
		 (list
		  `(labels ((,m-id ,args
		      (labels ((call-next-method ()
			 (let ((,method (find-super-class-method
					 ,(car args-id)
					 ,id
					 (@ ,(global-id holder) ,module))))
			    (if (procedure? ,method)
				,(if (>=fx arity 0)
				     `(,method ,@args-id)
				     `(apply ,method (cons* ,@args-id)))
				(begin
				   (generic-pre-method-set! ,id ,method)
				   ,(if (>=fx arity 0)
					`(,id ,@args-id)
					`(apply ,id (cons* ,@args-id))))))))
			 ,body)))
		      (add-method! ,id
				   (@ ,(global-id holder) ,module)
			 	   ,m-id))))
		(else
		 ;; in all the case the call `add-generic-method-inlining!'
		 ;; if the generic has already been added, this call will
		 ;; be nop equivalent.
		 (add-generic-for-method-inlining! generic)
		 ;; and now we add the method definition.
		 (let ((num (add-generic-method! generic type args body)))
		    (list `(add-inlined-method!
			    ,id
			    (@ ,(global-id holder) ,module)
			    ,num)))))))))
 
;*---------------------------------------------------------------------*/
;*    method-error ...                                                 */
;*---------------------------------------------------------------------*/
(define (method-error id msg src)
   (user-error id msg src (list ''method-definition-error)))
