;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Read/access.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 17 11:33:41 1993                          */
;*    Last change :  Tue Jun 11 12:01:04 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The module which handle access tables `module/name'              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module read_access
   (import engine_param
	   engine_engine
	   tools_error
	   init_main)
   (export (add-access! module::symbol files::pair)
	   (read-access-file)))

;*---------------------------------------------------------------------*/
;*    add-access! ...                                                  */
;*---------------------------------------------------------------------*/
(define (add-access! module files)
   (let ((b (assq module *access-table*)))
      (if (not b)
	  (set! *access-table* (cons (cons module files) *access-table*))
	  (if (not (equal? (cdr b) files))
	      (warning "add-access!" "access redefinition -- " module)
	      'done))))
	   
;*---------------------------------------------------------------------*/
;*    read-access-file ...                                             */
;*    -------------------------------------------------------------    */
;*    Cette fonction fait des effets de bords sur `*access-table*'     */
;*---------------------------------------------------------------------*/
(define (read-access-file)
   (cond
      ((not (string? *access-file*))
       'done)
      ((not (file-exists? *access-file*))
       (user-error "read-access-file" "Can't find access file" *access-file*))
      (else
       (let ((port (open-input-file *access-file*)))
	  (if (not (input-port? port))
	      (user-error "read-access-file"
			  "Can't open access file"
			  *access-file*)
	      (begin
		 (do-read-access-file port)
		 (close-input-port port)))))))

;*---------------------------------------------------------------------*/
;*    do-read-access-file ...                                          */
;*---------------------------------------------------------------------*/
(define (do-read-access-file port)
   (labels ((handler (escape proc mes obj)
		     (notify-error proc mes obj)
		     (close-output-port port)
		     (exit-bigloo -2)))
      (try (let* ((obj (read port #t))
		  (eof (read port)))
	      (if (not (eof-object? eof))
		  (user-error "read-access-file"
			      "Illegal access file format"
			      eof)
		  (let loop ((obj obj))
		     (if (null? obj)
			 'done
			 (match-case (car obj)
			    (((and (? symbol?) ?m) (and ?f (? string?)) . ?fs)
			     (let loop ((fs     fs)
					(fnames (list f)))
				(cond
				   ((null? fs)
				    (add-access! m (reverse! fnames)))
				   ((string? (car fs))
				    (loop (cdr fs)
					  (cons (car fs) fnames)))
				   (else
				    (user-error "read-access-file"
						"Illegal access file format"
						(car obj)))))
			     (loop (cdr obj)))
			    (else
			     (user-error "read-access-file"
					 "Illegal access file format"
					 (car obj))))))))
	   handler)))
			 
