/* --------------------------------------------------------------------*/
/*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \   /  '                               */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome. Send them to                                          */
/*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
/*-------------------------------------------------------------------- */
/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime1.9/Clib/vector.c             */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Mon May  8 14:16:24 1995                          */
/*    Last change :  Thu Jul 18 12:00:29 1996 (serrano)                */
/*    -------------------------------------------------------------    */
/*    C vector managment                                               */
/*=====================================================================*/
#include <bigloo1.9c.h>

extern obj_t string_to_bstring();

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    fill_vector ...                                                  */
/*---------------------------------------------------------------------*/
obj_t
fill_vector( bvector, len, init )
obj_t  bvector;
long   len;
obj_t  init;
{
   obj_t *walker;

   /* on fait la `strength reduction' a la main car ce code est  */
   /* critique donc on veut etre sur qu'il bombarde.             */
   for( walker = (obj_t *)(&VECTOR_REF( bvector, 0 )); len; len-- )
      *walker++ = init;

   return BUNSPEC;
}

/*---------------------------------------------------------------------*/
/*    create_vector ...                                                */
/*---------------------------------------------------------------------*/
obj_t
create_vector( len )
long len;
{
   obj_t vector;

   if( len & ~(VECTOR_LENGTH_MASK) )
      FAILURE( string_to_bstring( "create_vector" ),
	       string_to_bstring( "vector too large" ),
	       BINT( len ) );
   else
   {
      long byte_size;

      byte_size = VECTOR_SIZE + ( (len-1) * OBJ_SIZE );

      vector = GC_MALLOC( byte_size );

#if( !defined( TAG_VECTOR ) )
      vector->vector_t.header = MAKE_HEADER( VECTOR_TYPE, byte_size );
#endif		
      vector->vector_t.length = len;

      return BVECTOR( vector );
   }
}

/*---------------------------------------------------------------------*/
/*    make_vector ...                                                  */
/*---------------------------------------------------------------------*/
obj_t
make_vector( len, init )
long   len;
obj_t  init;
{
   obj_t vector;

   vector = BVECTOR( create_vector( len ) );
   fill_vector( vector, len, init );
	
   return vector;
}



