/* --------------------------------------------------------------------*/
/*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \   /  '                               */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome. Send them to                                          */
/*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
/*-------------------------------------------------------------------- */
/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Clib/trace.c                 */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Fri Mar 31 18:06:36 1995                          */
/*    Last change :  Fri Feb 20 17:54:17 1998 (serrano)                */
/*    -------------------------------------------------------------    */
/*    We dump a execution trace                                        */
/*=====================================================================*/
#if( !defined( BIGLOO_DEBUG ) )
#   define BIGLOO_DEBUG
#endif

#include <bigloo1.9c.h>

/*---------------------------------------------------------------------*/
/*    Globals variables                                                */
/*---------------------------------------------------------------------*/
struct dframe *top_of_frame = 0L;
struct dframe frame;

/*---------------------------------------------------------------------*/
/*    dump_trace_stack ...                                             */
/*---------------------------------------------------------------------*/
obj_t
dump_trace_stack( obj_t port, long depth )
{
   long           level = 0L;
   struct dframe *runner = top_of_frame;
   obj_t          old = 0;
   int            recursion = 0;

   while( (level < depth) && runner && (runner != &frame) )
   {
      if( SYMBOLP( runner->symbol ) )
      {
	 if( EQP( runner->symbol, old ) )
	    recursion++, depth++;
	 else
	 {
	    if( recursion > 0 )
	       fprintf( OUTPUT_PORT( port ).file,
			" (%d times)\n",
			1 + recursion );
	    else
	    {
	       if( level > 0 )
		  fprintf( OUTPUT_PORT( port ).file, "\n" );
	    }
	    
	    fprintf( OUTPUT_PORT( port ).file,
		     "  %3ld. %s",
		     level,
		     SYMBOL( runner->symbol ).name );
	    
	    recursion = 0;
	 }
	 old = runner->symbol;
			
	 level++; 
      }
      
      runner = runner->link;
   }
   fprintf( OUTPUT_PORT( port ).file, "\n" );
   
   return BUNSPEC;
}

/*---------------------------------------------------------------------*/
/*    cref ...                                                         */
/*---------------------------------------------------------------------*/
obj_t
cref( obj )
obj_t obj;
{
   return CREF( obj );
}

/*---------------------------------------------------------------------*/
/*    car ...                                                          */
/*---------------------------------------------------------------------*/
obj_t
car( obj_t obj )
{
   return CAR( obj );
}

/*---------------------------------------------------------------------*/
/*    cdr ...                                                          */
/*---------------------------------------------------------------------*/
obj_t
cdr( obj_t obj )
{
   return CDR( obj );
}

/*---------------------------------------------------------------------*/
/*    byteshow ...                                                     */
/*---------------------------------------------------------------------*/
static void
byteshow( unsigned char *addr )
{
#define PP_CHAR( c ) (((c) >= 33) && ((c) < 127)) ? c : '.'

   printf( "  %08x  :  %02x %02x %02x %02x  :  %c%c%c%c\n",
           (unsigned long)addr,
           addr[ 0 ],
           addr[ 1 ],
           addr[ 2 ],
           addr[ 3 ],
           PP_CHAR( addr[ 0 ] ),
           PP_CHAR( addr[ 1 ] ),
           PP_CHAR( addr[ 2 ] ),
           PP_CHAR( addr[ 3 ] ) );
}
             
/*---------------------------------------------------------------------*/
/*    memshow ...                                                      */
/*---------------------------------------------------------------------*/
void
memshow( char *from, char *to, long step )
{
   char *i;

   step *= 4;
      
   if( from > to )
      for( i = from; i > to; i -= step )
         byteshow( i );
   else
      for( i = from; i < to; i += step )
         byteshow( i );

   puts( "" );
   return ;
}
