;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Llib/unicode.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Mar 20 19:17:18 1995                          */
;*    Last change :  Fri Feb  6 16:58:46 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Unicode (UCS-2) strings handling.                                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __unicode

   (import  (__error                   "Llib/error.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__ucs2                    "Llib/ucs2.scm")
	    
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")

	    (__evenv                   "Eval/evenv.scm"))
   
   (extern (macro c-ucs2-string?::bool       (::obj)
		  "UCS2_STRINGP")
	   (c-make-ucs2-string::ucs2string   (::long ::ucs2)
		  "make_ucs2_string")
	   (macro c-ucs2-string-length::long (::ucs2string)
		  "UCS2_STRING_LENGTH")
	   (macro c-ucs2-string-ref::ucs2    (::ucs2string ::long)
		  "UCS2_STRING_REF")
	   (macro c-ucs2-string-set!::obj    (::ucs2string ::long ::ucs2)
		  "UCS2_STRING_SET")
	    
	   (c-ucs2-string=?::bool  (::ucs2string ::ucs2string)
				   "ucs2_strcmp")
	   (ucs2-strcicmp::bool    (::ucs2string ::ucs2string)
				   "ucs2_strcicmp")
	   (ucs2-string_lt::bool   (::ucs2string ::ucs2string)
				   "ucs2_string_lt")
	   (ucs2-string_le::bool   (::ucs2string ::ucs2string)
				   "ucs2_string_le")
	   (ucs2-string_gt::bool   (::ucs2string ::ucs2string)
				   "ucs2_string_gt")
	   (ucs2-string_ge::bool   (::ucs2string ::ucs2string)
				   "ucs2_string_ge")
	   (ucs2-string_cilt::bool (::ucs2string ::ucs2string)
				   "ucs2_string_cilt")
	   (ucs2-string_cile::bool (::ucs2string ::ucs2string)
				   "ucs2_string_cile")
	   (ucs2-string_cigt::bool (::ucs2string ::ucs2string)
				   "ucs2_string_cigt")
	   (ucs2-string_cige::bool (::ucs2string ::ucs2string)
				   "ucs2_string_cige")

	   (escape-C-string::ucs2string      (::string)
					     "escape_ucs2_string")
	   (c-ucs2-string-copy::ucs2string   (::ucs2string)
					     "c_ucs2_string_copy")
	   (c-subucs2-string::ucs2string     (::ucs2string ::long ::long)
					     "c_subucs2_string")
	   (c-ucs2-string-append::ucs2string (::ucs2string ::ucs2string)
					     "ucs2_string_append")
	    
	   (ucs2-string-bound-check?::bool      (::long ::long)
						"BOUND_CHECK")
	   (c-ucs2-string->utf8-string::bstring (::ucs2string)
						"ucs2_string_to_utf8_string")
	   (c-utf8-string->ucs2-string::ucs2string (::bstring)
						"utf8_string_to_ucs2_string"))
   
   (export  (inline ucs2-string?::bool             ::obj)
	    (inline make-ucs2-string::ucs2string   ::int . ucs2)
	    (inline ucs2-string::ucs2string        . ucs2s)
	    (inline ucs2-string-length::long       ::ucs2string)
	    (inline ucs2-string-ref::ucs2          ::ucs2string ::long)
	    (inline ucs2-string-set!::obj          ::ucs2string ::long ::ucs2)
	    (inline ucs2-string-ref-ur::ucs2       ::ucs2string ::long)
	    (inline ucs2-string-set-ur!::obj       ::ucs2string ::long ::ucs2)
	    (inline ucs2-string=?::bool            ::ucs2string ::ucs2string)
	    (inline ucs2-string-ci=?::bool         ::ucs2string ::ucs2string)
	    (inline ucs2-string<?::bool            ::ucs2string ::ucs2string)
	    (inline ucs2-string>?::bool            ::ucs2string ::ucs2string)
	    (inline ucs2-string<=?::bool           ::ucs2string ::ucs2string)
	    (inline ucs2-string>=?::bool           ::ucs2string ::ucs2string)
	    (inline ucs2-string-ci<?::bool         ::ucs2string ::ucs2string)
	    (inline ucs2-string-ci>?::bool         ::ucs2string ::ucs2string)
	    (inline ucs2-string-ci<=?::bool        ::ucs2string ::ucs2string)
	    (inline ucs2-string-ci>=?::bool        ::ucs2string ::ucs2string)
	    (inline subucs2-string::ucs2string     ::ucs2string ::long ::long)
	    (inline subucs2-string-ur::ucs2string  ::ucs2string ::long ::long)
	    (ucs2-string-append::ucs2string        . ucs2-strings)
	    (ucs2-string->list                     ::ucs2string)
	    (list->ucs2-string::ucs2string         ::obj)
	    (inline ucs2-string-copy::ucs2string   ::ucs2string)
	    (ucs2-string-fill!::ucs2string         ::ucs2string ::ucs2)
	    (ucs2-string-upcase::ucs2string        ::ucs2string)
	    (ucs2-string-downcase::ucs2string      ::ucs2string)
	    (ucs2-string-upcase!::ucs2string       ::ucs2string)
	    (ucs2-string-downcase!::ucs2string     ::ucs2string)
	    (inline ucs2-string->utf8-string::bstring    ::ucs2string)
	    (inline utf8-string->ucs2-string::ucs2string ::bstring))
    
   (pragma  (c-ucs2-string? (predicate-of ucs2string) no-cfa-top)
	    (ucs2-string? side-effect-free no-cfa-top)
	    (c-ucs2-string-ref side-effect-free no-cfa-top)
	    (ucs2-string-ref-ur side-effect-free no-cfa-top)
	    (ucs2-string-ref side-effect-free no-cfa-top)
	    (c-ucs2-string-length side-effect-free no-cfa-top)
	    (ucs2-string-length side-effect-free no-cfa-top)
	    (ucs2-string=? side-effect-free)
	    (ucs2-string-ci=? side-effect-free)
	    (ucs2-string<? side-effect-free)
	    (ucs2-string>? side-effect-free)
	    (ucs2-string<=? side-effect-free)
	    (ucs2-string>=? side-effect-free)
	    (ucs2-string-ci<? side-effect-free)
	    (ucs2-string-ci>? side-effect-free)
	    (ucs2-string-ci<=? side-effect-free)
	    (ucs2-string-ci>=? side-effect-free)))
  
;*---------------------------------------------------------------------*/
;*    ucs2-string? ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (ucs2-string? obj)
   (c-ucs2-string? obj))

;*---------------------------------------------------------------------*/
;*    make-ucs2-string ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (make-ucs2-string k . ucs2)
   (if (null? ucs2)
       (c-make-ucs2-string k (char->ucs2 #\space))
       (c-make-ucs2-string k (car ucs2))))
 
;*---------------------------------------------------------------------*/
;*    ucs2-string ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (ucs2-string . ucs2s)
   (list->ucs2-string ucs2s))

;*---------------------------------------------------------------------*/
;*    ucs2-string-length ...                                           */
;*---------------------------------------------------------------------*/
(define-inline (ucs2-string-length ucs2-string)
   (c-ucs2-string-length ucs2-string))

;*---------------------------------------------------------------------*/
;*    ucs2-string-ref ...                                              */
;*---------------------------------------------------------------------*/
(define-inline (ucs2-string-ref ucs2-string k)
   (if (string-bound-check? k (ucs2-string-length ucs2-string))
       (c-ucs2-string-ref ucs2-string k)
       (error "ucs2-string-ref" "index out of range" k)))
 
;*---------------------------------------------------------------------*/
;*    ucs2-string-set! ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (ucs2-string-set! ucs2-string k ucs2)
   (if (string-bound-check? k (ucs2-string-length ucs2-string))
       (c-ucs2-string-set! ucs2-string k ucs2)
       (error "ucs2-string-set!" "index out of range" k)))

;*---------------------------------------------------------------------*/
;*    ucs2-string-ref-ur ...                                           */
;*---------------------------------------------------------------------*/
(define-inline (ucs2-string-ref-ur ucs2-string k)
   (c-ucs2-string-ref ucs2-string k))
 
;*---------------------------------------------------------------------*/
;*    ucs2-string-set-ur! ...                                          */
;*---------------------------------------------------------------------*/
(define-inline (ucs2-string-set-ur! ucs2-string k ucs2)
   (c-ucs2-string-set! ucs2-string k ucs2))

;*---------------------------------------------------------------------*/
;*    ucs2-string=? ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (ucs2-string=? ucs2-string1 ucs2-string2)
   (c-ucs2-string=? ucs2-string1 ucs2-string2))

;*---------------------------------------------------------------------*/
;*    ucs2-string-ci=? ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (ucs2-string-ci=? ucs2-string1 ucs2-string2)
   (ucs2-strcicmp ucs2-string1 ucs2-string2))

;*---------------------------------------------------------------------*/
;*    ucs2-string<? ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (ucs2-string<? ucs2-string1 ucs2-string2)
   (ucs2-string_lt ucs2-string1 ucs2-string2))

;*---------------------------------------------------------------------*/
;*    ucs2-string>? ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (ucs2-string>? ucs2-string1 ucs2-string2)
   (ucs2-string_gt ucs2-string1 ucs2-string2))

;*---------------------------------------------------------------------*/
;*    ucs2-string<=? ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (ucs2-string<=? ucs2-string1 ucs2-string2)
   (ucs2-string_le ucs2-string1 ucs2-string2))

;*---------------------------------------------------------------------*/
;*    ucs2-string>=? ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (ucs2-string>=? ucs2-string1 ucs2-string2)
   (ucs2-string_ge ucs2-string1 ucs2-string2))

;*---------------------------------------------------------------------*/
;*    ucs2-string-ci<? ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (ucs2-string-ci<? ucs2-string1 ucs2-string2)
   (ucs2-string_cilt ucs2-string1 ucs2-string2))

;*---------------------------------------------------------------------*/
;*    ucs2-string-ci>? ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (ucs2-string-ci>? ucs2-string1 ucs2-string2)
   (ucs2-string_cigt ucs2-string1 ucs2-string2))

;*---------------------------------------------------------------------*/
;*    ucs2-string-ci<=? ...                                            */
;*---------------------------------------------------------------------*/
(define-inline (ucs2-string-ci<=? ucs2-string1 ucs2-string2)
   (ucs2-string_cile ucs2-string1 ucs2-string2))

;*---------------------------------------------------------------------*/
;*    ucs2-string-ci>=? ...                                            */
;*---------------------------------------------------------------------*/
(define-inline (ucs2-string-ci>=? ucs2-string1 ucs2-string2)
   (ucs2-string_cige ucs2-string1 ucs2-string2))

;*---------------------------------------------------------------------*/
;*    suucs2-string ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (subucs2-string ucs2-string start end)
   ;; no macro on inline so we don't use `and'
   (if (if (>=fx end start)
	   (if (string-bound-check? start
				    (+fx (ucs2-string-length ucs2-string) 1))
	       (string-bound-check? end
				    (+fx (ucs2-string-length ucs2-string) 1))
	       #f)
	   #f)
       (c-subucs2-string ucs2-string start end)
       (error "subucs2-string" "Illegal index" (cons start end))))

;*---------------------------------------------------------------------*/
;*    suucs2-string-ur ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (subucs2-string-ur ucs2-string start end)
   (c-subucs2-string ucs2-string start end))

;*---------------------------------------------------------------------*/
;*    ucs2-string-append ...                                           */
;*---------------------------------------------------------------------*/
(define (ucs2-string-append . list)
   (if (null? list)
       (make-ucs2-string 0)
       (let loop ((list list))
	  (if (null? (cdr list))
	      (car list)
	      (c-ucs2-string-append (car list) (loop (cdr list)))))))

;*---------------------------------------------------------------------*/
;*    list->ucs2-string ...                                            */
;*---------------------------------------------------------------------*/
(define (list->ucs2-string list)
   (let* ((len    (length list))
	  (ucs2-string (make-ucs2-string len)))
      (let loop ((i 0)
		 (l list))
	 (if (=fx i len)
	     ucs2-string
	     (begin
		(ucs2-string-set! ucs2-string i (car l))
		(loop (+fx i 1) (cdr l)))))))

;*---------------------------------------------------------------------*/
;*    ucs2-string->list ...                                            */
;*---------------------------------------------------------------------*/
(define (ucs2-string->list ucs2-string)
   (let ((len (ucs2-string-length ucs2-string)))
      (let loop ((i   0)
		 (acc '()))
	 (if (=fx i len)
	     (reverse! acc)
	     (loop (+fx i 1)
		   (cons (ucs2-string-ref ucs2-string i)
			 acc))))))

;*---------------------------------------------------------------------*/
;*    ucs2-string-copy ...                                             */
;*---------------------------------------------------------------------*/
(define-inline (ucs2-string-copy ucs2-string)
   (c-ucs2-string-copy ucs2-string))

;*---------------------------------------------------------------------*/
;*    ucs2-string-fill! ...                                            */
;*---------------------------------------------------------------------*/
(define (ucs2-string-fill! ucs2-string ucs2)
   (let ((len (ucs2-string-length ucs2-string)))
      (let loop ((i 0))
	 (if (=fx i len)
	     ucs2-string
	     (begin
		(ucs2-string-set! ucs2-string i ucs2)
		(loop (+fx i 1)))))))

;*---------------------------------------------------------------------*/
;*    ucs2-string-upcase ...                                           */
;*---------------------------------------------------------------------*/
(define (ucs2-string-upcase ucs2-string)
   (let* ((len (ucs2-string-length ucs2-string))
	  (res (make-ucs2-string len)))
      (let loop ((i 0))
	 (if (=fx i len)
	     res
	     (begin
		(ucs2-string-set! res
				  i
				  (ucs2-upcase (ucs2-string-ref ucs2-string
								i)))
		(loop (+fx i 1)))))))

;*---------------------------------------------------------------------*/
;*    ucs2-string-downcase ...                                         */
;*---------------------------------------------------------------------*/
(define (ucs2-string-downcase ucs2-string)
   (let* ((len (ucs2-string-length ucs2-string))
	  (res (make-ucs2-string len)))
      (let loop ((i 0))
	 (if (=fx i len)
	     res
	     (begin
		(ucs2-string-set! res
				  i
				  (ucs2-downcase (ucs2-string-ref ucs2-string
								  i)))
		(loop (+fx i 1)))))))

;*---------------------------------------------------------------------*/
;*    ucs2-string-upcase! ...                                          */
;*---------------------------------------------------------------------*/
(define (ucs2-string-upcase! ucs2-string)
   (let* ((len (ucs2-string-length ucs2-string))
	  (res ucs2-string))
      (let loop ((i 0))
	 (if (=fx i len)
	     res
	     (begin
		(ucs2-string-set! res
				  i
				  (ucs2-upcase (ucs2-string-ref ucs2-string
								i)))
		(loop (+fx i 1)))))))

;*---------------------------------------------------------------------*/
;*    ucs2-string-downcase! ...                                        */
;*---------------------------------------------------------------------*/
(define (ucs2-string-downcase! ucs2-string)
   (let* ((len (ucs2-string-length ucs2-string))
	  (res ucs2-string))
      (let loop ((i 0))
	 (if (=fx i len)
	     res
	     (begin
		(ucs2-string-set! res
				  i
				  (ucs2-downcase (ucs2-string-ref ucs2-string
								  i)))
		(loop (+fx i 1)))))))
		 		 
;*---------------------------------------------------------------------*/
;*    ucs2-string->utf8-string ...                                     */
;*---------------------------------------------------------------------*/
(define-inline (ucs2-string->utf8-string ucs2)
   (c-ucs2-string->utf8-string ucs2))

;*---------------------------------------------------------------------*/
;*    utf8-string->ucs2-string ...                                     */
;*---------------------------------------------------------------------*/
(define-inline (utf8-string->ucs2-string utf8)
   (c-utf8-string->ucs2-string utf8))
