package biss.calendar;

import biss.DateLib;
import biss.VectorLib;
import biss.VectorSorter;
import java.io.FileInputStream;
import java.util.Date;
import java.util.Vector;

public class DateParser
{
	protected FileInputStream S;
	protected int Line;
	public String Error;

String nextToken ( int nParts, boolean isNewLine, char[] buffer ) {
	int i;
	char c;

	try {	
		for ( c= (char) S.read(); c != -1; c = (char)S.read()){
			if ( c == '\n' || c == '\r' ) {
				if ( !isNewLine ) return null;
				if ( c == '\n') Line++;
			}
			if ( isNewLine && c == '#' ) {
				for ( c=(char)S.read(); c != '\n' && c != -1; c=(char)S.read() );
				Line++;
			}
			else if ( c > ' ' ) break;
		}

		for ( i=0; ; c = (char)S.read() ) {
			if ( c == '\r' || c == '\n' ) break;
			else if ( (c == '\t' || c == ' ') ) {
				if ( --nParts == 0 )
					break;
				else
					do
				buffer[i++] = c;
				while ( (c=(char)S.read()) == ' ' || c == '\t' );
			}
			buffer[i++] = c;
		}
	}
	catch ( Exception x ) {	return null; }

	return (i > 0) ? new String( buffer, 0, i) : null;
}

public Vector parseFile ( String fname ) {
	Vector list = new Vector();
	char[] buf = new char[256];
	String tok;
	boolean alert;
	String[] field = { "StartDatum", "EndDatum", "Status", "Kategorie",
		"PaID", "Bescheibung", "Alarm", "AlarmDatum", "Text"};
	int n = 0;
	VectorSorter sorter = new DateEntrySorter();

	try {
		S = new FileInputStream( fname);
		Line = 0; Error = null;
		while ( (tok = nextToken( 2, true, buf)) != null ) {
			try {
				n = 0;
				DateEntry t = new DateEntry();
				t.SDate = DateLib.dateFromEDTF( tok); n++;
				t.EDate = DateLib.dateFromEDTF( nextToken( 2, true, buf)); n++;
				t.State = Integer.parseInt( nextToken( 1, false, buf)); n++;
				t.Category = Integer.parseInt( nextToken( 1, false, buf)); n++;
				t.PaId = Integer.parseInt( nextToken( 1, false, buf)); n++;
				t.setDetailFile( nextToken( 1, false, buf)); n++;
				alert = nextToken( 1, true, buf).charAt( 0) == 'a'; n++;
				if ( alert)
					t.ADate = DateLib.dateFromEDTF( nextToken( 2, true, buf)); n++;
				t.ItemText = nextToken( 0, false, buf); n++;

				VectorLib.sortIn( list, t, sorter);
			}
			catch ( Exception x ) {
				Error = "parse error in line: " + Line +
				", field: " + field[n];
				return null;
			}
		}

		S.close();
		return list;
	}
	catch ( Exception x ) {
		Error = "line: " + Line + ", " + x.toString();
		return null;
	}
}
}
