package biss.calendar;

import biss.DateLib;
import biss.awt.List;
import biss.awt.PanePrinter;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;

public class DatePrinter
  extends PanePrinter
  implements Observer
{
	int Mode;
	Date SDate;

public DatePrinter ( List p, int mode, Date dt, String pathName) {
	super( p, 20, 20);

	Mode = mode;
	SDate = dt;

	OsDrawHeader.addObserver( this);
	OsDrawFooter.addObserver( this);

	printTo( pathName);
}

public void drawFooter () {
	Rectangle r = FooterRect;
	int       y = r.y;
	String    pgStr = "Seite " + CurrentPage +  "/" + TotalPages;

	PostGr.setColor( Color.black);

	PostGr.setLineWidth( 2);
	PostGr.drawLine( r.x, y, r.x + r.width, y);
	PostGr.setLineWidth( 0);

	y += 10 + Calendar.SmallFontMetrics.getHeight();
	PostGr.setFont( Calendar.SmallFont);
	PostGr.drawString( "(C)BISS GmbH, Wilhelmshaven 1996, All Rights reserved",
	                   r.x, y );
	PostGr.drawString( pgStr, r.x + r.width - Calendar.SmallFontMetrics.stringWidth( pgStr), y );
}

public void drawHeader () {
	String    hdrText;
	Rectangle r = HeaderRect;
	int       y = r.y + Calendar.LargeFontMetrics.getHeight();

	PostGr.setColor( Color.black);
	PostGr.setFont( Calendar.LargeFont);

	switch( Mode) {
	case 2:
		hdrText = "Wochentermine der " + DateLib.weekNumber( SDate) + ".Woche (" +
		DateLib.toEDFString( SDate) + " bis " +
		DateLib.toEDFString( DateLib.endOfWeek( SDate)) + ")";
		break;
	case 3:
		hdrText = "Monatstermine vom " + DateLib.MonthNames[SDate.getMonth()] +
		" " + ( 1900 + SDate.getYear() );
		break;
	default:
		hdrText = "Tagestermine vom " + DateLib.toDMYString( SDate);
		break;
	}

	PostGr.drawString( hdrText, r.x, y );

	PostGr.setLineWidth( 2);
	PostGr.drawLine( r.x, y+10, r.x + r.width, y+10);
	PostGr.setLineWidth( 0);
}

public void update ( Observable obs, Object arg) {
	if ( obs == OsDrawHeader)
		drawHeader();
	else if ( obs == OsDrawFooter)
		drawFooter();
}
}
