package biss.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

/**
 * replacement for java.awt.MenuBar
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class BarMenu
  extends Control
  implements HotKeyProcessor, MenuBarPeer
{
	BarMenuItem TopItem = null;
	BarMenuItem Selection = null;
	FontMetrics Fm;
	Vector Items = new Vector();
	static FontMetrics DefFm;
	Container PeerParent;

static {
	DefFm = Awt.getFontMetrics( Awt.MenuFont);
}

public BarMenu() {
	EventHandler.CursorType = Awt.ActionCursor;
	FBorder.setBorder( Border.BS_OUTSET);
	setForeground( Awt.ButtonForeClr);
	setBackground( Awt.ButtonBackClr);
	setFont( null);
}

public BarMenu( String items) {
	this();
	StringTokenizer tok = new StringTokenizer( items, ",:;");
	while( tok.hasMoreTokens() )
		addItem( tok.nextToken() );
}

public BarMenu( java.awt.MenuBar mb) {
	this();
	PeerParent = (Container)mb.getParent();
	addNotify();

	for ( int i=0; i<mb.countMenus(); i++)
		addMenu( mb.getMenu( i));
}

public void addHelpMenu( java.awt.Menu m){
	//java.awt.peer.MenuBarPeer interface
}

public void addItem( String text){
	addItem( text, null, null);
}

public void addItem( String text, String sel){
	addItem( text, sel, null);
}

public void addItem( String text, String sel, biss.awt.Menu sub){
	Items.addElement( new BarMenuItem( text, sel, sub, Fm));
}

public void addItem( String text, biss.awt.Menu sub){
	addItem( text, null, sub); 
}

public void addMenu( java.awt.Menu m){
	//java.awt.peer.MenuBarPeer interface
	int ci = m.countItems();
	biss.awt.Menu nm = (ci==0) ? null : new biss.awt.Menu();

	for ( int i=0; i<ci; i++)
		nm.addItem( m.getItem( i));

	addItem( m.getLabel(), nm);
}

public synchronized void addNotify () {
	super.addNotify();
	registerKeys();
}

public boolean canGetFocus () {
	return false;
}

public void delMenu( int index){
	//java.awt.peer.MenuBarPeer interface
	Items.removeElementAt( index);
}

public boolean disableItem( String sel){
	BarMenuItem mi = itemAt( sel);
	if ( mi != null){
		mi.Mi.disable();
		if ( isShowing() )
			redraw();
		return true;
	}
	return false;
}

public boolean enableItem( String sel){
	BarMenuItem mi = itemAt( sel);
	if ( mi != null){
		mi.Mi.enable();
		if ( isShowing() )
			redraw();
		return true;
	}
	return false;
}

public static int getDefaultHeight() {
	return (3 * Awt.SysFontHeight) / 2;
}

public biss.awt.Menu getMenu( String sel){
	BarMenuItem mi = itemAt( sel);
	if ( mi != null)
		return mi.Sub;
	return null;
}

public Container getParent(){
	if ( PeerParent != null)
		return PeerParent;
	return super.getParent();
}

public boolean hasFocus () {
	return false;
}

BarMenuItem itemAt( String sel){
	BarMenuItem mi;
	for ( int i=0; i<Items.size(); i++){
		mi = (BarMenuItem)Items.elementAt( i);
		if ( mi.Mi.Selector.equals( sel) )
			return mi;
	}
	return null;
}

BarMenuItem itemAtPos( int xPos){
	BarMenuItem mi;
	int p = FBorder.Ext;
	for ( int i=0; i<Items.size(); i++){
		mi = (BarMenuItem)Items.elementAt( i);
		p += mi.Width;
		if ( p > xPos )
			return mi;
	}
	return null;
}

public void mouse1Down( Event evt){
	BarMenuItem mi = itemAtPos( evt.x);
	if ( mi == Selection)
		return;
	if ( (mi != null) && (mi.Mi.isDisabled()) )
		return;
	EventHandler.closeMenu();
	if ( mi != null) {
		if (mi.Sub != null){
			Selection = mi;
			redraw();
			EventHandler.setMenu( Selection.Sub.Items);
			EventHandler.popUpMenuAt( xPosFor( Selection), Height);
		}
	} 
}

public void mouse1Up( Event evt){
	BarMenuItem mi = itemAtPos( evt.x);
	if ( evt.y < Height){
		if ( Selection == null){
			Selection = mi;
			trigger();
		}
	}
}

public void processKey( Object sel){
	Selection = (BarMenuItem)sel;
	trigger();
}

public void redraw( Graphics g){
	int y = Height - ( Height - Fm.getHeight()) / 2 - (Fm.getDescent()+2); 
	BarMenuItem mi;
	int p = FBorder.Ext;

	blank( g);
	clip( g);

	for ( Enumeration e = Items.elements(); e.hasMoreElements(); ){
		mi = (BarMenuItem)e.nextElement();
		mi.Mi.drawAt( g, p+mi.XOffs, y, (mi == Selection));
		p += mi.Width;
	}    
}

boolean registerKeys(){
	TopWindow tw = getTopWindow();

	if ( tw == null)
		return false;

	BarMenuItem mi;
	MenuItem m;

	for ( int i=0; i<Items.size(); i++){
		mi = (BarMenuItem)Items.elementAt( i);
		if ( (mi.Mi.MnKey != 0) && (tw != null) )
			tw.addGlobalHotKey( mi.Mi.MnKey | 32, this, mi );
		if ( mi.Sub != null){
			mi.Sub.setHandler( tw.EventHandler);
			mi.Sub.registerKeys( Awt.GlobalKeyMod );
			mi.Sub.setHandler( EventHandler);
		} 
	}

	return true;
}

public boolean setFocus(){
	Selection = null;
	redraw();
	return false;
}

public synchronized void setFont( Font fnt) {
	Font uf = ( fnt != null) ? fnt : Awt.MenuFont;

	super.setFont( uf);

	if ( uf.equals( Awt.MenuFont))
		Fm = DefFm;
	else
		Fm = Awt.DefToolkit.getFontMetrics( uf);

	if ( isShowing() )
		repaint();
}

void trigger(){
	if ( Selection != null){
		if( !Selection.Mi.isDisabled() ){
			redraw();
			Awt.DefToolkit.sync();

			OsCommand.notifyObservers( Selection.Mi.Selector);
			if ( PeerParent != null)
				PeerParent.deliverEvent( new Event( PeerParent, Event.ACTION_EVENT, Selection.Mi.Selector ));

			try { Thread.sleep( 200);}
			catch( Exception e) {}

			Selection = null;
			redraw();
		}
	}
	Selection = null;
}

int xPosFor( BarMenuItem mi){
	BarMenuItem ci;
	int p = FBorder.Ext;
	for ( int i=0; i<Items.size(); i++) {
		ci = (BarMenuItem)Items.elementAt( i);
		if ( ci == mi)
			return p;
		p += ci.Width;
	}
	return 0;
}
}

class BarMenuItem
{
	biss.awt.Menu Sub = null;
	int Width;
	biss.awt.MenuItem Mi;
	static int XOffs = 5;

public BarMenuItem( String text, String sel, biss.awt.Menu sub, FontMetrics fm){
	Mi = new MenuItem( text, sel );
	Sub = sub;
	Width = fm.stringWidth( Mi.Text) + 2 * XOffs;
}
}
