package biss.awt;


/**
 * The single reason behind this dummy interface (which is just a wrapper
 * for a bunch of "forwarded" dummy interfaces) is to ease compilation with
 * JDK 1.1. At least for a couple of months we will have to live in a hybrid
 * world of Java 1.1 and 1.0.2. Since the Peers have been changed significantly
 * in JDK 1.1, biss.awt would not compile. But we use the peer interfaces JUST
 * for the biss.awt.kernel (i.e. the implementation of "standard" Java by means
 * of the biss.awt widgets, which currently has a native lib just for kaffe. And
 * kaffe in turn is "just" 1.0.2. That means we don't need the peers if we use
 * JDK 1.1, period.
 *
 * To compile for 1.1, replace this class with the dummy-dummy version (with empty
 * *Peer interface definitions).
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.Mehlitz
 */
interface BissPeers
{

}

interface LabelPeer
  extends java.awt.peer.LabelPeer
{

}

interface ButtonPeer
  extends java.awt.peer.ButtonPeer
{

}

interface TextFieldPeer
  extends java.awt.peer.TextFieldPeer
{

}

interface TextAreaPeer
  extends java.awt.peer.TextAreaPeer
{

}

interface ListPeer
  extends java.awt.peer.ListPeer
{

}

interface ScrollbarPeer
  extends java.awt.peer.ScrollbarPeer
{

}

interface MenuPeer
  extends java.awt.peer.MenuPeer
{

}

interface MenuBarPeer
  extends java.awt.peer.MenuBarPeer
{

}

interface CheckboxPeer
  extends java.awt.peer.CheckboxPeer
{

}

interface ChoicePeer
  extends java.awt.peer.ChoicePeer
{

}

interface FileDialogPeer
  extends java.awt.peer.FileDialogPeer
{

}
