import biss.awt.TopWindow;
import java.awt.*;

public class T10
  extends TopWindow
  implements Runnable
{
	Image Img;
	Graphics Gr;

public T10 ( String title ) {
	super( title);

	openIn( 100, 100, 200, 200);

	Dimension size = size();
	Insets in = insets();

	Img = createImage( size.width - in.left - in.right,
	                   size.height - in.top - in.bottom);
	Gr  = Img.getGraphics();

	Thread animator = new Thread( this);
	animator.start();
}

public static void main ( String[] args ) {
	T10 v = new T10( "image drawing");
}

public void paint ( Graphics g ) {
	Insets in = insets();

	if ( Img != null )
		g.drawImage( Img, in.left, in.top, null);
}

public void run () {
	int w = Img.getWidth( null);
	int h = Img.getHeight( null);
	int d = w / 5;
	int x = -1;
	int inc = 1;
	int xe = w - d;

	Color bg = getBackground();

	Gr.setColor( bg);
	Gr.fillRect( 0, 0, w, h);

	while ( true ) {

		if ( x >= 0 ) {
			Gr.setColor( bg);
			Gr.fillOval( x, 5, d, d);
		}

		x += inc;

		if ( inc >= 0 ){
			if ( x == xe ) inc *= -1;
		}
		else {
			if ( x == 0 ) inc *= -1;
		}

		Gr.setColor( Color.red);
		Gr.fillOval( x, 5, d, d);
		repaint();

		try { Thread.sleep( 5); } catch ( Exception ex ) {}
	}
}
}
