package biss.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Observable;
import java.util.Observer;

public class Combigo
  extends TopWindow
{
	GraphPane Gp = new GraphPane();
	Label Status = new Label();
	Button BtnNew = new Button( "~New Game");
	Button BtnClose = new Button( "~Close");
	int Moves = 0;
	int Fields[][] = new int[10][10];
	Point Home = new Point( 0, 0);
	Point Sel = new Point(0,0);
	Layouter Lo = new Layouter( this);

public Combigo() {
	super( "Combigo");
	open();
}

void drawField( int x, int y, Rectangle r, Graphics g) {

	int dt = r.width/10;
	int pw = dt/6;
	int yo = y*dt;

	if ( Home.x == x && Home.y == y){
		if ( Home.equals( Sel))
			g.setColor( Color.red);
		else
			g.setColor( Color.white);
		g.fillRect( x*dt+r.x+1, yo+r.y+1, dt-2, dt-2);
		return;
	}

	g.setColor( Color.lightGray);
	g.fillRect( x*dt+r.x+1, yo+r.y+1, dt-2, dt-2);

	g.setColor( Color.black);
	g.drawRect( x*dt+r.x, yo+r.y, dt, dt);

	if ( Sel.x == x && Sel.y == y)
		g.setColor( Color.red);

	switch( Fields[x][y]) {
	case 1:
		g.fillArc( x*dt+dt/2-pw/2+r.x, yo+dt/2-pw/2+r.y, pw, pw, 0, 360);
		break; 
	case 2:
		g.fillArc( x*dt+pw+r.x, yo+pw+r.y, pw, pw, 0, 360);
		g.fillArc( x*dt+dt-2*pw+r.x, yo+dt-2*pw+r.y, pw, pw, 0, 360);
		break;
	case 3:
		g.fillArc( x*dt+pw+r.x, yo+pw+r.y, pw, pw, 0, 360);
		g.fillArc( x*dt+dt/2-pw/2+r.x, yo+dt/2-pw/2+r.y, pw, pw, 0, 360);
		g.fillArc( x*dt+dt-2*pw+r.x, yo+dt-2*pw+r.y, pw, pw, 0, 360);
		break;
	case 4:
		g.fillArc( x*dt+pw+r.x, yo+pw+r.y, pw, pw, 0, 360);
		g.fillArc( x*dt+dt-2*pw+r.x, yo+pw+r.y, pw, pw, 0, 360);
		g.fillArc( x*dt+pw+r.x, yo+dt-2*pw+r.y, pw, pw, 0, 360);
		g.fillArc( x*dt+dt-2*pw+r.x, yo+dt-2*pw+r.y, pw, pw, 0, 360);
		break;
	case 5:
		g.fillArc( x*dt+pw+r.x, yo+pw+r.y, pw, pw, 0, 360);
		g.fillArc( x*dt+dt-2*pw+r.x, yo+pw+r.y, pw, pw, 0, 360);
		g.fillArc( x*dt+dt/2-pw/2+r.x, yo+dt/2-pw/2+r.y, pw, pw, 0, 360);
		g.fillArc( x*dt+pw+r.x, yo+dt-2*pw+r.y, pw, pw, 0, 360);
		g.fillArc( x*dt+dt-2*pw+r.x, yo+dt-2*pw+r.y, pw, pw, 0, 360);
		break;
	case 6: 
		g.fillArc( x*dt+pw+r.x, yo+pw+r.y, pw, pw, 0, 360);
		g.fillArc( x*dt+dt-2*pw+r.x, yo+pw+r.y, pw, pw, 0, 360);
		g.fillArc( x*dt+pw+r.x, yo+dt/2-pw/2+r.y, pw, pw, 0, 360);
		g.fillArc( x*dt+dt-2*pw+r.x,yo+dt/2-pw/2+r.y, pw, pw, 0, 360);
		g.fillArc( x*dt+pw+r.x, yo+dt-2*pw+r.y, pw, pw, 0, 360);
		g.fillArc( x*dt+dt-2*pw+r.x, yo+dt-2*pw+r.y, pw, pw, 0, 360);
		break;
	}
}

void fillFields() {
	for ( int x=0; x<10; x++) {
		for ( int y=0; y<10; y++)
			Fields[x][y]= (int)(Math.random()*6+1);
	}
}

public void init() {
	BtnNew.OsAction.addObserver( this);
	BtnClose.OsAction.addObserver( this);
	Gp.OsDraw.addObserver( this);
	Gp.OsMouseBtn.addObserver( this);

	Status.setBorder( Border.BS_INSET);
	newGame();
}

boolean isValidField( int x, int y){
	int num = Fields[Sel.x][Sel.y];

	//up - down
	if ( x == Sel.x){
		if ( (y == Sel.y-num) || (y == Sel.y+num))
			return true;
	}
	//left - right
	if ( y == Sel.y){
		if ( (x == Sel.x-num) || (x == Sel.x+num))
			return true;
	}
	//diagonal
	if (y == Sel.y+num){
		if ( (x == Sel.x+num) || (x == Sel.x-num) )
			return true;
	}
	if (y == Sel.y-num){
		if ( (x == Sel.x-num) || (x == Sel.x+num) ) 
			return true;
	}

	return false;
}

public static void main (String args[]) {
	Combigo co = new Combigo();
}

/*
  public synchronized void addNotify(){
    super.addNotify();
    Image i = createImage( 50, 50);
    Graphics g = i.getGraphics();
    g.setColor( Color.blue);
    g.fillRect( 0, 0, 50, 50);
    setIconImage( i);
  }
  */
void newGame(){
	fillFields();
	Home.x = (int)(Math.random()*10);
	Home.y = (int)(Math.random()*10);
	Sel.x = (int)(Math.random()*10);
	Sel.y = (int)(Math.random()*10);

	Moves = 0;
	Status.setContents( "Welcome to Combigo !!!");
	Gp.repaint();
}

public void open() {
	Lo.add( Gp,          0,    0, 1000, 1000, true,  0,   0,  0, -400,  0);
	Lo.add( BtnNew,      0, 1000,  500, 1000, true,  0, -400, 0, -200,  0);
	Lo.add( BtnClose,  500, 1000, 1000, 1000, true,  0, -400, 0, -200,  0);
	Lo.add( Status,      0, 1000, 1000, 1000, true,  0, -200, 0,    0,  0);

	init();
	if ( Bounds != null)
		openIn( Bounds);
	else
		openIn( 100, 100, 334, 411);

}

void selectField( Event evt) {

	Graphics g = Gp.getGraphics();
	Rectangle r = Gp.getDrawRect();

	int xs = evt.x / (r.width/10);
	int ys = evt.y / (r.width/10);
	int xp = Sel.x;
	int yp = Sel.y;

	if ( isValidField( xs, ys)){
		Sel.x = xs;
		Sel.y = ys;
		drawField( xp, yp, r, g);
		drawField( Sel.x, Sel.y, r, g);
		if ( Home.equals( Sel))
			Status.setContents( "You did it !!! ( with " + Integer.toString(++Moves) +
		                    " move(s) )");
		else
			Status.setContents( Integer.toString( ++Moves) + " move(s)");
	}
	else
		Status.setContents( "Invalid move !");

	g.dispose();

}

public void update( Observable o, Object arg) {
	if ( o == BtnNew.OsAction )
		newGame();
	else if ( o == BtnClose.OsAction)
		dispose();
	else if ( o == Gp.OsDraw ) {
		Graphics g = (Graphics)(arg);
		Rectangle r = Gp.getDrawRect();
		for ( int x=0; x<10; x++) {
			for ( int y=0; y<10; y++)
				drawField( x, y, r, g);
		}
	}
	else if ( o == Gp.OsMouseBtn ) {
		Event evt = (Event)arg;
		if ( evt.id == Event.MOUSE_DOWN)
			selectField( (Event)(arg));
	}

	super.update( o, arg);
}
}
