package biss.jde;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

/**
 * class to format Java method bodies
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
class MethodFormatter
{
	int N;
	byte In[];
	ByteArrayOutputStream Out;
	int i;
	int k;
	int Level;
	int Tmp;
	int Col[] = new int[10];
	byte IStep[] = { '\t'};

boolean copyComment () throws IOException {
	byte  b, c;
	int   j;

	if ( i<N ) {
		if ( (b = In[i+1]) == '/' ) {
			for ( c=In[i]; c != '\n'; c=In[++i] ) Out.write( c);
			return true;
		}
		else if ( b == '*' ) {
			Out.write( '/'); Out.write( '*');
			for ( i+=2, k+=2; (c=In[i]) == ' ' || c=='\t'; i++,k++)
				Out.write( ' ');

			b = ' ';
			while ( c != '/' || b != '*' ) {
				switch ( c ) {

				case '\r':
					break;

				case '\n':
					Out.write( c);
					for ( i++; (c=In[i]) == ' ' || c == '\t'; i++);
					for ( j=0; j<Level; j++) Out.write( IStep);

					if ( c == '*' )
						Out.write( ' ');
					else
						for ( j=0; j<k; j++ ) Out.write( ' ');

					i--;
					break;

				default: 
					Out.write( c);
				}
				b = c;
				c = In[++i];
			}

			return true;
		}
	}

	return false;
}

void copyLiteral () throws IOException {
	byte c = In[i];
	byte delim=c;

	Out.write( c);
	for ( i++; In[i]!= delim; i++ ){
		Out.write( In[i]);
		if ( In[i] == '\\' )
			Out.write( In[++i]);
	}
	Out.write( In[i]);
}

void eol () throws IOException {
	int j;
	byte c;

	while ( (c = In[i]) == '\n' ) {
		i++;
		Out.write( '\n');

		while ( (c= In[i]) == ' ' || c == '\t' || c == '\r' ) i++;
		if ( c != '\n' ){
			if ( c == '}' ) {
				for ( j=0; j<Level-1; j++ ) Out.write( IStep);
			}
			else if ( (c=='c' && i<N-4 && In[i+1]=='a' && In[i+2]=='s'
			           && In[i+3]=='e' && In[i+4]<'A') ||
			          (c=='d' && i<N-7 && In[i+1]=='e' && In[i+2]=='f'
			 && In[i+3]=='a' && In[i+4]=='u' && In[i+5]== 'l'
			 && In[i+6]=='t' && In[i+7]==':') ) {
				Level--;
				for ( j=0; j<Level; j++ ) Out.write( IStep);
			}
			else {
				for ( j=0; j<Level; j++ ) Out.write( IStep);
				if ( Tmp >= 0 ){
					for ( j=0; j<Col[Tmp]; j++ ) Out.write( ' ');
				}
			}
		}
	}
}

public String format ( String input ) {
	byte c;
	boolean carry = false;

	setInput( input);
	Out = new ByteArrayOutputStream( N+10);

	try {
		skipToNonBlank();
		k=0;

		while ( true ) {
			c = In[i];

			switch ( c ) {
			case '{':   Out.write( c); Level++; carry = false; break;
			case '}':   Out.write( c); Level--; carry = false; break;
			case '(':   
				Out.write( c);
				for ( i++, k++; (c=In[i]) == ' ' || c == '\t'; i++, k++ )
					Out.write( ' ');
				Col[++Tmp] = k; 
				continue;
			case ')':   Out.write( c); Tmp--; carry = true; break;

			case '\r':  break;
			case '\n':  
				if ( carry ) {
					Level++;
					eol();
					Level--;
					carry = false;
				}
				else
					eol();

				k = 0;
				continue;
			case ' ':
			case '\t':  Out.write( c); break;

			case '/':
				if ( copyComment() )
					continue;

				Out.write( c);
				carry = false;
				break;
			case '\'':
			case '"':
				copyLiteral();
				carry = false;
				break;

			case 'c':
				if ( i<N-5 && In[i+1]=='a' && In[i+2]=='s' && In[i+3]=='e'
				     && ! JavaScanner.ANTable[In[i+4]] ){
					Out.write( In, i, 4);
					Level++;
					i+=3; k+=3;
				}
				else {
					Out.write( c); carry = false;
				}
				break;

			case 'd':
				if ( i<N-8 && In[i+1]=='e' && In[i+2]=='f' && In[i+3]=='a'
				     && In[i+4]=='u' && In[i+5]=='l' && In[i+6] == 't' 
				     && !JavaScanner.ANTable[ In[i+7]] ) {
					Out.write( In, i, 7);
					Level++;
					i+=6; k+=6;
				}
				else {
					Out.write( c); carry = false;
				}
				break;

			case 'e':
				if ( i<N-5 && In[i+1]=='l' && In[i+2]=='s' && In[i+3]=='e'
				     && !JavaScanner.ANTable[In[i+4]] ) {
					carry = true;
					Out.write( In, i, 4);
					i +=3; k+=3;
				}
				else {
					Out.write( c); carry = false;
				}
				break;

			default:    Out.write( c ); carry = false;
			}

			i++; k++;
		}
	}

	catch ( ArrayIndexOutOfBoundsException x ) {;}
	catch ( IOException x ) {;}

	return Out.toString();
}

public static void main ( String args[] ) {
	try {
		File f = new File( args[0]);
		int len = (int)f.length();
		byte buf[] = new byte[len];

		FileInputStream in = new FileInputStream( f);
		in.read( buf, 0, len);
		in.close();

		MethodFormatter mf = new MethodFormatter();
		String s = mf.format( new String( buf, 0));
		System.out.println( s);
	}
	catch ( Exception e )  {
		System.out.println( e);
		e.printStackTrace();
	}
}

void setInput ( String s ) {
	i=0;
	k=0;
	Tmp = -1;
	Level = 0;

	N = s.length();
	In = new byte[N];
	s.getBytes( 0, N, In, 0);
}

void skipToNonBlank () {
	for ( ; In[i] <= ' '; i++ );
}
}
