package biss.jde;

import java.util.Enumeration;

/**
 * helper class to asynchronously check the format of 
 * all methods within a CompileUnit
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
class MthdFormatChecker
  implements Runnable
{
	CompileUnit CU;

MthdFormatChecker ( CompileUnit cu ) {
	CU = cu;
}

public void run () {
	ClassDecl cls;
	Method mth;
	MethodFormatter fmt = new MethodFormatter();
	Enumeration e1, e2;

	for ( e1 = (CU.TypeDecls).elements(); e1.hasMoreElements(); ) {
		Object obj = e1.nextElement();
		if ( obj instanceof ClassDecl ){
			cls = (ClassDecl) obj;
			for ( e2 = (cls.Methods).elements(); e2.hasMoreElements(); ) { 
				mth = (Method) e2.nextElement();
				if ( !mth.isPropperlyIndented() )
					mth.setBody( fmt.format( mth.Body));
			}
		}
	}
}
}
