/*
** Copyright (c) Massachusetts Institute of Technology 1994-1998.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@sds.lcs.mit.edu).
*/

typedef enum {
  INF_IMPORTS, INF_USES, 
  INF_EXPORT, INF_PRIVATE
} interfaceNodeKind;

typedef struct _interfaceNode {
  interfaceNodeKind kind; /* which kind of interface node */
  union { 
    /* evs 8 Sept 1993 */
    importNodeList imports;     /* a list of simpleId or TYPEDEF_NAME */
    traitRefNodeList uses;      /* a list of traitRef */
    exportNode export;     
    privateNode private;
  } content; /* can be empty */
  /* the list that made up <interface> is chained thru next */
} *interfaceNode;

extern /*@unused@*/ cstring interfaceNode_unparse (interfaceNode p_x);
extern void interfaceNode_free (/*@null@*/ /*@only@*/ interfaceNode p_x);


