/*
** Copyright (c) Massachusetts Institute of Technology 1994-1998.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@sds.lcs.mit.edu).
*/
/*
** declaratorNodeList.c
**
** based on list_template.c
**
** where T has T_equal (or change this) and T_unparse
*/

# include "lclintMacros.nf"
# include "llbasic.h"

declaratorNodeList
  declaratorNodeList_new ()
{
  declaratorNodeList s = (declaratorNodeList) dmalloc (sizeof (*s));

  s->nelements = 0;
  s->nspace = declaratorNodeListBASESIZE;
  s->elements = (declaratorNode *) 
    dmalloc (sizeof (*s->elements) * declaratorNodeListBASESIZE);

  return (s);
}

static void
declaratorNodeList_grow (declaratorNodeList s)
{
  int i;
  declaratorNode *newelements;

  s->nspace = declaratorNodeListBASESIZE + s->nspace;
  newelements = (declaratorNode *) dmalloc (sizeof (*newelements) * (s->nelements + s->nspace));

  if (newelements == (declaratorNode *) 0)
    {
      llfatalerror (cstring_makeLiteral ("declaratorNodeList_grow: out of memory!"));
    }

  for (i = 0; i < s->nelements; i++)
    {
      newelements[i] = s->elements[i];
    }

  sfree (s->elements); 
  s->elements = newelements;
}

declaratorNodeList 
declaratorNodeList_add (declaratorNodeList s, declaratorNode el)
{
  if (s->nspace <= 0)
    declaratorNodeList_grow (s);

  s->nspace--;
  s->elements[s->nelements] = el;
  s->nelements++;

  return s;
}

/*@only@*/ cstring
declaratorNodeList_unparse (declaratorNodeList s)
{
  cstring st = cstring_undefined;
  bool first = TRUE;

  declaratorNodeList_elements (s, current)
  {
    if (first)
      {
	st = declaratorNode_unparse (current);
	first = FALSE;
      }
    else
      {
	st = message ("%q, %q", st, declaratorNode_unparse (current));
      }
  } end_declaratorNodeList_elements;

  return st;
}

declaratorNodeList
declaratorNodeList_copy (declaratorNodeList s)
{
  declaratorNodeList ret = declaratorNodeList_new ();

  declaratorNodeList_elements (s, el)
    {
      ret = declaratorNodeList_add (ret, declaratorNode_copy (el));
    } end_declaratorNodeList_elements ;

  return ret;
}

void
declaratorNodeList_free (declaratorNodeList s)
{
  int i;
  for (i = 0; i < s->nelements; i++)
    {
      declaratorNode_free (s->elements[i]); 
    }

  sfree (s->elements);
  sfree (s);
}
