/*
** Copyright (c) Massachusetts Institute of Technology 1994-1998.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@sds.lcs.mit.edu).
*/
/*
** pairNodeList.c
**
** based on list_template.c
**
** where T has T_equal (or change this) and T_unparse
*/

# include "lclintMacros.nf"
# include "llbasic.h"

/*@only@*/ pairNodeList
pairNodeList_new ()
{
  pairNodeList s = (pairNodeList) dmalloc (sizeof (*s));
  
  s->nelements = 0;
  s->nspace = pairNodeListBASESIZE;
  s->elements = (pairNode *) 
    dmalloc (sizeof (*s->elements) * pairNodeListBASESIZE);

  return (s);
}

static void
pairNodeList_grow (/*@notnull@*/ pairNodeList s)
{
  int i;
  pairNode *newelements; 

  s->nspace += pairNodeListBASESIZE;
  newelements = (pairNode *) dmalloc (sizeof (*newelements) 
				      * (s->nelements + s->nspace));

  for (i = 0; i < s->nelements; i++)
    {
      newelements[i] = s->elements[i];
    }

  sfree (s->elements); 
  s->elements = newelements;
}

void 
pairNodeList_addh (pairNodeList s, pairNode el)
{
  llassert (pairNodeList_isDefined (s));
  llassert (pairNodeListBASESIZE > 0);

  if (s->nspace <= 0)
    pairNodeList_grow (s);

  s->nspace--;
  s->elements[s->nelements] = el;
  s->nelements++;
}

/*@only@*/ cstring
pairNodeList_unparse (pairNodeList s)
{
  cstring st = cstring_undefined;
  
  if (s != (pairNodeList)0)
    {
      pairNodeList_elements (s, current)
	{
	  if (current != NULL)
	    {
	      st = message ("%q%s %s; ", st, 
			    sort_unparseName (current->sort), 
			    ltoken_getRawString (current->tok));
	    }
	} end_pairNodeList_elements;
    }

  return st;
}

void
pairNodeList_free (/*@only@*/ pairNodeList s)
{
  if (pairNodeList_isDefined (s))
    {
      int i;
      for (i = 0; i < s->nelements; i++)
	{
	  pairNode_free (s->elements[i]); 
	}
      
      sfree (s->elements); 
      sfree (s);
    }
}
