/*
**	funct.c	- 
**
**
** Copyright (c) 1996  Hughes Technologies Pty Ltd
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
**
** This software is provided "as is" without any expressed or implied warranty.
**
** ID = "$Id:"
**
*/


#include <stdio.h>
#include <sys/types.h>
#include <ctype.h>

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <signal.h>
#include <netdb.h>

#include <string.h>
#include <unistd.h>
#include <stdlib.h>

#ifdef WIN32
#  include <winsock.h>
#endif

#include <common/portability.h>
#include "msql_priv.h"
#include "msql.h"


extern  int     outSock;
extern  char    *packet;


typedef struct func_s {
	char	*name;
	int	argType;
	int	(*funct) ();
} func_t;



int	doMin();
int	doMax();
int	doAvg();
int	doCount();


func_t setFuncs[] = {
	{ "min", INT_TYPE | CHAR_TYPE | REAL_TYPE, doMin},
	{ "max", INT_TYPE | CHAR_TYPE | REAL_TYPE, doMax},
	{ "avg", INT_TYPE | REAL_TYPE, doAvg},
	{ "count", ANY_TYPE, doCount},
	{ NULL }
};


int doMin(val)
	val_t	*val;
{
	return(0);
}


int doMax(val)
	val_t	*val;
{
	return(0);
}


int doAvg(val)
	val_t	*val;
{
	return(0);
}


int doCount(val)
	val_t	*val;
{
	return(0);
}


int checkSetFunctName(name)
	char	*name;
{
	func_t	*cur;

	cur = setFuncs;
	while(cur->name)
	{
		if(strcmp(cur->name,name) == 0)
			return(0);
		cur++;
	}
	snprintf(packet,PKT_LEN, "-1:Unknown set function '%s'\n",name);
	writePkt(outSock);
	return(-1);
}
