#!@PERL@
# This test is for testing the speed of connections and sending
# data to the client.
#
# By changing the variable '$opt_loop_count' value you can make this test
# easier/harderto your computer to execute. You can also change this value
# by using option --loop_value='what_ever_you_like'.
##################### Standard benchmark inits ##############################

use DBI;
use Benchmark;

$opt_loop_count=2000;	# Change this to make test harder/easier
$str_length=65000;	# This is the length of blob strings in PART:5
$max_test=100;		# How many times to test if the server is busy

chomp($pwd = `pwd`); $pwd = "." if ($pwd eq '');
require "$pwd/bench-init.pl" || die "Can't read Configuration file: $!\n";

# This is the length of blob strings in PART:5
$str_length=min($limits->{'max_text_size'},$limits->{'query_size'}-30,$str_length);

print "Testing the speed of connecting to the server and sending of data\n";
print "All tests are done $opt_loop_count times\n\n";

################################# PART:1 ###################################
####
####  Start timeing and start connect test..
####

$start_time=new Benchmark;

print "Testing connection/disconnect\n";

$loop_time=new Benchmark;
$errors=0;

for ($i=0 ; $i < $opt_loop_count ; $i++)
{
  for ($j=0; $j < $max_test ; $j++)
  {
    last if ($dbh = DBI->connect($server->{'data_source'}, $opt_user, $opt_password));
    select(undef, undef, undef, 0.001);
    $errors++;
  }
  die $DBI::errstr if ($j == $max_test);
  $dbh->disconnect;
}
$end_time=new Benchmark;
print "Warning: $errors connections didn't work without a time delay\n" if ($errors);
print "Time to connect ($opt_loop_count): " .
  timestr(timediff($end_time, $loop_time),"noc") . "\n\n";

################################# PART:2 ###################################
#### Now we shall do first one connect, then simple select
#### (select 1..) and then close connection. This will be
#### done $opt_loop_count times.

if ($limits->{'select_without_from'})
{
  print "Test connect/simple select/disconnect\n";
  $loop_time=new Benchmark;

  for ($i=0; $i<$opt_loop_count; $i++)
  {
    $dbh = DBI->connect($server->{'data_source'}, $opt_user, $opt_password) || die $DBI::errstr;
    $sth = $dbh->do("select 1") or die $DBI::errstr;
    $dbh->disconnect;
  }
  $end_time=new Benchmark;
  print "Time for select_simple ($opt_loop_count): " .
    timestr(timediff($end_time, $loop_time),"noc") . "\n\n";
}

################################# PART:3 ###################################
####
#### Okay..Next thing we'll do is a simple select $opt_loop_count times.
####

$dbh = DBI->connect($server->{'data_source'}, $opt_user, $opt_password,
		    { PrintError => 0}) || die $DBI::errstr;

if ($limits->{'select_without_from'})
{
  print "Test simple select\n";
  $loop_time=new Benchmark;
  for ($i=0 ; $i<$opt_loop_count ; $i++)
  {
    $sth = $dbh->do("select 1") or die $DBI::errstr;
  }
  $end_time=new Benchmark;
  print "Time for select_simple ($opt_loop_count): " .
    timestr(timediff($end_time, $loop_time),"noc") . "\n\n";
}

################################# PART:4 ###################################
#### First, we'll create a simple table 'bench1'
#### Then we shall do $opt_loop_count selects from this table.
#### Table will contain very simple data.

$sth = $dbh->do("drop table bench1");
do_many($dbh,$server->create("bench1",
			     ["a int NOT NULL",
			      "i int",
			      "s char(10)"],
			     ["primary key (a)"]));
$sth = $dbh->do("insert into bench1 values(1,100,'AAA')") or die $DBI::errstr;

if ($opt_fast && $opt_server eq "pg")
{
  $server->vacuum($dbh);
}
$dbh->disconnect;

#
# First test connect/select/disconnect
#
print "Testing connect/select 1 row from table/disconnect\n";

$loop_time=new Benchmark;
$errors=0;

for ($i=0 ; $i<$opt_loop_count ; $i++)
{
  for ($j=0; $j < $max_test ; $j++)
  {
    last if ($dbh = DBI->connect($server->{'data_source'}, $opt_user, $opt_password));
    $errors++;
  }
  die $DBI::errstr if ($j == $max_test);

  $sth = $dbh->do("select * from bench1") #Select * from table with 1 record
    or die $DBI::errstr;
  $dbh->disconnect;
}

$end_time=new Benchmark;
print "Warning: $errors connections didn't work without a time delay\n" if ($errors);
print "Time to connect+select ($opt_loop_count): " .
  timestr(timediff($end_time, $loop_time),"noc") . "\n\n";

#
# The same test, but without connect/disconnect
#
print "Testing select 1 row from table\n";

$dbh = DBI->connect($server->{'data_source'}, $opt_user, $opt_password,
		    { PrintError => 0}) || die $DBI::errstr;
$loop_time=new Benchmark;

for ($i=0 ; $i<$opt_loop_count ; $i++)
{
  $sth = $dbh->do("select * from bench1") # Select * from table with 1 record
    or die $DBI::errstr;
}

$end_time=new Benchmark;
print "Time to select ($opt_loop_count): " .
  timestr(timediff($end_time, $loop_time),"noc") . "\n\n";

#
# The same test, but with 2 rows.
#
print "Testing select 2 rows from table\n";

$sth = $dbh->do("insert into bench1 values(2,200,'BBB')")
  or die $DBI::errstr;

$loop_time=new Benchmark;

for ($i=0 ; $i<$opt_loop_count ; $i++)
{
  $sth = $dbh->do("select * from bench1") # Select * from table with 2 record
    or die $DBI::errstr;
}

$end_time=new Benchmark;
print "Time to select ($opt_loop_count): " .
  timestr(timediff($end_time, $loop_time),"noc") . "\n\n";

$sth = $dbh->do("drop table bench1")
  or die $DBI::errstr;

if ($opt_fast && $opt_server eq "pg")
{
  $server->vacuum($dbh);
}

################################# PART:5 ###################################
#### We'll create one table with a single blob field,but with a
#### huge record in it and then we'll do $opt_loop_count selects
#### from it.

print "Testing retrieval of big records ($str_length bytes)\n";

do_many($dbh,$server->create("bench1", ["b blob"], []));
$dbh->{LongReadLen}= $str_length; # Set retrieval buffer

$string=(A) x ($str_length); # This will make a string $str_length bytes long..
$sth = $dbh->prepare("insert into bench1 values(?)") or die $dbh->errstr;
$sth->execute($string) or die $sth->errstr;

if ($opt_fast && $opt_server eq "pg")
{
  $server->vacuum($dbh);
}

$loop_time=new Benchmark;

for ($i=0 ; $i < $opt_loop_count ; $i++)
{
  $sth = $dbh->prepare("select * from bench1");
  if (!$sth->execute || !(@row = $sth->fetchrow_array) ||
      length($row[0]) != $str_length)
  {
    warn "$DBI::errstr - ".length($row[0])." - $str_length **\n";
  }
  $sth->finish;
}

$end_time=new Benchmark;
print "Time to select_big ($opt_loop_count): " .
  timestr(timediff($end_time, $loop_time),"noc") . "\n\n";

$sth = $dbh->do("drop table bench1")
  or do {
	if (not $dbh->errstr =~ /non-exclusive access/)
		{ die $dbh->errstr; }
	};

if ($opt_fast && $opt_server eq "pg")
{
  $server->vacuum($dbh);
}


################################ END ###################################
####
#### End of the test...Finally print time used to execute the
#### whole test.

$dbh->disconnect;
end_benchmark($start_time);
