/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB

   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.

   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.	The License grants you the right to
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

/* Delete of records */

#include "mysql_priv.h"

/*
** delete records in table
** If where clause is empty and there are no locks on the table,
** then recreate table from .frm file;  When we have TABLE locks instead
** if NISAM locks, we can always recreate the table.
*/

int mysql_delete(THD *thd,TABLE_LIST *table_list,COND *conds)
{
  int		error;
  TABLE		*table;
  SQL_SELECT	*select;
  READ_RECORD	info;
  DBUG_ENTER("mysql_delete");

  if (!table_list->db)
    table_list->db=thd->db;
  if (!conds && !thd->open_tables)
  {
    // Optimize delete of all rows by doing a full generate of the table
    // This will work even if the .ISM and .ISD tables are destroyed

    char path[FN_REFLEN];
    (void) sprintf(path,"%s/%s/%s%s",mysql_data_home,table_list->db,
		   table_list->real_name,reg_ext);

    VOID(pthread_mutex_lock(&LOCK_open));
    if (!remove_table_from_cache(table_list->db,table_list->real_name))
    {
      /* Table is not in use, we can safely re-generate it */
      int error=cre_database(path);
      VOID(pthread_mutex_unlock(&LOCK_open));
      if (!error)
      {
	send_ok(&thd->net);		// This should return record count
	mysql_update_log.write(thd->query);
      }
      DBUG_RETURN(error ? -1 : 0);
    }
    VOID(pthread_mutex_unlock(&LOCK_open));
    /* Table in use; Do it the long way */
  }

  if (!(table = open_ltable(thd,table_list,1)))
    DBUG_RETURN(-1);
  table->map=1;
  if (setup_conds(thd,table_list,conds))
    DBUG_RETURN(-1);

  select=make_select(&table,1,0,1,conds,&error);
  if (error)
    DBUG_RETURN(-1);
  if (select && select->check_quick())
  {
    delete select;
    send_ok(&thd->net,0L);
    DBUG_RETURN(0);
  }

  VOID(ha_extra(table,HA_EXTRA_NO_READCHECK));
  init_read_record(&info,table,select);
  ulong deleted=0L;
  while ((error=info.read_record(&info)) <= 0 && !thd->killed)
  {
    if (error == 0 && !(select && select->skipp_record()))
    {
      if (!(error=ha_delete(table,table->record[0])))
	deleted++;
      else
      {
	ha_error(table,error,MYF(0));
	error=0;
	break;
      }
    }
  }
  end_read_record(&info);
  VOID(ha_extra(table,HA_EXTRA_READCHECK));
  if (deleted)
    mysql_update_log.write(thd->query);
  if (thd->lock)
  {
    mysql_unlock_tables(thd->lock);
    thd->lock=0;
  }
  delete select;
  if (error <= 0)
    send_error(&thd->net,thd->killed ? ER_SERVER_SHUTDOWN: 0);
  else
  {
    send_ok(&thd->net,deleted);
    DBUG_PRINT("info",("%d records deleted",deleted));
  }
  DBUG_RETURN(0);
}
