/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */
/* This file is originally from the mysql distribution. Coded by monty */

#ifdef __GNUC__
#pragma implementation				// gcc: Class implementation
#endif

#include <global.h>
#include <my_sys.h>
#include <m_string.h>
#include <m_ctype.h>
#ifdef HAVE_FCONVERT
#include <floatingpoint.h>
#endif

extern gptr sql_alloc(unsigned size);
extern void sql_element_free(void *ptr);

#include "sql_string.h"

/*****************************************************************************
** String functions
*****************************************************************************/

bool String::real_alloc(uint length)
{
  length=ALIGN_SIZE(length+1);
  if (Alloced_length < length)
  {
    free();
    if (!(Ptr=my_malloc(length,MYF(MY_WME))))
    {
      str_length=0;
      return TRUE;
    }
    Alloced_length=length;
    alloced=1;
  }
  Ptr[0]=0;
  str_length=0;
  return FALSE;
}


/*
** Check that string is big enough. Set string[alloc_length] to 0
** (for C functions)
*/

bool String::realloc(uint alloc_length)
{
  uint length=ALIGN_SIZE(alloc_length+1);
  if (Alloced_length < length)
  {
    char *new_ptr;
    if (alloced)
    {
      if ((new_ptr= (char*) my_realloc(Ptr,length,MYF(MY_WME))))
      {
	Ptr=new_ptr;
	Alloced_length=length;
      }
      else
	return TRUE;				// Signal error
    }
    else if ((new_ptr= (char*) my_malloc(length,MYF(MY_WME))))
    {
      memcpy(new_ptr,Ptr,str_length);
      new_ptr[str_length]=0;
      Ptr=new_ptr;
      Alloced_length=length;
      alloced=1;
    }
    else
      return TRUE;			// Signal error
  }
  Ptr[alloc_length]=0;			// This make other funcs shorter
  return FALSE;
}


#ifdef NOT_NEEDED
void String::set(long num)
{
  if (!alloc(14))
    str_length=(uint) (int2str(num,Ptr,-10)-Ptr);
}
#endif

void String::set(longlong num)
{
  if (!alloc(21))
    str_length=(uint) (longlong2str(num,Ptr,-10)-Ptr);
}

void String::set(double num,uint decimals)
{
#ifdef HAVE_FCONVERT
  char buff[330],*pos,*to;
  int decpt,sign;

  VOID(fconvert(num,(int) decimals,&decpt,&sign,buff));
  if (alloc((uint) ((uint) decpt+test(sign)+2+decimals)))
    return;
  to=Ptr;
  if (sign)
    *to++='-';

  pos=buff;
  if (decpt < 0)
  {					/* value is < 0 */
    *to++='0';
    if (!decimals)
      goto end;
    *to++='.';
    if ((uint) -decpt > decimals)
      decpt= - (int) decimals;
    decimals=(uint) ((int) decimals+decpt);
    while (decpt++ < 0)
      *to++='0';
  }
  else if (decpt == 0)
  {
    *to++= '0';
    if (!decimals)
      goto end;
    *to++='.';
  }
  else
  {
    while (decpt-- > 0)
      *to++= *pos++;
    if (!decimals)
      goto end;
    *to++='.';
  }
  while (decimals--)
    *to++= *pos++;

end:
  *to=0;
  str_length=(uint) (to-Ptr);
#else
  char buff[330];
  sprintf(buff,"%.*lf",decimals,num);
  copy(buff,strlen(buff));
#endif
}


void String::copy()
{
  if (!alloced)
  {
    Alloced_length=0;				// Force realloc
    (void) realloc(str_length);
  }
}

void String::copy(const String &str)
{
  if (!alloc(str.str_length))
  {
    str_length=str.str_length;
    bmove(Ptr,str.Ptr,str_length);		// May be overlapping
    Ptr[str_length]=0;
  }
}

void String::copy(const char *str,uint length)
{
  if (!alloc(length))
  {
    str_length=length;
    memcpy(Ptr,str,length);
    Ptr[length]=0;
  }
}

/* This is used by mysql.cc */

void String::fill(uint max_length,char fill)
{
  if (str_length > max_length)
    Ptr[str_length=max_length]=0;
  else
  {
    if (!realloc(max_length))
    {
      bfill(Ptr+str_length,max_length-str_length,fill);
      str_length=max_length;
    }
  }
}

void String::strip_sp()
{
   while (str_length && isspace(Ptr[str_length-1]))
    str_length--;
}

void String::append(const String &s)
{
  if (!realloc(str_length+s.length()))
  {
    memcpy(Ptr+str_length,s.ptr(),s.length());
    str_length+=s.length();
  }
}

void String::append(const char *s,uint length)
{
  if (!length)
    length=strlen(s);
  if (!realloc(str_length+length))
  {
    memcpy(Ptr+str_length,s,length);
    str_length+=length;
  }
}


int String::strstr(const String &s,uint offset)
{
  if (s.length()+offset <= str_length)
  {
    if (!s.length())
      return offset;				// Empty string is always found

    register const char *str = Ptr+offset;
    register const char *search=s.ptr();
    const char *end=Ptr+str_length-s.length()+1;
    const char *search_end=s.ptr()+s.length();
skipp:
    while (str != end)
    {
      if (*str++ == *search)
      {
	register char *i,*j;
	i=(char*) str; j=(char*) search+1;
	while (j != search_end)
	  if (*i++ != *j++) goto skipp;
	return (int) (str-Ptr) -1;
      }
    }
  }
  return -1;
}


/*
** Search string from end. Offset is offset to the end of string
*/

int String::strrstr(const String &s,uint offset)
{
  if (s.length() <= offset && offset <= str_length)
  {
    if (!s.length())
      return offset;				// Empty string is always found
    register const char *str = Ptr+offset-1;
    register const char *search=s.ptr()+s.length()-1;

    const char *end=Ptr+s.length()-1;
    const char *search_end=s.ptr()-1;
skipp:
    while (str != end)
    {
      if (*str-- == *search)
      {
	register char *i,*j;
	i=(char*) str; j=(char*) search-1;
	while (j != search_end)
	  if (*i-- != *j--) goto skipp;
	return (int) (i-Ptr) +1;
      }
    }
  }
  return -1;
}

/*
** replace substring with string
** If wrong parameter or not enough memory, do nothing
*/


void String::replace(uint offset,uint length,const String &to)
{
  int diff = (int) (to.length()-length);
  if (offset+length <= str_length &&
      (diff <= 0 || !realloc(str_length+(uint) diff)))
  {
    if (diff < 0)
    {
      memcpy(Ptr+offset,to.ptr(),to.length());
      bmove(Ptr+offset+to.length(),Ptr+offset+length,
	    str_length-offset-length);
    }
    else
    {
      if (diff)
	bmove_upp(Ptr+str_length+diff,Ptr+str_length,
		  str_length-offset-length);
      memcpy(Ptr+offset,to.ptr(),to.length());
    }
    str_length+=(uint) diff;
  }
}


int sortcmp(const String *x,const String *y)
{
  const char *s= x->ptr();
  const char *t= y->ptr();
  uint x_len=x->length(),y_len=y->length(),len=min(x_len,y_len);

#ifdef USE_STRCOLL
  return my_strnncoll((unsigned char *)s,x_len,(unsigned char *)t,y_len);
#else
  while (len--)
  {
    if (my_sort_order[(uchar) *s++] != my_sort_order[(uchar) *t++])
      return ((int) my_sort_order[(uchar) s[-1]] -
	      (int) my_sort_order[(uchar) t[-1]]);
  }
  return (int) (x_len-y_len);
#endif
}


int stringcmp(const String *x,const String *y)
{
  const char *s= x->ptr();
  const char *t= y->ptr();
  uint x_len=x->length(),y_len=y->length(),len=min(x_len,y_len);

  while (len--)
  {
    if (*s++ != *t++)
      return ((int) (uchar) s[-1] - (int) (uchar) t[-1]);
  }
  return (int) (x_len-y_len);
}


String *copy_if_not_alloced(String *to,String *from,uint length)
{
  if (from->Alloced_length >= length)
    return from;
  if (from->alloced || !to || from == to)
  {
    (void) from->realloc(length);
    return from;
  }
  if (to->realloc(length))
    return from;				// Actually an error
  to->str_length=min(from->str_length,length);
  memcpy(to->Ptr,from->Ptr,to->str_length);
  return to;
}


static int wild_case_compare(const char *str,const char *strend,
			     const char *wildstr,const char *wildend)
{
  while (wildstr != wildend)
  {
    while (*wildstr != wild_many && *wildstr != wild_one)
    {
      if (*wildstr == wild_prefix && wildstr+1 != wildend)
	wildstr++;
#ifdef USE_BIG5CODE
      if (wildstr+1 != wildend && isbig5code(*wildstr,*(wildstr+1)))
      {
	if (*str != *wildstr || str+1 == strend || str[1] != wildstr[1])
	  return (1);
	str+=2;
	wildstr+=2;
      }
      else
#endif
#ifdef USE_MB
      int l;
      if ((l = ismbchar(wildstr, wildend))) {
	  if (str+l-1 >= strend || memcmp(str, wildstr, l) != 0)
	      return 1;
	  str += l;
	  wildstr += l;
      } else
#endif
      if (str == strend || toupper(*wildstr++) != toupper(*str++))
	return(1);
      if (wildstr == wildend)
	return (str != strend);			// Match if both are at end
    }
    if (*wildstr++ == wild_one)
    {
      if (str++ == strend)			// Skipp one char if possible
	return (1);
#ifdef USE_BIG5CODE
      if (str != strend && isbig5code(*(str-1),*str))
	str++;
#endif
#ifdef USE_MB
      int l;
      if ((l = ismbchar(str-1, strend)))
	  str += l-1;
#endif
    }
    else
    {						// Found wild_many
      while (*wildstr == wild_many && wildstr != wildend)
	wildstr++;
      if (wildstr == wildend)
	return(0);				// Ok if wild_many is last
      if (*wildstr == wild_one)
      {						// % followed by _
	for ( ; str != strend ; str++)
	{
	  if (wild_case_compare(str,strend,wildstr,wildend) == 0)
	    return (0);
	}
	return 1;
      }
      if (str == strend)
	return 1;

      char cmp;
      if ((cmp= *wildstr) == wild_prefix && wildstr+1 != wildend)
	cmp= *++wildstr;
      wildstr++;				// This is compared trough cmp
#ifdef USE_BIG5CODE
      bool cmp_is_code=wildstr+1 != wildend && isbig5code(cmp,*(wildstr));
      if (cmp_is_code)
	wildstr++;
#else
#ifdef USE_MB
      int mblen = ismbchar(wildstr-1, wildend);
      if (mblen)
	  wildstr += mblen-1;
#else
      cmp=toupper(cmp);
#endif
#endif
      do
      {
#ifdef USE_BIG5CODE
	for (;;)
	{
	  if (cmp_is_code)
	  {
	    if (*str == cmp && str+1 != strend && str[1] == wildstr[-1])
	    {
	      str+=2;				// Point at char after cmp
	      break;
	    }
	    else if (str+1 != strend && isbig5code(*str,*(str+1)))
	      str++;
	  }
	  else if (str+1 != strend && isbig5code(*str,*(str+1)) && *str != cmp)
	    str++;				// Skip extra shar
	  else if (toupper(*str) == toupper(cmp))
	  {
	    str++;
	    break;				// Found it
	  }
	  if (str++ == strend) return (1);
	}
#else
#ifdef USE_MB
	for (;;) {
	    int l;
	    if (mblen) {
		if (str+mblen <= strend && memcmp(str, wildstr-mblen, mblen) == 0) {
		    str += mblen;
		    break;
		} else if ((l = ismbchar(str, strend)))
		    str += l-1;
	    } else if ((l = ismbchar(str, strend)))
		str += l-1;
	    else if (toupper(*str) == toupper(cmp)) {
		str++;
		break;
	    }
	    if (str++ == strend) return 1;
	}
#else
	while (str != strend && toupper(*str) != cmp)
	  str++;
	if (str++ == strend) return (1);
#endif
#endif
	if (wild_case_compare(str,strend,wildstr,wildend) == 0)
	  return (0);
      } while (str != strend);
      return(1);
    }
  }
  return (str != strend);
}


int wild_case_compare(String &match,String &wild)
{
  return wild_case_compare(match.ptr(),match.ptr()+match.length(),
			   wild.ptr(), wild.ptr()+wild.length());
}
