/*
  Optimizer
  Misc C++ file
*/

/*
 *  Copyright (C) 1997,1998  Jesper Pedersen <jews@imada.ou.dk>
 *  This code is released under GNU GPL version 2 or later
 */

#include <stdio.h>
#include <iostream.h>
#include <string.h>
#include "Global.h"
#include "Holder.h"
#include "Entry.h"
#include "IdEntry.h"

//
//	Method name : alloc_error
//
//	Description : Memory allocation error
//	Input : ---
//	Output : ---
//
void alloc_error(void) {
  cout << "Optimizer: MEMORY ALLOCATION ERROR !\n";
  exit(1);
}


//
//	Method name : strdel
//
//	Description : Deletes a substring and inserts another instead
//	Input : Src string, Del substring, Ins substring
//	Output : ---
//
void strdel(char **s1,char *s2, char *s3) {
  unsigned int length,src,dest;
  unsigned int newsrc,newdest;
  bool cont;
  char *newstr;

  length = strlen((*s1)) - strlen(s2) + strlen(s3) + 1;
  newstr = new char[length];
  if (!newstr) alloc_error();
  strcpy(newstr,"");
  if (strstr((*s1),s2) != NULL) {
    cont = true;
    dest = 0;
    src = 0;

    while (cont == true) {
      while ((*s1)[src] != s2[dest]) {
	newstr[src] = (*s1)[src];
	src++;
      }
      cont = false;

      length = 1;
      newsrc = src; 
      newdest = dest;
      while ((length <= strlen(s2)-1)&&(cont != true)) {
	newsrc++; newdest++;
	if ((*s1)[newsrc] != s2[newdest]) {
	  cont = true;
	}
	length++;
      }

      if (cont == true) {
	newstr[src] = (*s1)[src];
	src++;
      }
    }

    newstr[src] = '\0';
    strcat(newstr,s3);
    dest = src;
    src += strlen(s3);
    dest += strlen(s2);
    while ((*s1)[dest] != '\0'){
      newstr[src] = (*s1)[dest];
      src++; dest++;
    }
    newstr[src] = '\0';
    strcpy((*s1),newstr);
  }
  delete[] newstr;
}

//
//	Method name : strdel (OVERLOADED)
//
//	Description : Deletes a substring in s1
//	Input : Src string, From
//	Output : ---
//
void strdel(char **s1,unsigned int from) {
  unsigned int src;
  char *tmpstr = new char[MaxSize];

  if (!tmpstr) alloc_error();
  strcpy(tmpstr,"");

  src = 0;
  if (from > 0) {
    while (src < from) {
      tmpstr[src] = (*s1)[src];
      src++;
    }
  }
  tmpstr[src] = '\0';

  strcpy((*s1),tmpstr);

  delete[] tmpstr;
}

//
//	Method name : chkreg
//
//	Description : Returns true if s contains a register 
//	Input : Input string
//	Output : TRUE if found else FALSE
//
bool chkreg(char *s) {
      if (strstr(s,"%eax") != NULL) {           // EAX
	return true;
      } else if (strstr(s,"%ebx") != NULL) {    // EBX
        return true;
      } else if (strstr(s,"%ecx") != NULL) {    // ECX
        return true;
      } else if (strstr(s,"%edx") != NULL) {    // EDX
        return true;
      } else if (strstr(s,"%edi") != NULL) {    // EDI
        return true;
      } else if (strstr(s,"%esi") != NULL) {    // ESI
        return true;
      } else if (strstr(s,"%ebp") != NULL) {    // EBP
        return true;
      } else if (strstr(s,"%esp") != NULL) {    // ESP
        return true;
      } else if (strstr(s,"%ax") != NULL) {     // AX
        return true;
      } else if (strstr(s,"%bx") != NULL) {     // BX
        return true;
      } else if (strstr(s,"%cx") != NULL) {     // CX
        return true;
      } else if (strstr(s,"%dx") != NULL) {     // DX
        return true;
      } else if (strstr(s,"%sp") != NULL) {     // SP
        return true;
      } else if (strstr(s,"%bp") != NULL) {     // BP
        return true;
      } else if (strstr(s,"%si") != NULL) {     // SI
        return true;
      } else if (strstr(s,"%di") != NULL) {     // DI
        return true;
      } else if (strstr(s,"%al") != NULL) {     // AL
        return true;
      } else if (strstr(s,"%bl") != NULL) {     // BL
        return true;
      } else if (strstr(s,"%cl") != NULL) {     // CL
        return true;
      } else if (strstr(s,"%dl") != NULL) {     // DL
        return true;
      } else if (strstr(s,"%ah") != NULL) {     // AH
        return true;
      } else if (strstr(s,"%bh") != NULL) {     // BH
        return true;
      } else if (strstr(s,"%ch") != NULL) {     // CH
        return true;
      } else if (strstr(s,"%dh") != NULL) {     // DH
        return true;
      } else if (strstr(s,"%es") != NULL) {     // ES
        return true;
      } else if (strstr(s,"%cs") != NULL) {     // CS
        return true;
      } else if (strstr(s,"%ss") != NULL) {     // SS
        return true;
      } else if (strstr(s,"%ds") != NULL) {     // DS
        return true;
      } else if (strstr(s,"%fs") != NULL) {     // FS
        return true;
      } else if (strstr(s,"%gs") != NULL) {     // GS
        return true;
      } else if (strstr(s,"%cr") != NULL) {     // CR0->CR4
        return true;
      } else if (strstr(s,"%db") != NULL) {     // DB0->DB7
        return true;
      } else if (strstr(s,"%dr") != NULL) {     // DR0->DR7
        return true;
      } else if (strstr(s,"%tr") != NULL) {     // TR3->TR7
        return true;
      } else if (strstr(s,"%st") != NULL) {     // ST0->ST7
        return true;
      } else if (strstr(s,"%mm") != NULL) {     // MM0->MM7
        return true;
      } else {
        return false;
      }
}

//
//	Method name : isReg
//
//	Description : Returns which register that is in string
//	Input : Input string
//	Output : The number
//
unsigned int isReg(char *s) {
      if (!strcmp(s,"%eax")) {           // EAX
	return REG32;
      } else if (!strcmp(s,"%ebx")) {    // EBX
        return REG32;
      } else if (!strcmp(s,"%ecx")) {    // ECX
        return REG32;
      } else if (!strcmp(s,"%edx")) {    // EDX
        return REG32;
      } else if (!strcmp(s,"%edi")) {    // EDI
        return REG32;
      } else if (!strcmp(s,"%esi")) {    // ESI
        return REG32;
      } else if (!strcmp(s,"%ebp")) {    // EBP
        return REG32;
      } else if (!strcmp(s,"%esp")) {    // ESP
        return REG32;
      } else if (!strcmp(s,"%ax")) {     // AX
        return REG16;
      } else if (!strcmp(s,"%bx")) {     // BX
        return REG16;
      } else if (!strcmp(s,"%cx")) {     // CX
        return REG16;
      } else if (!strcmp(s,"%dx")) {     // DX
        return REG16;
      } else if (!strcmp(s,"%sp")) {     // SP
        return REG16;
      } else if (!strcmp(s,"%bp")) {     // BP
        return REG16;
      } else if (!strcmp(s,"%si")) {     // SI
        return REG16;
      } else if (!strcmp(s,"%di")) {     // DI
        return REG16;
      } else if (!strcmp(s,"%al")) {     // AL
        return REG8;
      } else if (!strcmp(s,"%bl")) {     // BL
        return REG8;
      } else if (!strcmp(s,"%cl")) {     // CL
        return REG8;
      } else if (!strcmp(s,"%dl")) {     // DL
        return REG8;
      } else if (!strcmp(s,"%ah")) {     // AH
        return REG8;
      } else if (!strcmp(s,"%bh")) {     // BH
        return REG8;
      } else if (!strcmp(s,"%ch")) {     // CH
        return REG8;
      } else if (!strcmp(s,"%dh")) {     // DH
        return REG8;
      } else if (!strcmp(s,"%es")) {     // ES
        return REG8;
      } else if (!strcmp(s,"%cs")) {     // CS
        return REG8;
      } else if (!strcmp(s,"%ss")) {     // SS
        return REG8;
      } else if (!strcmp(s,"%ds")) {     // DS
        return REG8;
      } else if (!strcmp(s,"%fs")) {     // FS
        return REG8;
      } else if (!strcmp(s,"%gs")) {     // GS
        return REG8;
      } else if (!strncmp(s,"%cr",3)) {     // CR0->CR4
        return SREG;
      } else if (!strncmp(s,"%db",3)) {     // DB0->DB7
        return SREG;
      } else if (!strncmp(s,"%dr",3)) {     // DR0->DR7
        return SREG;
      } else if (!strncmp(s,"%tr",3)) {     // TR3->TR7
        return SREG;
      } else if (!strncmp(s,"%st",3)) {     // ST0->ST7
        return FREG;
      } else if (!strncmp(s,"%mm",3)) {     // MM0->MM7
        return MMXREG;
      } else {
        return NOREG;
      }
}

//
//	Method name : chknum
//
//	Description : Returns true if s contains a number
//	Input : Input string
//	Output : TRUE if found else FALSE
//
bool chknum(char *s) {
  unsigned int index = 0;

  if (strcmp(s,"")) {
    if (s[index] == '$') {
      index++;
      if (s[index] == '-') {
	index++;
      }
      while (s[index] != '\0') {
	if ((s[index] < '0')||(s[index] > '9')) {
	  return false;
	}
	index++;
      }
      return true;
    } else if (s[index] == '-') {
      index++;
      while (s[index] != '\0') {
	if ((s[index] < '0')||(s[index] > '9')) {
	  return false;
	}
	index++;
      }
      return true;
    } else if ((s[index] == '0')&&(s[index+1] == 'x')) {
      index += 2;
      while (s[index] != '\0') {
	if ((s[index] < '0')||(s[index] > '9')) {
	  if ((s[index] < 'a')||(s[index] > 'f')) {
	    return false;
	  }
	}
	index++;
      }
      return true;
    } else if ((s[index] >= '0')&&(s[index] <= '9')) {
      index++;
      while (s[index] != '\0') {
	if ((s[index] < '0')||(s[index] > '9')) {
	  return false;
	}
	index++;
      }
      return true;
    } else {
      return false;
    }
  } else {
    return false;
  }
}


//
//	Method name : findnum
//
//	Description : Returns the index to the number else -1
//	Input : Input string
//	Output : -1 or index
//
int findnum(char *s) {
  unsigned int retval;

  if ((strstr(s,"-") != NULL)||(strstr(s,"+") != NULL)){
    retval = 0;
    while ((s[retval] != '-')&&(s[retval] != '+')) {
      retval++;
    }
    return retval;
  } else {
    return -1;
  }
}

//
//	Method name : cleanreg
//
//	Description : Cleans the reg-name for "(" and ")"
//	Input : Input string
//	Output : Input string without the "(" and ")"
//
char *cleanreg(char *s) {
  char *tmpstr = new char[MaxSize];

  strcpy(tmpstr,s);
  if ((s[4] >= '0')&&(s[4] <= '7')) {
    strdel(&tmpstr,"(","");
    strdel(&tmpstr,")","");
    if (strlen(tmpstr) == 3) {
      strcat(tmpstr,"0");
    }
  } else if ((!strcmp(s,"%st"))||(!strcmp(s,"%mm"))) {
    strcat(tmpstr,"0");
  }
  return tmpstr;
}

//
//	Method name : isLocalLabel
//
//	Description : Returns true if its local label
//	Input : Input string
//	Output : TRUE if local label else FALSE
//
bool isLocalLabel(char *s) {
  unsigned int i;;

  if (!strncmp(s,".L",2)) {
    i = 2;
    while (s[i] != '\0') {
      if ((s[i] < '0')||(s[i] > '9')) {
	return false;
      }
      i++;
    }
    return true;
  }
  if (!strncmp(s,".Lfe",4)) {
    i = 4;
    while (s[i] != '\0') {
      if ((s[i] < '0')||(s[i] > '9')) {
	return false;
      }
      i++;
    }
    return true;
  }
  return false;
}
