#include "cthugha.h"
#include "action.h"
#include "sound.h"
#include "display.h"
#include "translate.h"
#include "options.h"
#include "information.h"
#include "cd_player.h"
#include "interface.h"
#include "server.h"
#include "waves.h"

#include <string.h>
#include <stdlib.h>


int action_lock=0;				/* change automatically */
int change_little=0;				/* only change one options */

char silence_strings[MAX_SILENCE_STRINGS][256] = {/* Display when no sound */
/*   1234567890123456789012345678901234567890	*/
    "Where is the music?",	/* 0 */
    "JOLT !",			/* 1 */	
    "Turn The Music On",	/* 2 */	
    "Lets Party!!!",		/* 3 */	
    "Pink Floyd Rules",		/* 4 */	
    "Sounds of Silence ?",	/* 5 */	
    "The Torps",		/* 6 */	
    "Study Mathematics",	/* 7 */	
    "Visit Linz",		/* 8 */	
    "Press ? for help",		/* 9 */	
    "Number 5 is ALIVE!!",	/* 10 */	
    "Spooky Mulder.....",	/* 11 */	
    "Wheres Cthugha 6.0?",	/* 12 */	
    "Subliminal Ads",		/* 13 */	
    "Read a book",		/* 14 */	
    "Get a life...",		/* 15 */	
    "SMILE!",			/* 16 */	
    "Cthugha-L",		/* 17 */	
    "Don't Panic!",		/* 18 */	
    "@fortune"			/* 19 */
};
int nr_silence_strings = 20;



int change_lock(int to) {
    action_lock = val_change( to, 0, 1, action_lock);
    return 0;
}

/*
 * change everything 
 */
int general_change() {
    int i;

    new_state();
	
    if(change_little) {
	change( rand() % f_MAX, CHANGE_RANDOM, 0);

    } else {
	for(i=0; i < f_MAX; i++)
	    change( i, CHANGE_RANDOM, 0);
    }

    return 0;
}

/*
 * The Main-display-Funktion
 */
double fps = 0;
int display_sound() {
    int change;
    int i;

    /* compute frames/second, of at least 3 frames or 0.1 second */
    i = gettime() - display_start;
    if( (i > 10) && (display_frames > 2) )
	fps = 100.0 * ((double)display_frames) / ((double)i);

    /* accept requests from clients */
    if(server)
	server_accept();

    /* set border to black */
    for(i=0; i < 3; i++) {
	memset(active_buffer_rgb[i]+BUFF_SIZE,   0, 3*BUFF_WIDTH);
	memset(active_buffer_rgb[i]-3*BUFF_WIDTH,0, 3*BUFF_WIDTH);
    }
    done_translation = 0;
    
    do_flame();				/* flame (primary transformation) */
    translate();			/* secondard transformation */
    get_sound();			/* Get the next sound into memory */
    change = sound_noise_check();
    if(server)				/* send to clients */
	broadcast_sound();
    flashlight();
    FFT();
    massage_audio();
    display_wave();			/* Bring the sound to buffer */
	
    if ( (change == 1) && !action_lock) {	/* want change and not locked*/
	if ( general_change() ||		/* new wave, flame, ... */
	    ((display_use_pcx) && (pcx_count -- <= 0)) ) {
	    show_pcx(rand() % 2, rand() % 3);
	    pcx_count = rand() % 5;
	}
    }

    if ( (change == -1) && !display_text_on_screen) {		/* silence */
	int print_nr = rand() % nr_silence_strings;

	if ( silence_strings[ print_nr][0] != '@' ) {
	    /* traditional string */
	    display_print( silence_strings[ print_nr ], -1, 'c', 1, TEXT_COLOR_NORMAL); 
	} else {
	    /* print fortune */
	    FILE * msgPipe;

	    if ( (msgPipe = popen("fortune","r")) == NULL) {
		display_print( "Can not open fortune pipe", -1, 'c', 1, TEXT_COLOR_ERROR);
	    } else {
		char str[MAX_TEXT_LINES*255];
		str[ fread( str, 1, MAX_TEXT_LINES*255, msgPipe) ] = '\0';
		display_print(str, -1,'c', 1, TEXT_COLOR_NORMAL);
		pclose(msgPipe);
	    }
	}
    }

    smooth_setpalette();		/* smooth pal. to next */
    display();				/* bring the active_buffer to screen */

#if USE_CDROM == 1
    cd_check();				/* check for complete rotation of CD */
#endif
    return 0;
}










