/*
    CTHUGHA-L 							cthugha.h
	
    General definitions for everyone.
*/

#ifndef __CTHUGHA_H__
#define __CTHUGHA_H__

#define CTHUGHA_VERSION			90

#undef DEBUG 

#include "config.h"

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>

extern int cthugha_verbose;
extern int cthugha_close;
extern int cthugha_pause;
char * cthugha_mode_text();

int cth_init(int * argc, char * argv[]);
int cth_main();

#define printfv(lvl, args...) {						\
   if(lvl <= cthugha_verbose) {						\
       printf( ## args);						\
       fflush(stdout);							\
   }									\
}
/* The SPACE after %s\n" is important !!! */
#define printfee(fmt, args...)	{					  \
   printf("\n"); fflush(stdout);					  \
   fprintf(stderr, fmt " (%d - %s)\n" , ## args, errno, strerror(errno)); \
   fflush(stderr);                                                        \
}
#define printfe(fmt, args...)	{					  \
   printf("\n"); fflush(stdout);					  \
   fprintf(stderr, fmt, ## args);					  \
   fflush(stderr);                                                        \
}


static inline int max(int a, int b) {
    return (a < b) ? b : a;
}
static inline int min(int a, int b) {
    return (a < b) ? a : b;
}	


void * cth_memory(void * old, int size, char * error_msg);
#define cth_free(p)	cth_memory(p, 0, "")

int gettime();

typedef struct {
    int x, y;
} xy;


#endif







