#include "cthugha.h"
#include "options.h"
#include "sound.h"
#include "display.h"
#include "action.h"
#include "translate.h"
#include "information.h"
#include "display.h"
#include "sound.h"
#include "cd_player.h"
#include "keys.h"
#include "server.h"
#include "waves.h"

#include <stdio.h>
#include <unistd.h>
#include <string.h>

int putini_str(const char * entry, char * value);
int putini_yesno(const char * entry, int value);
int putini_int(const char * entry, int value);
int putini_use(feature * in, int pos);

/* 
 * read the usage from the ini files
 */
int read_ini_usage() {
    int i;

    open_ini_start();
    while(open_ini_file() == 0) {
	
	/* get usage */
	for(i=0; i < waves.nr_entries; i++) 
	    getini_use(&waves, i);

	for(i=0; i < flames.nr_entries; i++)
	    getini_use(&flames, i);

	for(i=0; i < screens.nr_entries; i++)
	    getini_use(&screens, i);

	for(i=0; i < palettes.nr_entries; i++)
	    getini_use(&palettes, i);

	for(i=0; i < pcxs.nr_entries; i++)
	    getini_use(&pcxs, i);

	for(i=0; i < translations.nr_entries; i++)
	    getini_use(&translations, i);

	for(i=0; i < objects.nr_entries; i++)
	    getini_use(&objects, i);

	/* close the ini-file */
	fclose(ini_file);
    }
    return 0;
}


/*
 * move old ini-file to backup file
 * ~/.cthugha.auto -> ~/.cthugha.auto.old
 */
static int move(char * src, char * dst) {
    
    unlink(dst);

    if( link(src, dst) ) {
	printfee("Can not make backup of %s", src);
	return 1;
    }

    if( unlink(src) ) {
	printfee("Can not remove original %s", src);
	return 1;
    }
    return 0;
}
    
    

static int is_in_ini(char * line) {
    char * ptr;
    int len;

    /* only lines with values are interresting */
    if( (ptr = strchr(line, ':')) == NULL)
	return 1;

    len = ptr - line;

    rewind(ini_file);
    while( ! feof(ini_file) ) {
	char line2[256];
	
	fgets(line2, 256, ini_file);
	if(strncmp(line, line2, len) == 0) {
	    return 1;
	}
    }
    return 0;
}

/*
 *  Create the automatic ini-file
 */
int write_ini() {
    int i;
    char * fname = ini_file_name(-1);
    char fname_dst[256];
    FILE * f;
    
    strncpy(fname_dst, fname, 256);
    strncat(fname_dst, ".old", 256);

    /* make sure file exists */
    if( (f = fopen(fname, "a")) == NULL) {
	printfe("Can not open ini file.");
	return 1;
    }
    fclose(f);

    if( move(fname, fname_dst) )
	return 1;

    if( (ini_file = fopen(fname, "w+")) == NULL )
	return 1;
	
    /* write header */
    fprintf(ini_file, 
	    "#\n"
	    "# .cthugha.auto\n"
	    "#\n"
	    "# This file was created automatically, please do not edit.\n"
	    "#\n");

    /* save current flame, wave, ... as new start-values */
    putini_str("flame",		flames.entries[flames.current].name);
    putini_str("wave",		waves.entries[waves.current].name);	
    putini_str("palette",	palettes.entries[palettes.current].name);
    putini_str("display",	screens.entries[screens.current].name);
    putini_str("translation",	translations.entries[translations.current].name);
    putini_str("pcx",		pcxs.entries[pcxs.current].name);
    putini_str("object",	objects.entries[pcxs.current].name);

    putini_int("table",		active_table);
    putini_int("massage",	sound_massage_style);
    
    putini_int("time",		sound_wait_min);
    putini_int("random",	sound_wait_random);
    putini_int("fire-level",	sound_firelevel);
    putini_int("quiet-time",	sound_wait_quiet);
    putini_int("silence-time",	sound_quiet_change);
    putini_yesno("lock",	action_lock);
    putini_yesno("little",	change_little);
    putini_yesno("fft",		sound_use_fft);
    putini_yesno("flashlight",	sound_use_flashlight);
    putini_int("wave-scale",	wave_scale);
    
    /* write waves, flames, displays, palettes, pcxs, translations sec. */
    for(i=0; i < waves.nr_entries; i++) 
	putini_use(&waves, i);
    
    for(i=0; i < flames.nr_entries; i++)
	putini_use(&flames, i);
    
    for(i=0; i < screens.nr_entries; i++)
	putini_use(&screens, i);
    
    for(i=0; i < palettes.nr_entries; i++)
	putini_use(&palettes, i);
    
    for(i=0; i < pcxs.nr_entries; i++)
	putini_use(&pcxs, i);
    
    for(i=0; i < translations.nr_entries; i++)
	putini_use(&translations, i);

    for(i=0; i < objects.nr_entries; i++)
	putini_use(&objects, i);

    /*
     * copy old settings
     */
    if( (f = fopen(fname_dst, "r")) == NULL) {
	printfe("Can not open backup file");
	return 1;
    }

    /* check for all files, if they are in the ini file */
    while(!feof(f)) {
	char line[256];

	fgets(line, 256, f);
	if( !is_in_ini(line) ) {
	    fseek(ini_file, 0, SEEK_END);
	    fputs(line, ini_file);
	}
    }
    
    fclose(f);
    fclose(ini_file);

    return 0;
}
