/*
 * Write the sound data simply to stdoutput
 */

#include <stdio.h>	/*(perror)*/
#include <fcntl.h>	/*O_WRONLY*/
#include <sys/ioctl.h>	/*(ioctl)*/
#include <unistd.h>	/*(write)*/
#include <sys/soundcard.h> /*SNDCTL_XXX*/
#include <errno.h>	/*EINTR*/
#include "defs.h"	/*u8,u16*/
#include "dacio.h"	/*(dacioXXX)*/
#include "mem.h"	/*(memPerm)*/

#if 0
#define LIM_SIZE (32 * 256) /* 32ch * 8bit */

static u8 *lim;

static void
makeLim(void)
{
    u8 *p;
    i15x i;

    lim = (u8 *)memPerm(LIM_SIZE) + LIM_SIZE/2;
    p = lim-128;
    for (i = 0; i < 256; i++, p++) *p = i;
    for (; p < lim + LIM_SIZE/2; p++) *p = 255;
}
#endif

static int fd;

void
dacioInit(void)
{
    fd = STDOUT_FILENO;
    /*makeLim();*/
}

static struct {
    union {
	u8 *p8;
	u16 *p16;
    } p;
    u8 *top;
    u8 *bot;
    int size;
} buf;

static DacioConfInfo dci;

void
dacioConf(DacioConfInfo *dcp)
{

    printf("CTH channels: %d\n", dcp->stereo);
    printf("CTH speed: %d\n", dcp->speed);
    printf("CTH start\n");

    buf.size = 128;
    buf.top = memPerm(buf.size * sizeof(u8));
    buf.p.p8 = buf.top;
    buf.bot = buf.top + buf.size;

    dci = *dcp;
}

void
dacioSync(void)
{
}

/* OS independent part (?) */

void
dacioFlush(void)
{
    int s;

    if (buf.p.p8 <= buf.top) return;
    for ( ; buf.p.p8 < buf.bot; buf.p.p8++) *buf.p.p8 = 128;
 RETRY:
    s = write(fd, buf.top, buf.size);
    if (s < buf.size) {
	if (s < 0) {
	    if (errno == EINTR) goto RETRY; 
	    perror("dacioFlush");
	} else fprintf(stderr, "wrote only %d bytes\n", s);
	exit(1);
    }
    buf.p.p8 = buf.top;
}

static struct {
    const i31 *p0;
    const i31 *p;
    i15x len;
} inbuf;

void
dacioIncomingBuf(const i31 *bp)
{
    inbuf.p0 = bp;
}

void
dacioIncomingBufLen(i15x len)
{
    inbuf.len = len;
}

static i15x gv = 0x40*0x40; /* default g.v = m.v = 64 */

/* gv = 0(min)..64*128(max) */
void
dacioGlobalVol(i15x v)
{
    gv = v;
}

#define VOL_MAX		(64*64*128)	/* vol max * g.v max * m.v max */
#define VOL_MAX_LOG	( 6+ 6+  7)	/* 1 << VOL_MAX_LOG == VOL_MAX */
#define LEV_MAX		(128*VOL_MAX)

#if 0
#define to8bit(x, /*i31x*/tmpvar) \
    ( tmpvar = (x) * gv, \
     (tmpvar >= LEV_MAX) ? 255 : \
     (tmpvar < -LEV_MAX) ? 0 : \
     (u32x)tmpvar/VOL_MAX ^ 128 )
/*   ^^^^^^ see asm output w/o this */
#define to8bit(x, /*i31x*/tmpvar) \
    ( tmpvar = (x) * gv + LEV_MAX, \
     (tmpvar & ~(LEV_MAX*2-1)) ? \
     ((tmpvar < 0)? 0 : 255) : \
     (u32x)tmpvar/VOL_MAX)
#define to8bit(x, /*i31x*/tmpvar) lim[(x) * gv >> VOL_MAX_LOG]
#else
/* almost the same CPU usage as lim[] table mathod */
#define to8bit(x, /*i31x*/tmpvar) \
    ( tmpvar = ((x) * gv + LEV_MAX) >> VOL_MAX_LOG, \
     (tmpvar & ~255)? ~tmpvar >> 16 : tmpvar ) /* 16 will be OK */
/*                   ~(tmpvar >> 16) makes longer asm */
#endif

/* stereo */
static void
dacioOutHirevS(i15x n)
{
    const i31 *inbufp = inbuf.p;
    u8 *u8p = buf.p.p8;

    for (; n > 0; n--) {
	i31x tmp;
	*u8p++ = to8bit(*inbufp++, tmp); /* L */
	*u8p++ = to8bit(*inbufp++, tmp); /* R */
    }
    inbuf.p = inbufp;
    buf.p.p8 = u8p;
}

/* mono */
static void
dacioOutHirevM(i15x n)
{
    const i31 *inbufp = inbuf.p;
    u8 *u8p = buf.p.p8;

    for (; n > 0; n--) {
	i31x tmp;
	*u8p++ = to8bit(*inbufp, tmp);
	inbufp += 2;
    }
    inbuf.p = inbufp;
    buf.p.p8 = u8p;
}

#define dacioOutHirev(x) \
    if (dci.stereo) dacioOutHirevS(x); else dacioOutHirevM(x)
#define bufRest() (dci.stereo? (buf.bot - buf.p.p8)/2 : buf.bot - buf.p.p8)

void
dacioOut(void)
{
    i31x iLen;
    i31x oLen;

    inbuf.p = inbuf.p0;
    iLen = inbuf.len;
    while ((oLen = bufRest()) <= iLen) {
	iLen -= oLen;
	dacioOutHirev(oLen);
	dacioFlush();
    }
    dacioOutHirev(iLen);
}
