#include "cthugha.h"
#include "options.h"
#include "server.h"
#include "sound.h"
#include "display.h"
#include "action.h"
#include "translate.h"
#include "information.h"
#include "display.h"
#include "sound.h"
#include "cd_player.h"
#include "keys.h"
#include "network.h"
#include "waves.h"
#ifdef CTH_XWIN
#include "cthugha-X11.h"
#include "xwin/dga.h"
#endif

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>

int BUFF_WIDTH = 320;
int BUFF_HEIGHT = 200;
int buffer_sizes[][2] = {			/* predefined buffer-sizes */
    { 160, 100 },    { 320, 200 },    { 320, 300 },    { 360, 480 },
    { 640, 480 }
};
int nr_buffer_sizes = sizeof(buffer_sizes)/sizeof(int)/2;

enum option_nr {
    opt_verbose = 32768,
    opt_play,
    opt_play_silent,
    opt_text_time,
    opt_snd_fragments,
    opt_mixer,
    opt_srv_port,
    opt_silence_time,
    opt_prt_file,
    opt_tile,
    opt_no_tile,
    opt_mirror,
    opt_no_mirror,
    opt_clt_port,
    opt_fire_level,
    opt_exec,
    opt_exec_silent,
    opt_mod,
    opt_mp3,
    opt_wave_scale,
};

struct option long_options[] = {
    { "help",  		0, 0,'?'},
    { "verbose", 	2, 0, opt_verbose},
    { "no-verbose",	1, &cthugha_verbose, 0},
    { "line",		1, 0,'L'},
    { "mic",		1, 0,'M'},
    { "cd",		1, 0,'C'},
    { "track",		1, 0,'c'},
    { "rate",		1, 0,'v'},
#if USE_CDROM == 1
    { "cd-stop",	0, &cd_stop_on_exit, 1},
    { "no-cd-stop",	0, &cd_stop_on_exit, 0},
    { "cd-random",	0, &cd_randomplay, 1},
    { "no-cd-random",	0, &cd_randomplay, 0},
    { "cd-no-random",	0, &cd_randomplay, 0},
    { "cd-loop",	0, &cd_loop, 1},
    { "no-cd-loop",	0, &cd_loop, 0},
    { "cd-no-loop",	0, &cd_loop, 0},
    { "cd-eject",	0, &cd_eject_on_end, 1},
    { "no-cd-eject",	0, &cd_eject_on_end, 0},
    { "cd-no-eject",	0, &cd_eject_on_end, 0},
    { "cd-autoplay",	0, &cd_first_track, 1},
    { "cd-no-autoplay",	0, &cd_first_track, -1},
    { "no-cd-autoplay",	0, &cd_first_track, -1},
#endif
    { "no-sound",	0, 0, 'x'},
    { "stereo",		0, &sound_options_init.channels, 2},
    { "no-stereo",	0, &sound_options_init.channels, 1},
    { "mono",		0, &sound_options_init.channels, 1},
    { "no-mono",	0, &sound_options_init.channels, 2},
#if USE_DSP == 1
    { "snd-sync",	0, &sound_sync, 1},
    { "no-snd-sync",	0, &sound_sync, 0},
#endif
    { "buff-size",	1, 0,'S'},
    { "snd-fork",	0, &sound_fork, 1},
    { "no-snd-fork",	0, &sound_fork, 0},
    { "snd-fragments",	1, 0, opt_snd_fragments},
    { "no-snd-fragments", 0, &sound_options_init.fragments, 0},
    { "mixer",		1, 0, opt_mixer},
    { "srv-port",	1, 0, opt_srv_port},
    { "srv-wait",	1, 0, 'W'},
    { "path",		1, 0, 'E'},
    { "play",		1, 0, opt_play},
    { "play-silent",	1, 0, opt_play_silent},
    { "exec",		1, 0, opt_exec},
    { "exec-silent",	1, 0, opt_exec_silent},
    { "mod",		1, 0, opt_mod},
    { "mp3",		1, 0, opt_mp3},
#ifndef CTH_SERV
    { "text-time",	1, 0, opt_text_time},
    { "sync",		0, &display_syncwait, 1},
    { "no-sync",	0, &display_syncwait, 0},
    { "flame",		1, 0,'f'},
    { "wave",		1, 0,'w'},                      
    { "wave-scale",	1, 0, opt_wave_scale},
    { "translation",	1, 0,'t'},
    { "palette",	1, 0,'p'},
    { "display",	1, 0,'d'},
    { "object",		1, 0,'o'},
    { "no-object",	0, &use_objects, 0},
    { "no-use-object",	0, &use_objects, 0},
    { "use-object",	1, &use_objects, 0},
    { "lock",		0, &action_lock, 1},
    { "no-lock",	0, &action_lock ,0},
    { "use-pcx",	0, &display_use_pcx, 1},
    { "no-use-pcx",	0, &display_use_pcx, 0},
    { "trans",		0, &use_translations, 1},
    { "no-trans", 	0, &use_translations, 0},
    { "fft",		0, &sound_use_fft,		1},
    { "no-fft",		0, &sound_use_fft,		0},
    { "flashlight",	0, &sound_use_flashlight,	1},
    { "no-flashlight",	0, &sound_use_flashlight,	0},
    { "ipal",		0, &display_internal_pal, 1},
    { "no-ipal",	0, &display_internal_pal, 0},
    { "epal",		0, &display_external_pal, 1},
    { "no-epal",	0, &display_external_pal, 0},
    { "time",		1, 0,'T'},
    { "random",		1, 0,'R'},
    { "quiet-time",	1, 0,'Q'},
    { "fire-level",	1, 0, opt_fire_level},
    { "quiet-file",	1, 0,'q'},
    { "disp-mode",	1, 0,'D'},

    { "tile",		0, 0, opt_tile},
    { "no-tile",	0, 0, opt_no_tile},
    { "tile-x", 	0, &disp_do_tiles.x, 1},
    { "tile-y", 	0, &disp_do_tiles.y, 1},
    { "no-tile-x",	0, &disp_do_tiles.x, 0},
    { "no-tile-y",	0, &disp_do_tiles.y, 0},

    { "mirror",		0, 0, opt_mirror},
    { "no-mirror",	0, 0, opt_no_mirror},
    { "mirror-x",	0, &disp_do_mirror.x, 1},
    { "mirror-y",	0, &disp_do_mirror.y, 1},
    { "no-mirror-x",	0, &disp_do_mirror.x, 0},
    { "no-mirror-y",	0, &disp_do_mirror.y, 0},

    { "network",	1, 0,'N'},
    { "esc",		0, &key_esc, 1},
    { "no-esc",		0, &key_esc, 0},
    { "save",		0, &options_save, 1},
    { "no-save",	0, &options_save, 0},
    { "prt-file",	1, 0, opt_prt_file},
    { "table",		1, 0, 'a'},
    { "massage",	1, 0, 'm'},
    { "pcx",            1, 0, 'P'},
    { "no-pcx",		0, &display_use_pcx, 0},
    { "silence-time",	1, 0, opt_silence_time},
    { "stretch",	0, &trans_stretch, 1},
    { "no-stretch",	0, &trans_stretch, 0},
    { "little",		0, &change_little, 1},
    { "no-little",	0, &change_little, 0},
    { "clt-port",	1, 0, opt_clt_port},
    { "dbl-load",	0, &double_load, 1},
    { "no-dbl-load",	0, &double_load, 0},
    { "server",		0, &server, 1},
    { "no-server",	0, &server, 0},
    { "disp-direct",	0, &display_direct, 1},
    { "no-disp-direct",	0, &display_direct, 0},

    { "rgb",		0, &flame_use_rgb, 1},
    { "use-rgb",	0, &flame_use_rgb, 1},
    { "no-rgb",		0, &flame_use_rgb, 0},
    { "no-use-rgb",	0, &flame_use_rgb, 0},

#ifdef CTH_XWIN
    { "mit-shm",	0, &display_mit_shm, 1},
    { "no-mit-shm",	0, &display_mit_shm, 0},
    { "on-root",	0, &display_on_root, 1},
    { "no-on-root",	0, &display_on_root, 0},
    { "in-window",	0, &display_on_root, 0},
    { "no-in-window",	0, &display_on_root, 1},
    { "private-cmap",	0, &display_private_cmap, 1},
    { "no-private-cmap",0, &display_private_cmap, 0},
    { "saver",		0, &xcth_saver, 1},
    { "no-saver",	0, &xcth_saver, 0},
    { "dga",		0, &xcth_dga, 1},
    { "no-dga",		0, &xcth_dga, 0},
    { "panel",		0, &xcth_panel, 1},
    { "no-panel",	0, &xcth_panel, 0},
#if USE_DGA == 1
    { "nobuff",		0, &nobuff, 1},		/* for compatibility */
    { "no-buff",	0, &nobuff, 1},
    { "dga-soft-buff",	0, &nobuff, 1},
    { "no-dga-soft-buff", 0, &nobuff, 0},
    { "dga-no-soft-buff", 0, &nobuff, 0},
#endif

#endif

#endif /* CTH_SERV */
    { 0,0,0,0}
};


/* make sure, we have at least some getopt */
#ifndef no_argument
int getopt_long(int argc, char ** argv, char * opt, struct option * long_opt,
		int * optind) {
    
    static int first = 1;
    if(first) {
	printfv(0, "Long options are not supported on this system.\n");
	first = 0;
    }

    return getopt(argc, argv, opt);
}
#endif

int do_param(int c, int value, char * str) {
    switch(c) {
    case 0:
	return 0;
    case '2':					/* Stereo */
	sound_options->channels = 2;	break;
    case '1':					/* Mono */
	sound_options->channels = 1;	break;

    case 'v':					/* Sample-Speed */
	sound_options->speed = value;	
	break;

#if USE_MIXER == 1
    case 'L':					/* Line as input */
	mixer_set_volume("line", value | (value << 8));
	break;
    case 'M':					/* Mic as input */
	mixer_set_volume("mic", value | (value << 8));
	break;
    case 'C':					/* CD as input */
	mixer_set_volume("cd", value | (value << 8));
	break;
#endif
    case 'c':					/* with cd starting at track */
	sound_use[snddev_cd] = 1;
#if USE_CDROM == 1
	cd_first_track = value;
#endif
	break;
    case 'x':					/* debug mode */
	sound_use_clear();
	sound_use[snddev_debug] = 1;
	break;

#ifndef CTH_SERV
    case 'f':					/* Set start flame */
	strcpy(flame_first, str);	break;
    case 'w':					/* Set start wave */
	strcpy(wave_first, str);	break;
    case 'p':					/* Set first palette */
	strcpy(palette_first, str);	break;
    case 'd':					/* Set first display */
	strcpy(screen_first, str);	break;
    case 't':					/* Set first translate */
	strcpy(translate_first, str);	break;
    case 'P':					/* Set first PCX */
	strcpy(pcx_first, str);		break;
    case 'a':					/* Set first table */
	table_first = value;		break;
    case 'm':					/* Set first massage */
	massage_first = value;		break;
    case 'o':					/* Set first 3-D object */
	strcpy(object_first, str);	break;
    case opt_wave_scale:
	wave_scale = value % 3;		break;

    case 'l':					/* Lock changes */
	action_lock = 1;		break;

    case 'i':					/* no internal palettes */
	display_internal_pal = 0;	break;
    case 'e':					/* no external palettes */
	display_external_pal = 0;	break;

    case 's':					/* no flashlight */
	sound_use_flashlight = 0;	break;

    case 'F':					/* no FFT */
	sound_use_fft = 0;		break;
	
    case 'T':					/* Time to change */
	sound_wait_min = value; 	break;
    case 'R':					/* Add. Random time */
	sound_wait_random = value;	break;
    case 'Q':					/* Quiet Time */
	sound_wait_quiet = value;	break;

    case 'r':					/* sync-mode */
	display_syncwait = 1;		break;

    case opt_fire_level:
	sound_firelevel = value;	break;

    case 'q':					/* alternative quiet-strings */
	load_quiet_strings(str);	break;

    case 'X':					/* disable PCX */
	display_use_pcx = 0;		break;

    case 'N': {					/* Read from remote machine */
	char * p;
	sound_use_clear();
	sound_use[snddev_sock] = 1;
	if( (p = strchr(str, ':')) != NULL ) {
	    *p = '\0';
	    SRV_PORT = atoi(p+1);
	}
	strncpy(sound_hostname, str, 255);
	break;
    }
    case 'D':					/* display-mode */
	if( strchr(str, 'x') == NULL) {
	    /* use a predefined size */
	    display_mode = value;
	} else {
	    /* use a special size (only useful with X11) */
	    display_mode = -1;
	    disp_size.x = value;
	    disp_size.y = atoi(strchr(str, 'x')+1);
	}
	break;
#endif

    case 'S':					/* buffer-size */
	if( strchr(str, 'x') == NULL) {
	    /* use a predfined size */
	    if( value < 0)			
		value = 0;
	    if( value >= nr_buffer_sizes)	
		value = nr_buffer_sizes;
	    BUFF_WIDTH = buffer_sizes[value][0];
	    BUFF_HEIGHT = buffer_sizes[value][1];
	} else {
	    /* use a special size */
	    BUFF_WIDTH = value;
	    BUFF_HEIGHT = atoi(strchr(str, 'x')+1);
	    if( BUFF_WIDTH < 64)		
		BUFF_WIDTH = 64;
	    if( BUFF_HEIGHT < 64)		
		BUFF_HEIGHT = 64;
	    if( BUFF_WIDTH > MAX_BUFF_WIDTH)	
		BUFF_WIDTH = MAX_BUFF_WIDTH;
	    if( BUFF_HEIGHT > MAX_BUFF_WIDTH)	
		BUFF_HEIGHT = MAX_BUFF_WIDTH;
	}
	break;
	
#ifndef CTH_SERV	
    case opt_prt_file:
	strncpy(display_prt_file, str, 255);
	break;

    case 'E':					/* extra lib path */
	strncpy(extra_lib_path, str, 255);
	strncat(extra_lib_path, "/", 255);
	break;

    case opt_silence_time:
	sound_quiet_change = value;		/* for change at small pause */
	break;

    case opt_tile:
	disp_do_tiles.x = disp_do_tiles.y = 1;
	break;
    case opt_no_tile:
	disp_do_tiles.x = disp_do_tiles.y = 0;
	break;

    case opt_mirror:
	disp_do_mirror.x = disp_do_mirror.y = 1;
	break;
    case opt_no_mirror:
	disp_do_mirror.x = disp_do_mirror.y = 0;
	break;


    case opt_clt_port:	
	CLT_PORT = value; break;
#endif

    case 'W':					/* time to wait when server */
	srv_wait_time = value;
	break;

    case opt_srv_port:
	REQ_PORT = value; break;

    case opt_verbose:
	cthugha_verbose = str ? value : 4;
	break;

#ifndef CTH_SERV
    case opt_text_time:
	display_text_time = value;
	break;
#endif

    case opt_play:
	strncpy(sound_file_name, str, 512);
	sound_use_clear();
	sound_use[snddev_play] = 1;
	sound_use[snddev_dsp_w] = 1;
	sound_use[snddev_mixer] = 1;
	sound_fork = 1;
	break;
    case opt_play_silent:
	strncpy(sound_file_name, str, 512);
	sound_use_clear();
	sound_use[snddev_play] = 1;
	break;

    case opt_exec:
	strncpy(sound_file_name, str, 512);
	sound_use_clear();
	sound_use[snddev_exec] = 1;
	sound_use[snddev_dsp_w] = 1;
	sound_use[snddev_mixer] = 1;
	sound_fork = 1;
	break;
    case opt_exec_silent:
	strncpy(sound_file_name, str, 512);
	sound_use_clear();
	sound_use[snddev_exec] = 1;
	break;

    case opt_mod:
	strncpy(sound_file_name, INST_LIB, 512);
	strncat(sound_file_name, "/", 512);
	strncat(sound_file_name, "cth-nspmod ", 512);
	strncat(sound_file_name, str, 512);
	sound_use_clear();
	sound_use[snddev_exec] = 1;
	sound_use[snddev_dsp_w] = 1;
	sound_use[snddev_mixer] = 1;
	sound_fork = 1;
	break;

    case opt_mp3:
	strncpy(sound_file_name, INST_LIB, 512);
	strncat(sound_file_name, "/", 512);
	strncat(sound_file_name, "cth-amp ", 512);
	strncat(sound_file_name, str, 512);
	sound_use_clear();
	sound_use[snddev_exec] = 1;
	sound_use[snddev_dsp_w] = 1;
	sound_use[snddev_mixer] = 1;
	sound_fork = 1;
	break;

	
    case opt_snd_fragments:
	sound_options->fragments = value;
	break;

#if USE_MIXER == 1
    case opt_mixer: {
	char name[100]; char * p;
	int vol;
	if( (p = strchr(str, ':')) != 0) {
	    *p = ' ';
	}
	sscanf(str, "%s %d", name, &vol);
	mixer_set_volume(name, vol);
	break;
    }
#endif

    default:					/* error or help */
	return 1;
    }
    return 0;
}

/*
 * Process parameters, before anything else is done
 */
static int optindsave;
int get_pre_params(int argc, char * argv[]) {
    int c;
    int option_index = 0;

    static struct option long_options_preini[] = {
	{ "path",		1, 0, 'E'},
	{ "verbose", 		2, 0, opt_verbose},
	{ "no-verbose",		1, &cthugha_verbose, 0},
#ifdef CTH_XWIN
	{ "saver",		0, &xcth_saver, 1},
	{ "no-saver",		0, &xcth_saver, 0},
#endif
	{ 0,0,0,0}
    };
    
    char * argv_tmp[ argc ];			/* copy of argv to work with */
    optindsave=optind;
    opterr = 0;					/* don't print error msgs */
    for(c=0; c < argc; c++)			/* save argv */
    	argv_tmp[c] = argv[c];

    while((c = getopt_long(argc, argv_tmp, "E:", 
			   long_options_preini, &option_index)) != -1) {
	if ( do_param((c=='?') ? 0 : c,
		      optarg ? atoi(optarg) : 0, optarg) )
	    return 1;
    }
	    
    return 0;
}

/* 
 *  Process programm-params 
 */
int get_params(int argc, char * argv[]) {
    int c;
    int option_index = 0;

    /* 
     * now read from ini-files 
     */
    read_ini();	 
		
    /*
     * get command line options after loading ini files 
     */
    opterr = 1;					/* print error msgs */
    option_index = 0; optind = optindsave; 	/* start again at first opt */

    while((c=getopt_long(argc, argv, 
    			 "21v:L:M:C:c:xrP:E:?S:W:" 
                         #ifndef CTH_SERV
			 "f:w:d:p:t:o:q:T:R:N:D:a:m:XlieQ:Fs"
			 #endif
			 ,long_options, &option_index)) != -1 ) {

	if( do_param(c, optarg ? atoi(optarg) : 0, optarg) ) {
	    usage();
	    return 1;
	}
    }

    return 0;
}


