/* Written by Mark Vojkovich (mvojkovi@ucsd.edu) */
/* modified by Harald Deischinger */

#ifndef __DGA_H
#define __DGA_H

#if USE_DGA == 1

#include <X11/Xlib.h>
#include <X11/X.h>
#include <X11/extensions/xf86dga.h>
#include <X11/extensions/xf86vmode.h>

#define MINMAJOR 0
#define MINMINOR 0
#define	HardwareDB	0
#define SoftwareDB	1
#define	SubOK		1
#define NoSub		0

extern char*		DGAMemPtr;
extern char*		DGAMemBase;
extern char*		DGASecondPage;

extern Bool		DGADoubleBuffer;
extern int		DGABankSwitching;

extern int		DGARAMSize;
extern int		DGABankSize;
extern int		DGAPageSize;

extern int 		DGAFrameBufferWidth;

unsigned long* 		DGARGBColors;

int InitDGAEnvironment();
int DGAInitDoubleBuffer(int type,Bool sub);
void (*DGADoubleBuffer_function)();

void (*DGAClearScreen_function)();
#define CLEARSCREEN()	(*DGAClearScreen_function)()
void DGAClearScreen_Linear();
void DGAClearScreen_Banked();

void (*DGADoubleBuffer_function)(int clear);
#define DOUBLEBUFFER(clear)	{ 				\
    (*DGADoubleBuffer_function)(clear);				\
    display_bitmap = DGAMemPtr +				\
	(window_size.y - disp_size.y)/2 * bytes_per_line +	\
	(window_size.x - disp_size.x)/2 * bypp;			\
}

void DGADoubleBuffer_Hardware(int clear);
void DGADoubleBuffer_Software_Linear(int clear);
void DGADoubleBuffer_Software_Banked(int clear);

int alloc_image_dga();
int free_image_dga();

extern int nobuff;

#endif /* USE_DGA */

#endif /* __DGA_H */


