#include "../cthugha.h"
#include "../display.h"
#include "../disp-sys.h"
#include "../imath.h"
#include "../cthugha-X11.h"
#include "dga.h"

int display_private_cmap=1;			/* use a private colormap */

int byte_order;

int init_palettes_sys() {

    /* general settings for palettes */
    switch(xcth_visual->class) {

    case TrueColor: 
    case DirectColor: {
	XPixmapFormatValues * pfv;
	int i;
	/* Check Pixmap formats */
	if( (pfv = XListPixmapFormats(xcth_display, &i)) == NULL) {
	    printfe("Can't get pixmap format list from screen");
	    return 1;
	}
	while( --i > 0)
	    if( pfv[i].depth == xcth_planes) break;
	if( i < 0) {
	    printfe("No pixmap format matches screen depth");
	    return 1;
	}
	
	/* set general information for palettes */
	colormapped = 0;
	bpp = pfv[i].bits_per_pixel;
	bypp = (bpp+7) / 8;
	red_mask = xcth_visual->red_mask;
	red_shift = ffs(red_mask & ~(red_mask >> 1)) - 8;
	green_mask = xcth_visual->green_mask;
	green_shift = ffs(green_mask & ~(green_mask >> 1)) - 8;
	blue_mask = xcth_visual->blue_mask;
	blue_shift = ffs(blue_mask & ~(blue_mask >> 1)) - 8;

	printfv(10, "  red   mask/shift: 0x%x/%d\n", red_mask, red_shift);
	printfv(10, "  green mask/shift: 0x%x/%d\n", green_mask, green_shift);
	printfv(10, "  blue  mask/shift: 0x%x/%d\n", blue_mask, blue_shift);

	switch(bypp) {
	case 1:	draw_mode = DM_mapped1; break;
	case 2: draw_mode = DM_mapped2; break;
	case 4: draw_mode = DM_mapped4; break;
	default:
	    printfe("Unsupported bytes per pixel");
	    return 1;
 	}	
	break;
    } 
    case StaticGray:
    case StaticColor: 
    case GrayScale:
	colormapped = 0;
	draw_mode = DM_mapped1;
	red_mask = green_mask = blue_mask = 0xffff;
	red_shift = green_shift = blue_shift = 0;
	break;

    case PseudoColor: {		/* 256 color mode with palette */
	bpp = 8;	bypp = 1;
	if( display_on_root || (display_private_cmap == 0)) {
	    int i;

	    draw_mode = DM_mapped1;
	    xcth_cmap = DefaultColormap(xcth_display, xcth_screen);

	    for(i=0; i < 256; i++)
		bitmap_colors[i] = 0;

	    colormapped = 2;
	} else {
	    draw_mode = DM_direct;
	    xcth_cmap = XCreateColormap(xcth_display, xcth_window,
					xcth_visual, AllocAll);
	    XSetWindowColormap(xcth_display, xcth_window, xcth_cmap);  
	    colormapped = 1;
	}
    }
    }

    return 0;
}


int free_color_cells() {
    /* free old color cells */
    int i;
    unsigned long pixels[256]; int npixels = 0;

    for(i=0; i < 256; i++) 
	if( bitmap_colors[i])
	    pixels[npixels ++] = bitmap_colors[i];
    if(npixels > 0)
	XFreeColors(xcth_display, xcth_cmap, pixels, npixels, 0);

    return 0;
}

int exit_palettes_sys() {
    if(colormapped == 1)
	XFreeColormap(xcth_display, xcth_cmap);
    else if(colormapped == 2)
	free_color_cells();
    return 0;
}



int set_palette_sys() {
    int i;

    if( (draw_mode == DM_direct) || (draw_mode == DM_tmp_mapped) ) {
	XColor col[256];
	for(i=0; i < 256; i++) {
	    col[i].pixel = i;
	    col[i].red   = cur_palette[i][0] << 8;
	    col[i].green = cur_palette[i][1] << 8;
	    col[i].blue  = cur_palette[i][2] << 8;
	    col[i].flags = DoRed | DoGreen | DoBlue;
	}
	XStoreColors(xcth_display, xcth_cmap, col, 256);  

    } else if( colormapped == 2) {
	free_color_cells();

	/* allocate new color cells */
	for(i=255; i >=0; i--) {
	    XColor col;
	    col.pixel = i;
	    col.red   = cur_palette[i][0] << 8;
	    col.green = cur_palette[i][1] << 8;
	    col.blue  = cur_palette[i][2] << 8;
	    col.flags = DoRed | DoGreen | DoBlue;
	    if( XAllocColor(xcth_display, xcth_cmap, &col) == 0) {
		/* can not allocate colorcell */
		bitmap_colors[i] = 0;
	    } else {
		bitmap_colors[i] = col.pixel;
	    }
	}
    } else {
	for(i=0; i < 256; i++) {
	    bitmap_colors[i] = 
		(red_mask   & shift(cur_palette[i][0], red_shift  )) |
		(green_mask & shift(cur_palette[i][1], green_shift)) |
		(blue_mask  & shift(cur_palette[i][2], blue_shift ));
	    if( rev_byte_order) 
		bitmap_colors[i] = switch_byte_order(bitmap_colors[i]);
	}
    }
    return 0;
}









