/****************************************************************************/
/*                                                                          */
/* Program:   i_colourmap.c                                                 */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Wed Feb 26 11:49:16 1992                                      */
/* Function:  Colourmap Routines                                            */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "lib.h"

/*#define debug(m) DEBUG("<colourmap> " m)*/
#define debug(m)

#define colour_hash(p) ((((p)->r+(p)->g+(p)->b)&0x7fff)%IM_CMAP_HASHSIZE)

/****************************************************************************/

it_cmap *i_create_colourmap(int maxindex)
{
  it_cmap *cmap;
  it_cmap_entry *ptr;
  int i;

  if(maxindex<1)
    return(NULL);
  if((cmap=(it_cmap *) calloc(1,sizeof(it_cmap)))==NULL)
    return(NULL);
  cmap->maxindex=maxindex;
  cmap->cmap_list=(it_cmap_entry *) calloc(maxindex,sizeof(it_cmap_entry));
  if(cmap->cmap_list==NULL)
    {
      free((char *) cmap);
      return(NULL);
    }
  /* build hash list - all colours start as rgb={0,0,0} due to calloc */
  ptr=cmap->cmap_list;
  cmap->hash_col[colour_hash(&(ptr->colour))]=ptr;
  for(i=1;i<maxindex;i++)
      ptr=(ptr->next_col= &(cmap->cmap_list[i]));
  return(cmap);
}

void i_destroy_colourmap(it_cmap *cmap)
{
  if(cmap!=NULL)
    {
      if(cmap->cmap_list!=NULL) free((char *) (cmap->cmap_list));
      free((char *) cmap);
    }
}

void i_set_colourmap_entry(it_cmap *cmap,int index,it_rgb *colour)
{
  it_cmap_entry *entry,*ptr;
  int old_colour,new_colour;

  if(index<0 || index>=cmap->maxindex) return;
  entry= &(cmap->cmap_list[index]);

  /* find previous colour in this index position and unlink */
  old_colour=colour_hash(&(entry->colour));
  if(cmap->hash_col[old_colour]==entry)
    cmap->hash_col[old_colour]=entry->next_col;
  else
    for(ptr=cmap->hash_col[old_colour];ptr->next_col!=NULL;ptr=ptr->next_col)
      if(ptr->next_col==entry)
	{
	  ptr->next_col=entry->next_col;
	  break;
	}
  /* write new colour values and link into hash list */
  (entry->colour).r=colour->r;
  (entry->colour).g=colour->g;
  (entry->colour).b=colour->b;
  new_colour=colour_hash(colour);
  entry->next_col=cmap->hash_col[new_colour];
  cmap->hash_col[new_colour]=entry;
}

int i_lookup_colourmap_colour(it_cmap *cmap,it_rgb *colour)
{
  it_cmap_entry *ptr;

  /* skip down the hash chain until the rgb values match */
  for(ptr=cmap->hash_col[colour_hash(colour)];ptr!=NULL;ptr=ptr->next_col)
    if(im_rgb_equal(colour,&(ptr->colour))) break;
  if(ptr==NULL) return(-1);

  /* return the index (pointer subtraction - don't need a sizeof) */
  return(ptr-cmap->cmap_list);
}

it_rgb *i_lookup_colourmap_index(it_cmap *cmap,int index)
{
  if(index<0 || index>=cmap->maxindex) return(NULL);
  return(&((cmap->cmap_list[index]).colour));
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
