/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgRepeat.c                                                   */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:55 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "Repeat"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  it_image *i1;
  int count,i;

  IFHELP
    {
      fprintf(stderr,"img%s - Produces a repeated sequence of each input image\n",
	      PRGNAME);
      fprintf(stderr,"img%s [times]\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Any\n");
      fprintf(stderr,"  stdout: Any\n");
      exit(0);
    }

  imgStart(PRGNAME);
  count=2;
  if(argc>2)
    ERROR("extra arguments encountered");
  if(argc>1)
    count=atoi(argv[1]);
  if(count<1)
    ERROR("bad arguments");

  do {
    i1=i_read_image_file(stdin,IT_ANY,IM_FRAGMENT);
    if(i1==NULL)
      ERROR("can't import image file");
    for(i=0;i<count;i++)
      i_write_image_file(stdout,i1,IF_BINARY);
    i_destroy_image(i1);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
