module CgiOut where

{-
HTTP Responses (last modified: Friday, March 07, 1997)

Erik Meijer (erik@cs.ruu.nl)
-}

import Common
import Mime

{-
The output of a CGI script is a HTTP response (part of, the server adds additional noise), which is either some MIME content, a redirection to some other location, or an error status.

We make CgiOut an instance of the Show class so that we don't have to worry about the exact format of the response that is required by the HTTP definition.

I think what we really want is to use an existential type here!

data CgiOut = Mime a => Content{content :: a}
            | ....

We are not interested in the content type, we only need to know it is in the Mime class.

What is missing is a table of (StatusCode,Reason)-pairs such as (503, "server busy") and (200, "Transaction ok") etc.
-}

type StatusCode = Int
type Reason = String

data Mime a => CgiOut a
 = Content{mime :: a}
 | Location{url :: URL}
 | Status{status :: StatusCode, reason :: Reason}

instance Mime a => Show (CgiOut a) where
   showsPrec _ Content{mime}
    = showString "Content-type: " . showString (mimeType mime)
    . showString "\n\n"
    . shows mime

   showsPrec _ Location{url}
    = showString "Location: " . showString url
    . showString "\n\n"

   showsPrec _ Status{status,reason}
    = showString "Status: "
    . shows status . showString " " . showString reason
    . showString "\n\n"
