module GraphicsTypes
	( Angle
	, Dimension, toDimension, fromDimension
	, Point,     toPoint,     fromPoint
	, RGB(RGB)
	, Picture
	) where

import qualified Win32
import Word( Word8 )  -- GHC extension

-- Hugs does not allow operators to have different fixities in 
-- different modules (this is a known deviation from Standard Haskell).
-- In consequence, we don't declare any fixities in any non-standard
-- library because it would prevent the programmer from using the same
-- operator name at a different fixity.
--
-- infixr 9 `over`

----------------------------------------------------------------
-- Units
----------------------------------------------------------------

type Angle     = Double

type Dimension = Int
type Point     = (Dimension,Dimension)

-- These functions are used when implementing Pictures
toPoint        :: Win32.POINT -> Point
fromPoint      :: Point -> Win32.POINT

toDimension    :: Win32.INT -> Dimension
fromDimension  :: Dimension -> Win32.INT

toPoint       (x,y) = (toDimension x, toDimension y)
fromPoint     (x,y) = (fromDimension x, fromDimension y)
toDimension   = toInt 
fromDimension = fromInt

---------------------------------------------------------------
-- Colors
----------------------------------------------------------------

data RGB = RGB Word8 Word8 Word8

----------------------------------------------------------------
-- Pictures
----------------------------------------------------------------

type Picture = Win32.HDC -> IO ()

----------------------------------------------------------------
