/*
 * Copyright(c) 1995-1998 by Gennady B. Sorokopud (gena@NetVision.net.il)
 *
 * This software can be freely redistributed and modified for 
 * non-commercial purposes as long as above copyright
 * message and this permission notice appear in all
 * copies of distributed source code and included as separate file
 * in binary distribution.
 *
 * Any commercial use of this software requires author's permission.
 *
 * This software is provided "as is" without expressed or implied
 * warranty of any kind.
 * Under no circumstances is the author responsible for the proper
 * functioning of this software, nor does the author assume any
 * responsibility for damages incurred with its use.
 *
 */

/* $Id: inc.c,v 2.12 1998/04/13 13:35:15 gena Exp $
 */

#include <fmail.h>
#include <umail.h>
#include <choose_folder.h>
#include "configform.h"

static FD_config_receive *inc_obj;
static FD_config_timers  *timers_obj;
static FD_acc_spool *spool_obj;
static int spoolready = 0;

/* list of sources to retrieve mail from */
struct _retrieve_src retrieve_srcs[MAX_RETR_SOURCES];

void spool_acc(struct _retrieve_src *source);
void pop_acc(struct _retrieve_src *source);
void imap_acc(struct _retrieve_src *source);
char *get_src_line(int src);
void display_sources();

void Inc_NSound_Call(FL_OBJECT *obj, long param)
{
 fl_deactivate_object(inc_obj->Inc_Play);
 fl_deactivate_object(inc_obj->Inc_Command);
}

void Inc_Beep_Call(FL_OBJECT *obj, long param)
{
 fl_deactivate_object(inc_obj->Inc_Play);
 fl_deactivate_object(inc_obj->Inc_Command);
}

void Inc_SFile_Call(FL_OBJECT *obj, long param)
{
 fl_activate_object(inc_obj->Inc_Play);
 fl_deactivate_object(inc_obj->Inc_Command);
 fl_set_focus_object(inc_obj->config_receive, inc_obj->Inc_Play);
}

void Inc_SCommand_Call(FL_OBJECT *obj, long param)
{
 fl_deactivate_object(inc_obj->Inc_Play);
 fl_activate_object(inc_obj->Inc_Command);
 fl_set_focus_object(inc_obj->config_receive, inc_obj->Inc_Command);
}

void Inc_Play_Call(FL_OBJECT *obj, long param)
{
 play_sound((char *)fl_get_input(obj), 100);
}

void Inc_Start_Call(FL_OBJECT *obj, long param)
{
}

void Inc_Lock_Call(FL_OBJECT *obj, long param)
{
 if (!fl_get_button(inc_obj->Inc_Dotlock) &&
	!fl_get_button(inc_obj->Inc_Kernelock))
	fl_show_alert("WARNING, no locking method selected!", "Accessing folder without locking", "can lead to folder corruption and data loss!!", 1);
}

int
get_selected_source()
{
int sline, i;

 if ((sline = fl_get_browser(inc_obj->Inc_Sources)) < 1)
	return -1;

 for (i = 0; i < MAX_RETR_SOURCES; i++)	{
  if (*retrieve_srcs[i].name == '\0')
	continue;

  if (--sline == 0)
	return i;
					}

 return -1;
}

void Inc_Add_Call(FL_OBJECT *obj, long param)
{
int i, k, src_pup;
char *srcname, *p;

 for (i = 0; i < MAX_RETR_SOURCES; i++)	{
  if (*retrieve_srcs[i].name == '\0')
	break;				}

 if (i == MAX_RETR_SOURCES) {
	display_msg(MSG_WARN, "add account", "You can not have more than %d accounts", MAX_RETR_SOURCES);
	return;		    }

 src_pup = fl_defpup(obj->form->window, "Account type%t|Spool|POP|IMAP");
 
 switch (fl_dopup(src_pup)) {
  case 1:
	retrieve_srcs[i].type = RSRC_SPOOL;
  break;
   
  case 2:
	retrieve_srcs[i].type = RSRC_POP;
  break;

  case 3:
	retrieve_srcs[i].type = RSRC_IMAP;
  break;

  default:
	fl_freepup(src_pup);
	return;
  break;
                           }
 fl_freepup(src_pup);

 srcname=(char *)fl_show_input("Account name:", "");
 if (!srcname || !*srcname) 
        return;
 
 if (strlen(srcname) > 10)  {
        display_msg(MSG_WARN, "add account", "account name too long (should be 1-10 characters)");
        return;		    }

 for (p = srcname; *p; p++)	{
  if (!isalpha(*p) && !isdigit(*p))	{
	display_msg(MSG_WARN, "add account", "Invalid character in account name (only letters and digits are allowed)");
	return;				}
				}

 for (k = 0; k < MAX_RETR_SOURCES; k++)	{
  if (!strcasecmp(srcname, retrieve_srcs[k].name)) {
	display_msg(MSG_WARN, "add account", "account %s already exists", srcname);
	return;					   }
					}

 strcpy(retrieve_srcs[i].name, srcname);
 retrieve_srcs[i].flags = 0;
 retrieve_srcs[i].spec = NULL;
 switch (retrieve_srcs[i].type) {
  case RSRC_SPOOL:
	spool_source(&retrieve_srcs[i]);
  break;

  case RSRC_POP:
	pop_source(&retrieve_srcs[i]);
  break;

  case RSRC_IMAP:
	imap_source(&retrieve_srcs[i]);
	set_menu_imap();
  break;
				}

 fl_addto_browser(inc_obj->Inc_Sources, get_src_line(i));
 fl_select_browser_line(inc_obj->Inc_Sources,
	fl_get_browser_maxline(inc_obj->Inc_Sources));
 Inc_Edit_Call(obj, param);

 return;
}

void Inc_Delete_Call(FL_OBJECT *obj, long param)
{
struct _imap_src *imap;
int i = get_selected_source();

 if (i < 0)
	return;

 if (retrieve_srcs[i].type == RSRC_IMAP) {
   imap = (struct _imap_src *)retrieve_srcs[i].spec;
   if (imap_isconnected(imap))	{
	display_msg(MSG_WARN, "delete account", "IMAP connection to %s is established\ncan not delete account", imap->hostname);
	return;			}
					 }

 *retrieve_srcs[i].name = '\0';
 display_sources();
 if (retrieve_srcs[i].type == RSRC_IMAP)
	set_menu_imap();

 return;
}

void Inc_Edit_Call(FL_OBJECT *obj, long param)
{
int i = get_selected_source();
struct _imap_src *imap;

 if (i < 0)
	return;

 fl_deactivate_object(inc_obj->Inc_Add);
 fl_deactivate_object(inc_obj->Inc_Delete);
 fl_deactivate_object(inc_obj->Inc_Edit);
 switch (retrieve_srcs[i].type)	{
  case RSRC_SPOOL:
	spool_acc(&retrieve_srcs[i]);
  break;

  case RSRC_POP:
	pop_acc(&retrieve_srcs[i]);
  break;

  case RSRC_IMAP:
	imap = (struct _imap_src *)retrieve_srcs[i].spec;
	if (imap_isconnected(imap))	{
		display_msg(MSG_WARN, "edit account", "IMAP connection to %s is established\ncan not edit account", imap->hostname);
		break;			}
	imap_acc(&retrieve_srcs[i]);
  break;
				}
 fl_activate_object(inc_obj->Inc_Add);
 fl_activate_object(inc_obj->Inc_Delete);
 fl_activate_object(inc_obj->Inc_Edit);

 fl_replace_browser_line(inc_obj->Inc_Sources,
	fl_get_browser(inc_obj->Inc_Sources), get_src_line(i));
 return;
}

void Inc_Src_Call(FL_OBJECT *obj, long param)
{
int i = get_selected_source();

 if (i < 0)
	return;

 if (fl_mouse_button() == FL_MIDDLE_MOUSE)	{
	Inc_Edit_Call(obj, param);
	return;					}

 fl_set_button(inc_obj->Inc_Disabled,
	(retrieve_srcs[i].flags & RSRC_DISABLED) ? 1 : 0);
 fl_set_button(inc_obj->Inc_Markread,
	(retrieve_srcs[i].flags & RSRC_MARKREAD) ? 1 : 0);
 fl_set_button(inc_obj->Inc_DNotify,
	(retrieve_srcs[i].flags & RSRC_NONOTIFY) ? 1 : 0);
 fl_set_button(inc_obj->Inc_SAddr,
	(retrieve_srcs[i].flags & RSRC_SAVEADDR) ? 1 : 0);
 fl_set_button(inc_obj->Inc_Notimer,
	(retrieve_srcs[i].flags & RSRC_NOTIMER) ? 1 : 0);

 return;
}

void Inc_Disabled_Call(FL_OBJECT *obj, long param)
{
int i = get_selected_source();

 if (i < 0)
	return;

 if (fl_get_button(obj))
	retrieve_srcs[i].flags |= RSRC_DISABLED;
 else
	retrieve_srcs[i].flags &= ~RSRC_DISABLED;
}

void Inc_Markread_Call(FL_OBJECT *obj, long param)
{
int i = get_selected_source();

 if (i < 0)
	return;

 if (fl_get_button(obj))
	retrieve_srcs[i].flags |= RSRC_MARKREAD;
 else
	retrieve_srcs[i].flags &= ~RSRC_MARKREAD;
}

void Inc_DNotify_Call(FL_OBJECT *obj, long param)
{
int i = get_selected_source();

 if (i < 0)
	return;

 if (fl_get_button(obj))
	retrieve_srcs[i].flags |= RSRC_NONOTIFY;
 else
	retrieve_srcs[i].flags &= ~RSRC_NONOTIFY;
}

void Inc_SAddr_Call(FL_OBJECT *obj, long param)
{
int i = get_selected_source();

 if (i < 0)
	return;

 if (fl_get_button(obj))
	retrieve_srcs[i].flags |= RSRC_SAVEADDR;
 else
	retrieve_srcs[i].flags &= ~RSRC_SAVEADDR;
}

void Inc_Notimer_Call(FL_OBJECT *obj, long param)
{
int i = get_selected_source();

 if (i < 0)
	return;

 if (fl_get_button(obj))
	retrieve_srcs[i].flags |= RSRC_NOTIMER;
 else
	retrieve_srcs[i].flags &= ~RSRC_NOTIMER;
}

char *
get_src_line(src)
int src;
{
static char srcline[96];
struct _spool_src *spool;
struct _pop_src *pop;
struct _imap_src *imap;

 switch (retrieve_srcs[src].type) {
   case RSRC_SPOOL:
	spool = (struct _spool_src *)retrieve_srcs[src].spec;
	snprintf(srcline, sizeof(srcline), "%s [%s]", retrieve_srcs[src].name, spool->path);
   break;

   case RSRC_POP:
	pop = (struct _pop_src *)retrieve_srcs[src].spec;
	snprintf(srcline, sizeof(srcline), "%s [%s/%s %s]", retrieve_srcs[src].name,
		pop->hostname, pop->service, pop->username);
   break;

   case RSRC_IMAP:
	imap = (struct _imap_src *)retrieve_srcs[src].spec;
	snprintf(srcline, sizeof(srcline), "%s [%s/%s %s]", retrieve_srcs[src].name,
		imap->hostname, imap->service, imap->username);
   break;

   default:
	strcpy(srcline, retrieve_srcs[src].name);
   break;
				 }
 return srcline;
}

void
display_sources()
{
int i, bset = 0;

 fl_freeze_form(inc_obj->config_receive);
 fl_set_button(inc_obj->Inc_Disabled, 0);
 fl_set_button(inc_obj->Inc_Markread, 0);
 fl_set_button(inc_obj->Inc_DNotify, 0);
 fl_set_button(inc_obj->Inc_SAddr, 0);
 fl_set_button(inc_obj->Inc_Notimer, 0);
 fl_clear_browser(inc_obj->Inc_Sources);
 for (i = 0; i < MAX_RETR_SOURCES; i++)	{
  if (*retrieve_srcs[i].name == '\0')
	continue;

  fl_add_browser_line(inc_obj->Inc_Sources, get_src_line(i));
  if (!bset)	{
   fl_set_button(inc_obj->Inc_Disabled,
	(retrieve_srcs[i].flags & RSRC_DISABLED) ? 1 : 0);
   fl_set_button(inc_obj->Inc_Markread,
	(retrieve_srcs[i].flags & RSRC_MARKREAD) ? 1 : 0);
   fl_set_button(inc_obj->Inc_DNotify,
	(retrieve_srcs[i].flags & RSRC_NONOTIFY) ? 1 : 0);
   fl_set_button(inc_obj->Inc_SAddr,
	(retrieve_srcs[i].flags & RSRC_SAVEADDR) ? 1 : 0);
   fl_set_button(inc_obj->Inc_Notimer,
	(retrieve_srcs[i].flags & RSRC_NOTIMER) ? 1 : 0);
   bset = 1;
		}
					}


 fl_select_browser_line(inc_obj->Inc_Sources, 1);
 fl_unfreeze_form(inc_obj->config_receive);

 return;
}

void
inc_conf(int set_default, FD_config_receive *form) 
{

 inc_obj = form;
 display_sources();

 fl_set_button(inc_obj->Inc_Start, b_getcfg_int_default(conf_name,"inconstart", 0, set_default));
 fl_set_button(inc_obj->Inc_Show, b_getcfg_int_default(conf_name,"incresults",1, set_default));

 if (locking & MBOX_DOT_LOCK)
	fl_set_button(inc_obj->Inc_Dotlock, 1);
 else
	fl_set_button(inc_obj->Inc_Dotlock, 0);
 if (locking & MBOX_KERNEL_LOCK)
	fl_set_button(inc_obj->Inc_Kernelock, 1);
 else
	fl_set_button(inc_obj->Inc_Kernelock, 0);

 switch(b_getcfg_int_default(conf_name,"beep", 1, set_default)) {
  case 0:
	fl_set_button(inc_obj->Inc_NSound, 1);
	fl_set_button(inc_obj->Inc_Beep, 0);
	fl_set_button(inc_obj->Inc_SFile, 0);
	fl_set_button(inc_obj->Inc_SCommand, 0);
	fl_deactivate_object(inc_obj->Inc_Play);
	fl_deactivate_object(inc_obj->Inc_Command);
  break;

  case 1:
	fl_set_button(inc_obj->Inc_NSound, 0);
	fl_set_button(inc_obj->Inc_Beep, 1);
	fl_set_button(inc_obj->Inc_SFile, 0);
	fl_set_button(inc_obj->Inc_SCommand, 0);
	fl_deactivate_object(inc_obj->Inc_Play);
	fl_deactivate_object(inc_obj->Inc_Command);
  break;

  case 2:
	fl_set_button(inc_obj->Inc_NSound, 0);
	fl_set_button(inc_obj->Inc_Beep, 0);
	fl_set_button(inc_obj->Inc_SFile, 1);
	fl_set_button(inc_obj->Inc_SCommand, 0);
	fl_activate_object(inc_obj->Inc_Play);
	fl_deactivate_object(inc_obj->Inc_Command);
	fl_set_input(inc_obj->Inc_Play, b_getcfg_str_default(conf_name, "play", "", set_default));
  break;

  case 3:
	fl_set_button(inc_obj->Inc_NSound, 0);
	fl_set_button(inc_obj->Inc_Beep, 0);
	fl_set_button(inc_obj->Inc_SFile, 0);
	fl_set_button(inc_obj->Inc_SCommand, 1);
	fl_deactivate_object(inc_obj->Inc_Play);
	fl_activate_object(inc_obj->Inc_Command);
	fl_set_input(inc_obj->Inc_Command, b_getcfg_str_default(conf_name, "play", "", set_default));
  break;

  default:
	fl_set_button(inc_obj->Inc_NSound, 1);
	fl_set_button(inc_obj->Inc_Beep, 0);
	fl_set_button(inc_obj->Inc_SFile, 0);
	fl_set_button(inc_obj->Inc_SCommand, 0);
	fl_deactivate_object(inc_obj->Inc_Play);
	fl_deactivate_object(inc_obj->Inc_Command);
  break;
					  }
}

void Inc_Icon_Call(FL_OBJECT *obj, long param)
{
}

void Inc_Count_Call(FL_OBJECT *obj, long param)
{
}

void
handle_inc_input(FD_config_receive *form)
{

 inc_obj = form;

 save_sources(NULL);

 b_putcfg_int(conf_name, "inconstart", fl_get_button(inc_obj->Inc_Start));
 b_putcfg_int(conf_name, "incresults", fl_get_button(inc_obj->Inc_Show));

 locking = 0;
 if (fl_get_button(inc_obj->Inc_Kernelock))
	locking |= MBOX_KERNEL_LOCK;
 if (fl_get_button(inc_obj->Inc_Dotlock))
	locking |= MBOX_DOT_LOCK;
 b_putcfg_int(conf_name, "spoolock", locking);

 if (fl_get_button(inc_obj->Inc_NSound))
	b_putcfg_int(conf_name, "beep", 0);
 else
 if (fl_get_button(inc_obj->Inc_Beep))
	b_putcfg_int(conf_name, "beep", 1);
 else
 if (fl_get_button(inc_obj->Inc_SFile))     {
	b_putcfg_int(conf_name, "beep", 2);
	b_putcfg_str(conf_name, "play", (char *)fl_get_input(inc_obj->Inc_Play));
					    }
 else
 if (fl_get_button(inc_obj->Inc_SCommand))  {
	b_putcfg_int(conf_name, "beep", 3);
	b_putcfg_str(conf_name, "play", (char *)fl_get_input(inc_obj->Inc_Command));
					    }
 else
	b_putcfg_int(conf_name, "beep", 0);

 return;         
}

void
timers_conf(int set_default, FD_config_timers *form)
{
 timers_obj = form;

 fl_set_counter_bounds(timers_obj->Inc_Count, 0, 120);
 fl_set_counter_precision(timers_obj->Inc_Count, 2);
 fl_set_counter_step(timers_obj->Inc_Count, 0.25, 5);
 fl_set_counter_value(timers_obj->Inc_Count, (double)((double)b_getcfg_int_default(conf_name,"inctime",180, set_default)/(double)60));

 fl_set_counter_bounds(timers_obj->Inc_Send, 0, 60);
 fl_set_counter_precision(timers_obj->Inc_Send, 1);
 fl_set_counter_step(timers_obj->Inc_Send, 0.5, 5);
 fl_set_counter_value(timers_obj->Inc_Send, (double)((double)b_getcfg_int_default(conf_name,"sendtime",0, set_default)/(double)60));

 fl_set_counter_bounds(timers_obj->Timer_Trash, 0, 48);
 fl_set_counter_precision(timers_obj->Timer_Trash, 1);
 fl_set_counter_step(timers_obj->Timer_Trash, 0.5, 5);
 fl_set_counter_value(timers_obj->Timer_Trash, (double)((double)b_getcfg_int_default(conf_name,"trashtime",0, set_default)/(double)60));

 fl_set_counter_bounds(timers_obj->Timer_Autosave, 0, 60);
 fl_set_counter_precision(timers_obj->Timer_Autosave, 1);
 fl_set_counter_step(timers_obj->Timer_Autosave, 0.5, 5);
 fl_set_counter_value(timers_obj->Timer_Autosave, (double)((double)b_getcfg_int_default(conf_name,"asavetime",180, set_default)/(double)60));

 fl_set_counter_bounds(timers_obj->Timer_IMAP, 0, 120);
 fl_set_counter_precision(timers_obj->Timer_IMAP, 2);
 fl_set_counter_step(timers_obj->Timer_IMAP, 0.25, 5);
 fl_set_counter_value(timers_obj->Timer_IMAP, (double)((double)b_getcfg_int_default(conf_name,"imaptime",600, set_default)/(double)60));

 fl_set_counter_bounds(timers_obj->Timer_PGP, 0, PGP_MAX_TIMER);
 fl_set_counter_precision(timers_obj->Timer_PGP, 0);
 fl_set_counter_step(timers_obj->Timer_PGP, 1, 5);
 fl_set_counter_value(timers_obj->Timer_PGP, (double)b_getcfg_int_default(conf_name, "pgptimer", 120, set_default));

 fl_set_counter_bounds(timers_obj->Timer_Preview, 0, PREVIEW_MAX_TIMER);
 fl_set_counter_precision(timers_obj->Timer_Preview, 0);
 fl_set_counter_step(timers_obj->Timer_Preview, 1, 5);
 fl_set_counter_value(timers_obj->Timer_Preview, (double)b_getcfg_int_default(conf_name,"previewtime", 0, set_default));

 fl_set_button(timers_obj->Inc_Icon, b_getcfg_int_default(conf_name,"incwhenicon", 1, set_default));
}

void
handle_timers_input(FD_config_timers *form)
{
int i;
 timers_obj = form;
 b_putcfg_int(conf_name, "inctime", (int)(fl_get_counter_value(timers_obj->Inc_Count) * 60));
 b_putcfg_int(conf_name, "sendtime", (int)(fl_get_counter_value(timers_obj->Inc_Send) * 60));
 b_putcfg_int(conf_name, "trashtime", (int)(fl_get_counter_value(timers_obj->Timer_Trash) * 60));
 b_putcfg_int(conf_name, "asavetime", (int)(fl_get_counter_value(timers_obj->Timer_Autosave) * 60));
 b_putcfg_int(conf_name, "imaptime", (int)(fl_get_counter_value(timers_obj->Timer_IMAP) * 60));
 b_putcfg_int(conf_name, "pgptimer", (int)fl_get_counter_value(timers_obj->Timer_PGP));
 b_putcfg_int(conf_name, "previewtime", (int)fl_get_counter_value(timers_obj->Timer_Preview));

 fl_set_timer(inc_timer, b_getcfg_int(conf_name,"inctime",180));

 i = b_getcfg_int(conf_name,"sendtime",0);
 if (i)
	i++;
 fl_set_timer(send_timer, i);

 i = b_getcfg_int(conf_name,"trashtime",0);
 if (i)
	i += 2;
 fl_set_timer(trash_timer, i);

 if (asave_timer) {
  i = b_getcfg_int(conf_name,"asavetime",0);
  if (i)
	i += 3;
  fl_set_timer(asave_timer, i);
		  }

 b_putcfg_int(conf_name, "incwhenicon", fl_get_button(timers_obj->Inc_Icon));

 return;         
}

void
init_sources()
{
int i;

 for (i = 0; i < MAX_RETR_SOURCES; i++)	{
  *retrieve_srcs[i].name = '\0';
  retrieve_srcs[i].flags = RSRC_DISABLED;
  retrieve_srcs[i].type = 0;
  retrieve_srcs[i].spec = NULL;
  retrieve_srcs[i].retrieve = NULL;
  retrieve_srcs[i].free = NULL;
  retrieve_srcs[i].init = NULL;
  retrieve_srcs[i].load = NULL;
  retrieve_srcs[i].save = NULL;
					}

 return;
}

int
load_sources()
{
FILE *sfd;
char srcfile[255], buf[255];
int loaded = 0;

 init_sources();

 snprintf(srcfile, sizeof(srcfile), "%s/.xfmsources", configdir);
 if ((sfd = fopen(srcfile, "r")) == NULL)	{
	display_msg(MSG_LOG, "load sources", "WARNING: no retrieve sources/accounts defined");
	return 0;				}

 while (fgets(buf, 254, sfd))	{
  if (*buf != '@')
	continue;

  strip_newline(buf);
  if (sscanf(buf, "@ %d%d%31s", &retrieve_srcs[loaded].flags,
	&retrieve_srcs[loaded].type, retrieve_srcs[loaded].name) != 3)	{
	display_msg(MSG_WARN, "load sources", "Invalid line in %s\nignoring", srcfile);
	*retrieve_srcs[loaded].name = '\0';
	continue;							}

  switch (retrieve_srcs[loaded].type)	{
   default:
   case RSRC_SPOOL:
	spool_source(&retrieve_srcs[loaded]);
   break;

   case RSRC_POP:
	pop_source(&retrieve_srcs[loaded]);
   break;

   case RSRC_IMAP:
	imap_source(&retrieve_srcs[loaded]);
   break;
					}

   if ((retrieve_srcs[loaded].load)(&retrieve_srcs[loaded], sfd) != 0)	{
	display_msg(MSG_WARN, "load sources", "Failed to load source '%s'",
		retrieve_srcs[loaded].name);
	*retrieve_srcs[loaded].name = '\0';
	continue;						  	}

   loaded++;
				}

 fclose(sfd);

 if (loaded == 0)
	display_msg(MSG_LOG, "load sources", "WARNING: no retrieve sources/accounts defined");

 return loaded;
}

int
save_sources(tmpf)
char *tmpf;
{
FILE *sfd;
char tmpfile[255], srcfile[255];
int i, oflags = 0;

 if (readonly)
	return 0;

 if (tmpf)
	strcpy(tmpfile, tmpf);
 else
	snprintf(tmpfile, sizeof(tmpfile), "%s/.xfmsources__sve", configdir);
 snprintf(srcfile, sizeof(srcfile), "%s/.xfmsources", configdir);
 if ((sfd = fopen(tmpfile, "w")) == NULL) {
	display_msg(MSG_WARN, "save sources", "Can not open %s", tmpfile);
	return -1;			  }

 for (i = 0; i < MAX_RETR_SOURCES; i++)	{
  if (*retrieve_srcs[i].name == '\0')
	continue;
  fprintf(sfd, "@ %d %d %s\n", retrieve_srcs[i].flags, retrieve_srcs[i].type,
	retrieve_srcs[i].name);
  if (tmpf)	{
   switch (retrieve_srcs[i].type)	{
    case RSRC_POP:
	oflags = ((struct _pop_src *)retrieve_srcs[i].spec)->flags;
	((struct _pop_src *)retrieve_srcs[i].spec)->flags &= ~PSRC_STOREPWD;
    break;

    case RSRC_IMAP:
	oflags = ((struct _imap_src *)retrieve_srcs[i].spec)->flags;
	((struct _imap_src *)retrieve_srcs[i].spec)->flags &= ~ISRC_STOREPWD;
    break;
					}
		}
  (retrieve_srcs[i].save)(&retrieve_srcs[i], sfd);
  if (tmpf)	{
   switch (retrieve_srcs[i].type)	{
    case RSRC_POP:
	((struct _pop_src *)retrieve_srcs[i].spec)->flags = oflags;
    break;

    case RSRC_IMAP:
	((struct _imap_src *)retrieve_srcs[i].spec)->flags = oflags;
    break;
					}
		}
					}

 fclose(sfd);

 if (tmpf)
	return 0;
 if (rename(tmpfile, srcfile) == -1)	{
	display_msg(MSG_WARN, "save sources", "Can not rename %s to\n%s",
		tmpfile, srcfile);
	return -1;			}
 return 0;
}

void Spool_Call(FL_OBJECT *obj, long param)
{
}

struct _retrieve_src *
get_src_by_name(name)
char *name;
{
int i;

 if (!name || !*name)
	return NULL;

 for (i = 0; i < MAX_RETR_SOURCES; i++)	{
  if (!strcasecmp(retrieve_srcs[i].name, name))
	return &retrieve_srcs[i];
					}

 return NULL;
}

struct _spool_src *
get_spoolsrc_by_name(name)
char *name;
{
struct _retrieve_src *source;

 if (((source = get_src_by_name(name)) == NULL) ||
	(source->type != RSRC_SPOOL))
	return NULL;

 return (struct _spool_src *)source->spec;
}

struct _pop_src *
get_popsrc_by_name(name)
char *name;
{
struct _retrieve_src *source;

 if (((source = get_src_by_name(name)) == NULL) ||
	(source->type != RSRC_POP))
	return NULL;

 return (struct _pop_src *)source->spec;
}

struct _imap_src *
get_imapsrc_by_name(name)
char *name;
{
struct _retrieve_src *source;

 if (((source = get_src_by_name(name)) == NULL) ||
	(source->type != RSRC_IMAP))
	return NULL;

 return (struct _imap_src *)source->spec;
}

struct _retrieve_src *
get_msg_src(msg)
struct _mail_msg *msg;
{
struct _head_field *fld;

 if ((fld = find_field(msg, SOURCE_FIELD)) == NULL)
	return NULL;

 return get_src_by_name(fld->f_line);
}

struct _spool_src *
get_msg_spoolsrc(msg)
struct _mail_msg *msg;
{
struct _retrieve_src *source;

 if (((source = get_msg_src(msg)) == NULL) ||
	(source->type != RSRC_SPOOL))
	return NULL;

 return (struct _spool_src *)source->spec;
}

struct _pop_src *
get_msg_popsrc(msg)
struct _mail_msg *msg;
{
struct _retrieve_src *source;

 if (((source = get_msg_src(msg)) == NULL) ||
	(source->type != RSRC_POP))
	return NULL;

 return (struct _pop_src *)source->spec;
}

struct _imap_src *
get_msg_imapsrc(msg)
struct _mail_msg *msg;
{
struct _retrieve_src *source;

 if (((source = get_msg_src(msg)) == NULL) ||
	(source->type != RSRC_IMAP))
	return NULL;

 return (struct _imap_src *)source->spec;
}

void
spool_acc(source)
struct _retrieve_src *source;
{
struct _spool_src *spool;
struct _mail_folder *ifold;
char buf[64];
 
 spool = (struct _spool_src *)source->spec;
 if (spoolready)
	return;
 spoolready = 1;

 spool_obj = create_form_acc_spool();
 fl_set_input(spool_obj->Spool_Path, spool->path);
 fl_set_button(spool_obj->Spool_Leave, (spool->flags & SSRC_TRUNCATE) ? 0 : 1);
 fl_set_button(spool_obj->Spool_Rewrite, (spool->flags & SSRC_REWRITE) ? 1 : 0);

 fl_show_form(spool_obj->acc_spool, FL_PLACE_CENTER, FL_TRANSIENT, "Spool mailbox");
spoolenter:
 fl_do_only_forms();

 strcpy(spool->path, fl_get_input(spool_obj->Spool_Path));
 spool->flags = 0;
 if (!fl_get_button(spool_obj->Spool_Leave))
	spool->flags |= SSRC_TRUNCATE;
 if (fl_get_button(spool_obj->Spool_Rewrite))
	spool->flags |= SSRC_REWRITE;

 if ((ifold = get_mbox_folder_by_path(spool->path)) == NULL) {
   if ((ifold = create_mbox_folder(NULL, spool->path)) == NULL) {
        display_msg(MSG_WARN, "spool", "Can not access %s", spool->path);
        goto spoolenter;                                        }
                                                             }
 ifold->status |= (FRESCAN|SYSTEM|NOINFR|FNOCLSE);
 ifold->status &= ~FSHORTH;
 if (!(spool->flags & SSRC_REWRITE))
        ifold->status |= FNOMOD;
 else
        ifold->status &= ~FNOMOD;

 if (ifold->sname)          {
        snprintf(buf, sizeof(buf), "%s (spool)", get_folder_short_name(ifold));
        free(ifold->sname); }
 else
        sprintf(buf, "spool");
 ifold->sname = strdup(buf);
 if (!ifold->descr)
        ifold->descr = strdup("spool mailbox");
 ifold->open(ifold, FOPEN_NOCACHE);
 sort_folders();
 redraw_fld_win();

 fl_hide_form(spool_obj->acc_spool);
 fl_free_form(spool_obj->acc_spool);
 fl_free(spool_obj);
 spool_obj = NULL;

 spoolready = 0;
 return;
}

