.TH arhnk 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
arhnk - Hankel norm approximant
.SH CALLING SEQUENCE
.nf
[slm]=arhnk(sl,ord,[tol])   
.fi
.SH PARAMETERS
.TP
sl
: linear system (\fVsyslin\fR list)
.TP
ord 
: integer, order of the approximant
.TP
tol 
: threshold for rank determination in \fVequil1\fR
.SH DESCRIPTION
computes \fVslm\fR, the optimal Hankel norm approximant of the 
stable continuous-time linear system \fVsl\fR with matrices \fV[A,B,C,D]\fR.
.SH EXAMPLE
.nf
A=diag([-1,-2,-3,-4,-5]);B=rand(5,1);C=rand(1,5);
sl=syslin('c',A,B,C);
slapprox=arhnk(sl,2);
[nk,W]=hankelsv(sl);nk
[nkred,Wred]=hankelsv(slapprox);nkred
.fi
.SH SEE ALSO 
equil, equil1, hankelsv

