.TH cdfchn 1 "Dec 1997" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
cdfchn - cumulative distribution function  non-central chi-square distribution 
.SH CALLING SEQUENCE
.nf
[P,Q]=cdfchn("PQ",X,Df,Pnonc)
[X]=cdfchn("X",Df,Pnonc,P,Q);
[Df]=cdfchn("Df",Pnonc,P,Q,X)
[Pnonc]=cdfchn("Pnonc",P,Q,X,Df)
.fi 
.SH PARAMETERS
.TP 10
P,Q,X,Df,Pnonc
: five real vectors of the same size.
.TP
P,Q (Q=1-P)
:  The integral from 0 to X of the non-central chi-square
distribution.
Input range: [0, 1-1E-16).
.TP
X 
: Upper limit of integration of the non-central chi-square distribution.
Input range: [0, +infinity).
Search range: [0,1E300]
.TP
Df
: Degrees of freedom of the non-central
chi-square distribution.
Input range: (0, +infinity).
Search range: [ 1E-300, 1E300]
.TP
Pnonc
:  Non-centrality parameter of the non-central
chi-square distribution.
Input range: [0, +infinity).
Search range: [0,1E4]
.SH DESCRIPTION
Calculates any one parameter of the non-central chi-square
distribution given values for the others.
.LP
Formula  26.4.25   of   Abramowitz   and   Stegun,  Handbook  of
Mathematical  Functions (1966) is used to compute the cumulative
distribution function.
.LP
Computation of other parameters involve a seach for a value that
produces  the desired  value  of P.   The search relies  on  the
monotinicity of P with the other parameter.
.LP
The computation time  required for this  routine is proportional
to the noncentrality  parameter  (PNONC).  Very large  values of
this parameter can consume immense  computer resources.  This is
why the search range is bounded by 10,000.
.LP
From DCDFLIB: Library of Fortran Routines for Cumulative Distribution
Functions, Inverses, and Other Parameters (February, 1994)
Barry W. Brown, James Lovato and Kathy Russell. The University of
Texas.
