.TH xpoly 2 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
xpoly - draw a single polyline
.SH CALLING SEQUENCE
.nf
[]=xpoly(xv,yv,dtype[,close])
.fi
.SH PARAMETERS 
.TP 15
xv, yv 
: two matrices of the same size (p,n)  (points of the polyline) 
.TP
dtype
: string (drawing style)
.TP
close
: if close = 1, the polyline is closed. (default value is 0)
.SH DESCRIPTION
draws a single polyline described by \fV(xv,yv)\fR. If \fVxv\fR and \fVyv\fR are matrices 
they are internally considered as a vector using the Fortran internal storage convention.
\fVdtype\fR can be \fV"lines"\fR for using the current line style or \fV"marks"\fR for using 
the current mark to draw the polyline.
.SH EXAMPLE
.nf 
x=sin(2*%pi*(0:5)/5);
y=cos(2*%pi*(0:5)/5);
plot2d(0,0,-1,"010"," ",[-2,-2,2,2])
xset("dashes",5);
xpoly(x,y,"lines",1);
xset("default");
.fi
.SH SEE ALSO 
xpolys
.SH AUTHOR
J.Ph.C. 



