.TH lu G "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
lu - LU factors of Gaussian elimination
.SH CALLING SEQUENCE
.nf
[L,U]= lu(A)
[L,U,E]= lu(A)
.fi
.SH PARAMETERS
.TP
A 
: real or complex square matrix (n x n).
.TP 8
L,U
: two real or complex matrices  (n x n).
.TP
E
: a (n x n) permutation matrix.
.SH DESCRIPTION
.Vb [L,U]= lu(A)
produces two matrices \fVL\fR and \fVU\fR such that \fVA = L*U\fR
with \fVU\fR upper triangular and \fVE*L\fR  lower triangular for 
a permutation matrix E. 

If \fVA\fR has rank \fVk\fR, rows \fVk+1\fR to \fVn\fR of \fVU\fR are
zero.

.Vb [L,U,E]= lu(A)
produces three matrices \fVL\fR, \fVU\fR and \fVE\fR such that \fVE*A = L*U\fR
with \fVU\fR upper triangular and \fVE*L\fR  lower triangular for 
a permutation matrix \fVE\fR. 

.SH REMARK

If \fVA\fR is a real matrix, using the function \fVlufact\fR and
\frluget\fR it is possible to obtain the permutation matrices and also
when \fVA\fR is not full rank the column compression of the matrix
\fVL\fR.

.nf 
[h,rk]=lufact(sparse(a))  // lufact works with sparse real matrices 
[P,L,U,Q]=luget(h)
ludel(h)
P=full(P);L=full(L);U=full(U);Q=full(Q); 
// P,Q are permutation matrices P*L*U*Q=A 
.fi 
.SH SEE ALSO
lufact, luget, lusolve, qr, svd

