.TH min_qcost_flow 1 "September 1995" "Scilab Group" "Scilab function"
.so ../sci.an
.SH NAME
min_qcost_flow - minimum quadratic cost flow
.SH CALLING SEQUENCE
.nf
[c,phi,flag] = min_qcost_flow(eps,g)
.fi
.SH PARAMETERS
.TP 4
eps
: scalar, precision
.TP 2
g
: graph list
.TP 2
c 
: value of cost
.TP 4
phi
: row vector of the value of flow on the arcs
.TP 5
flag
: feasible problem flag (0 or 1)
.SH DESCRIPTION
\fVmin_qcost_flow\fR computes the minimum quadratic cost flow in the network 
\fVg\fR. It returns the total cost of the flows on the arcs \fVc\fR and
the row vector of the flows on the arcs \fVphi\fR. \fVeps\fR is the precision
of the iterative algorithm. If the problem is not feasible (impossible to 
find a compatible flow for instance), \fVflag\fR is equal to 0, otherwise it 
is equal to 1.

The bounds of the flow are given by the elements \fVedge_min_cap\fR and
\fVedge_max_cap\fR of the graph list. 
The value of the maximum capacity must be greater than or equal to the 
value of the minimum capacity.
If the value of \fVedge_min_cap\fR or \fVedge_max_cap\fR is not given (empty
row vector \fV[]\fR), it is assumed to be equal to 0 on each edge.

The costs on the edges are given by the elements \fVedge_q_orig\fR and
\fVedge_q_weight\fR of the graph list. The cost on arc \fVu\fR is given by:

\fV(1/2)*edge_q_weight[u](phi[u]-edge_q_orig[u])^2\fR

The costs must be non negative.
If the value of \fVedge_q_orig\fR or \fVedge_q_weight\fR is not given (empty 
row vector \fV[]\fR), it is assumed to be equal to 0 on each edge.

This function uses an algorithm due to M. Minoux.
.SH EXAMPLE
.nf
ta=[1 1 2 2 2 3 4 4 5 6 6 6 7 7 7 8 9 10 12 12 13 13 13 14 15 14 9 11 10 1 8];
he=[2 6 3 4 5 1 3 5 1 7 10 11 5 8 9 5 8 11 10 11 9 11 15 13 14 4 6 9 1 12 14];
g=make_graph('foo',1,15,ta,he);
g('node_x')=[194 191 106 194 296 305 305 418 422 432 552 550 549 416 548];
g('node_y')=[56 221 316 318 316 143 214 321 217 126 215 80 330 437 439];
show_graph(g);
g1=g; ma=arc_number(g1);
rand('uniform');
while %T then
  g1('edge_min_cap')=round(5*rand(1,ma));
  g1('edge_max_cap')=round(20*rand(1,ma))+30*ones(1,ma);
  g1('edge_q_orig')=0*ones(1,ma);
  g1('edge_q_weight')=ones(1,ma);
  [c,phi,flag]=min_qcost_flow(0.001,g1);
 if flag==1 then break; end;
end;
x_message(['The cost is: '+string(c);
          'Showing the flow on the arcs']);
ii=find(phi<>0); edgecolor=phi; edgecolor(ii)=11*ones(ii);
g1('edge_color')=edgecolor;
edgefontsize=8*ones(1,ma); edgefontsize(ii)=18*ones(ii);
g1('edge_font_size')=edgefontsize;
g1('edge_label')=string(phi);
show_graph(g1);
.fi
.SH SEE ALSO
min_lcost_cflow, min_lcost_flow1, min_lcost_flow2
