.TH nodes_degrees 1 "September 1996" "Scilab Group" "Scilab function"
.so ../sci.an
.SH NAME
nodes_degrees - degrees of the nodes of a graph
.SH CALLING SEQUENCE
.nf
[outdegree,indegree] = graph_degree(g)
.fi
.SH PARAMETERS
.TP 2
g
: graph list
.TP 10
outdegree
: row vector of the out degrees of the nodes
.TP 9
indegree
: row vector of the in degrees of the nodes
.SH DESCRIPTION
\fVnodes_degrees\fR returns the 2 row vectors of the out and in degrees of the 
nodes of the graph \fVg\fR.
.SH EXAMPLE
.nf
ta=[1 1 2 2 2 3 4 5 5 7 8 8 9 10 10 10 11 12 13 13 13 14 15 16 16 17 17];
he=[2 10 3 5 7 4 2 4 6 8 6 9 7 7 11 15 12 13 9 10 14 11 16 1 17 14 15];
g=make_graph('foo',1,17,ta,he);
g('node_x')=[283 163 63 57 164 164 273 271 339 384 504 513 439 623 631 757 642];
g('node_y')=[59 133 223 318 227 319 221 324 432 141 209 319 428 443 187 151 301];
show_graph(g);
[outdegree,indegree]=nodes_degrees(g)
.fi
.SH SEE ALSO
adj_lists
