.TH int2d G "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
int2d - definite 2D integral by quadrature and cubature method
.SH CALLING SEQUENCE
.nf
[I,err]=int2d(X,Y,f [,params])
.fi
.SH PARAMETERS
.TP 10
X 
: a 3 by N array containing the abscissae of the vertices
  of the N triangles.
.TP 10
Y 
: a 3 by N array containing the ordinates of the vertices
  of the N triangles.
.TP
f
: external (function or list or string) defining the integrand \fVf(u,v)\fR;
.TP
params
: real vector \fV[tol, iclose, maxtri, mevals, iflag]\fR. default
value is \fV[1.d-10, 1, 50, 4000, 1]\fR.
.RS
.TP
tol
:the desired bound on the error.  If \fViflag=0\fR,
\fVtol\fR is interpreted as a bound on the relative error;
if \fViflag=\fR1, the bound is on the absolute error.
.TP
iclose
:an integer parameter that determines the selection
of LQM0 or LQM1 methods.  If \fViclose=1\fR then LQM1 is used.
Any other value of \fViclose\fR causes LQM0 to be used.
LQM0 uses function values only at interior points of
the triangle.  LQM1 is usually more accurate than LQM0
but involves evaluating the integrand at more points
including some on the boundary of the triangle.  It
will usually be better to use LQM1 unless the integrand
has singularities on the boundary of the triangle.
.TP
maxtri
:the maximum number of triangles in the final triangulation of the
region
.TP
mevals
: the maximum number of function evaluations
to be allowed.  This number will be effective in limiting
the computation only if it is less than 94*\fVmaxtri\fR  when LQM1
is specified or 56*\fVmaxtri\fR when LQM0 is specified.
.TP
iflag
:
.RE
.TP
I
: the integral value
.TP
err
: the estimated error
.SH DESCRIPTION
\fVint2d\fR computes the two-dimensional integral of a
function \fVf\fR over a region consisting of \fVn\fR triangles.
A total error estimate is obtained and compared with a
tolerance - \fVtol\fR - that is provided as input to the subroutine.
The error tolerance is treated as either relative or absolute
depending on the input value of \fViflag\fR.  A 'Local Quadrature
Module' is applied to each input triangle and estimates of the
total integral and the total error are computed.  The local
quadrature module is either subroutine LQM0 or subroutine
LQM1 and the choice between them is determined by the
value of the input variable \fViclose\fR.

If the total error estimate exceeds the tolerance, the triangle
with the largest absolute error is divided into two triangles
by a median to its longest side.  The local quadrature module
is then applied to each of the subtriangles to obtain new
estimates of the integral and the error.  This process is
repeated until either (1) the error tolerance is satisfied,
(2) the number of triangles generated exceeds the input
parameter \fVmaxtri\fR, (3) the number of integrand evaluations
exceeds the input parameter \fVmevals\fR, or (4) the function
senses that roundoff error is beginning to contaminate
the result.
.SH EXAMPLES
.nf
X=[0,0;1,1;1,0];
Y=[0,0;0,1;1,1];
deff('z=f(x,y)','z=cos(x+y)')
[I,e]=int2d(X,Y,f)
// computes the integrand over the square [0 1]x[0 1]
.fi
.SH SEE ALSO
intc, intl, int3d, intg, mesh2d
.SH REFERENCES
Fortran routine twodq,Authors: Kahaner,D.K.,N.B.S., Rechard,O.W.,N.B.S.,
Barnhill,Robert,Univ. of UTAH
